/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import com.mojang.authlib.GameProfile;
import moe.plushie.armourers_workshop.utils.UtilItems;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;

public final class PlayerUtils {
    private PlayerUtils() {
        throw new IllegalAccessError("Utility class.");
    }

    public static boolean gameProfilesMatch(GameProfile profile1, GameProfile profile2) {
        if (profile1 == null) {
            return false;
        }
        if (profile2 == null) {
            return false;
        }
        if (profile1.getId() != null && profile2.getId() != null && profile1.getId().equals(profile2.getId())) {
            return true;
        }
        return profile1.getName() != null && profile2.getName() != null && profile1.getName().equals(profile2.getName());
    }

    public static EnumFacing getDirection(int x, int y, int z, EntityPlayer player) {
        return EnumFacing.func_82600_a((int)PlayerUtils.getOrientation(x, y, z, (EntityLivingBase)player));
    }

    public static int getOrientation(int x, int y, int z, EntityLivingBase entity) {
        int l;
        if (MathHelper.func_76135_e((float)((float)entity.field_70165_t - (float)x)) < 2.0f && MathHelper.func_76135_e((float)((float)entity.field_70161_v - (float)z)) < 2.0f) {
            double d0 = entity.field_70163_u + (double)entity.func_70047_e() - entity.func_70033_W();
            if (d0 - (double)y > 2.0) {
                return 1;
            }
            if ((double)y - d0 > 0.0) {
                return 0;
            }
        }
        return (l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) == 0 ? 3 : (l == 1 ? 4 : (l == 2 ? 2 : (l == 3 ? 5 : 0)));
    }

    public static EnumFacing getDirectionSide(EntityPlayer player) {
        return EnumFacing.func_82600_a((int)PlayerUtils.getOrientationSide((EntityLivingBase)player));
    }

    public static int getOrientationSide(EntityLivingBase entity) {
        int l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        return l == 0 ? 3 : (l == 1 ? 4 : (l == 2 ? 2 : (l == 3 ? 5 : 0)));
    }

    public static void giveItem(EntityPlayer player, ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (!player.field_71071_by.func_70441_a(stack) && !player.func_130014_f_().field_72995_K) {
            UtilItems.spawnItemInWorld(player.func_130014_f_(), player.field_70165_t, player.field_70163_u, player.field_70161_v, stack);
        }
    }
}

