/*
 * Decompiled with CFR 0.152.
 */
package com.camellias.gulliverreborn;

import com.artemis.artemislib.util.attributes.ArtemisLibAttributes;
import com.camellias.gulliverreborn.Config;
import com.camellias.gulliverreborn.GulliverReborn;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class MyResizeCommand
extends CommandBase {
    private final List<String> aliases = Lists.newArrayList((Object[])new String[]{"gulliverreborn", "mysize", "ms"});
    private static UUID uuidHeight = UUID.fromString("5440b01a-974f-4495-bb9a-c7c87424bca4");
    private static UUID uuidWidth = UUID.fromString("3949d2ed-b6cc-4330-9c13-98777f48ea51");
    private static UUID uuidReach1 = UUID.fromString("854e0004-c218-406c-a9e2-590f1846d80b");
    private static UUID uuidReach2 = UUID.fromString("216080dc-22d3-4eff-a730-190ec0210d5c");
    private static UUID uuidHealth = UUID.fromString("3b901d47-2d30-495c-be45-f0091c0f6fb2");
    private static UUID uuidStrength = UUID.fromString("558f55be-b277-4091-ae9b-056c7bc96e84");
    private static UUID uuidSpeed = UUID.fromString("f2fb5cda-3fbe-4509-a0af-4fc994e6aeca");

    public String func_71517_b() {
        return "mysize";
    }

    public String func_71518_a(ICommandSender sender) {
        return "gulliverreborn.commands.mysize.usage";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public int func_82362_a() {
        return 0;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        float size;
        if (args.length < 1) {
            return;
        }
        String s = args[0];
        try {
            size = Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Size Invalid"));
            return;
        }
        if (sender instanceof EntityPlayer) {
            size = MathHelper.func_76131_a((float)size, (float)0.125f, (float)Config.MAX_SIZE);
            HashMultimap attributes = HashMultimap.create();
            HashMultimap removeableAttributes = HashMultimap.create();
            HashMultimap removeableAttributes2 = HashMultimap.create();
            attributes.put((Object)ArtemisLibAttributes.ENTITY_HEIGHT.func_111108_a(), (Object)new AttributeModifier(uuidHeight, "Player Height", (double)(size - 1.0f), 2));
            attributes.put((Object)ArtemisLibAttributes.ENTITY_WIDTH.func_111108_a(), (Object)new AttributeModifier(uuidWidth, "Player Width", MathHelper.func_151237_a((double)(size - 1.0f), (double)-0.6, (double)Config.MAX_SIZE), 2));
            if (Config.SPEED_MODIFIER) {
                attributes.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(uuidSpeed, "Player Speed", (double)((size - 1.0f) / 2.0f), 2));
            }
            if (Config.REACH_MODIFIER) {
                removeableAttributes.put((Object)EntityPlayer.REACH_DISTANCE.func_111108_a(), (Object)new AttributeModifier(uuidReach1, "Player Reach 1", (double)(size - 1.0f), 2));
            }
            if (Config.REACH_MODIFIER) {
                removeableAttributes2.put((Object)EntityPlayer.REACH_DISTANCE.func_111108_a(), (Object)new AttributeModifier(uuidReach2, "Player Reach 2", -MathHelper.func_151237_a((double)(size - 1.0f), (double)0.33, (double)Double.MAX_VALUE), 2));
            }
            if (Config.STRENGTH_MODIFIER) {
                attributes.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(uuidStrength, "Player Strength", (double)(size - 1.0f), 0));
            }
            if (Config.HEALTH_MODIFIER) {
                attributes.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(uuidHealth, "Player Health", (double)((size - 1.0f) * Config.HEALTH_MULTIPLIER), 2));
            }
            if (size > 1.0f) {
                ((EntityPlayer)sender).func_110140_aT().func_111147_b((Multimap)removeableAttributes);
            } else {
                ((EntityPlayer)sender).func_110140_aT().func_111148_a((Multimap)removeableAttributes);
            }
            if (size < 1.0f) {
                ((EntityPlayer)sender).func_110140_aT().func_111147_b((Multimap)removeableAttributes2);
            } else {
                ((EntityPlayer)sender).func_110140_aT().func_111148_a((Multimap)removeableAttributes2);
            }
            ((EntityPlayer)sender).func_110140_aT().func_111147_b((Multimap)attributes);
            ((EntityPlayer)sender).func_70606_j(((EntityPlayer)sender).func_110138_aP());
            if (sender instanceof EntityPlayer) {
                GulliverReborn.LOGGER.info(((EntityPlayer)sender).getDisplayNameString() + " set their size to " + size);
            }
        }
    }
}

