/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import noppes.vc.CommonUtils;
import noppes.vc.VCArmors;
import noppes.vc.VCBlocks;
import noppes.vc.VCItems;
import noppes.vc.VCWeapons;

public class VCRecipes {
    public static List<RecipeContainer> List = new ArrayList<RecipeContainer>();
    private static IForgeRegistry<IRecipe> registry;

    public void addRecipe(RecipeContainer r, Object ob, Object ... recipe) {
        ItemStack item = ob instanceof Item ? new ItemStack((Item)ob) : (ob instanceof Block ? new ItemStack((Block)ob) : (ItemStack)ob);
        r.add(item, recipe);
    }

    public void addWoodenRecipes(Object ob, Object ... recipe) {
        RecipeContainer r = new RecipeContainer();
        ItemStack item = ob instanceof Item ? new ItemStack((Item)ob) : (ob instanceof Block ? new ItemStack((Block)ob) : (ItemStack)ob);
        for (int i = 0; i < 6; ++i) {
            ItemStack stack = item.func_77946_l();
            stack.func_77964_b(i);
            Object[] rec = Arrays.copyOf(recipe, recipe.length);
            for (int j = 0; j < rec.length; ++j) {
                if (rec[j] != null) continue;
                rec[j] = new ItemStack(Blocks.field_150344_f, 1, i);
            }
            r.add(stack, rec);
        }
    }

    public void addRecipes(Object ... recipe) {
        int i;
        RecipeContainer r = new RecipeContainer();
        HashMap<ItemStack, Object> obs = new HashMap<ItemStack, Object>();
        for (i = 0; i < recipe.length; i += 2) {
            ItemStack item;
            Object ob = recipe[i];
            if (ob instanceof Item) {
                item = new ItemStack((Item)ob);
            } else if (ob instanceof Block) {
                item = new ItemStack((Block)ob);
            } else {
                if (!(ob instanceof ItemStack)) break;
                item = (ItemStack)ob;
            }
            obs.put(item, recipe[i + 1]);
        }
        recipe = Arrays.copyOfRange(recipe, i, recipe.length);
        for (Map.Entry ent : obs.entrySet()) {
            Object[] rec = Arrays.copyOf(recipe, recipe.length);
            for (int j = 0; j < rec.length; ++j) {
                if (rec[j] != null) continue;
                rec[j] = ent.getValue();
            }
            r.add((ItemStack)ent.getKey(), rec);
        }
    }

    public void addSmelting(Object ob, ItemStack output, float experience) {
        ItemStack item = ob instanceof Item ? new ItemStack((Item)ob) : (ob instanceof Block ? new ItemStack((Block)ob) : (ItemStack)ob);
        FurnaceRecipes.func_77602_a().func_151394_a(item, output, experience);
        RecipeContainer c = new RecipeContainer();
        c.furnace(item, output);
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        List.clear();
        registry = event.getRegistry();
        this.loadDefaultRecipes();
    }

    public void loadDefaultRecipes() {
        registry.register(new RecipeReverse().setRegistryName("variedcommodities", "reverse_items"));
        this.addSmelting(Items.field_151042_j, new ItemStack(VCItems.ingot_steel), 0.35f);
        this.addRecipe(new RecipeContainer(), VCItems.vcrecipes_book, "XX", Character.valueOf('X'), Items.field_151122_aG);
        this.addRecipe(new RecipeContainer(), VCBlocks.carpentry_bench, "XYX", "Z Z", "Z Z", Character.valueOf('X'), Blocks.field_150344_f, Character.valueOf('Z'), Items.field_151055_y, Character.valueOf('Y'), Blocks.field_150462_ai);
        this.addRecipe(new RecipeContainer(), VCWeapons.mana, "XY", Character.valueOf('X'), Items.field_151137_ax, Character.valueOf('Y'), Items.field_151114_aO);
        this.addRecipe(new RecipeContainer(), new ItemStack(VCWeapons.bullet, 4), "X", Character.valueOf('X'), Items.field_151042_j);
        this.addRecipes(new ItemStack(VCBlocks.wall_banner, 1, 0), Blocks.field_150344_f, new ItemStack(VCBlocks.wall_banner, 1, 1), Blocks.field_150348_b, new ItemStack(VCBlocks.wall_banner, 1, 2), Items.field_151042_j, new ItemStack(VCBlocks.wall_banner, 1, 3), Items.field_151043_k, new ItemStack(VCBlocks.wall_banner, 1, 4), Items.field_151045_i, "XXX", "ZZZ", "ZZZ", "Z Z", Character.valueOf('Z'), Blocks.field_150325_L, Character.valueOf('X'), null);
        RecipeContainer r = new RecipeContainer();
        this.addRecipe(r, new ItemStack(VCBlocks.banner, 1, 0), " X ", " Z ", " Z ", "ZZZ", Character.valueOf('X'), new ItemStack(VCBlocks.wall_banner, 1, 0), Character.valueOf('Z'), Blocks.field_150344_f);
        this.addRecipe(r, new ItemStack(VCBlocks.banner, 1, 1), " X ", " Z ", " Z ", "ZZZ", Character.valueOf('X'), new ItemStack(VCBlocks.wall_banner, 1, 1), Character.valueOf('Z'), Blocks.field_150348_b);
        this.addRecipe(r, new ItemStack(VCBlocks.banner, 1, 2), " X ", " Z ", " Z ", "ZZZ", Character.valueOf('X'), new ItemStack(VCBlocks.wall_banner, 1, 2), Character.valueOf('Z'), Items.field_151042_j);
        this.addRecipe(r, new ItemStack(VCBlocks.banner, 1, 3), " X ", " Z ", " Z ", "ZZZ", Character.valueOf('X'), new ItemStack(VCBlocks.wall_banner, 1, 3), Character.valueOf('Z'), Items.field_151043_k);
        this.addRecipe(r, new ItemStack(VCBlocks.banner, 1, 4), " X ", " Z ", " Z ", "ZZZ", Character.valueOf('X'), new ItemStack(VCBlocks.wall_banner, 1, 4), Character.valueOf('Z'), Items.field_151045_i);
        this.addRecipes(new ItemStack(VCBlocks.tall_lamp, 1, 0), Blocks.field_150344_f, new ItemStack(VCBlocks.tall_lamp, 1, 1), Blocks.field_150348_b, new ItemStack(VCBlocks.tall_lamp, 1, 2), Items.field_151042_j, new ItemStack(VCBlocks.tall_lamp, 1, 3), Items.field_151043_k, new ItemStack(VCBlocks.tall_lamp, 1, 4), Items.field_151045_i, "YXY", " Z ", " Z ", "ZZZ", Character.valueOf('X'), Blocks.field_150478_aa, Character.valueOf('Y'), Blocks.field_150325_L, Character.valueOf('Z'), null);
        this.addWoodenRecipes(VCBlocks.chair, "  X", "  X", "XXX", "X X", Character.valueOf('X'), null);
        this.addWoodenRecipes(VCBlocks.crate, "XXXX", "X  X", "X  X", "XXXX", Character.valueOf('X'), null);
        this.addWoodenRecipes(VCBlocks.weapon_rack, "XXX", "XYX", "XYX", "XXX", Character.valueOf('X'), null, Character.valueOf('Y'), Items.field_151055_y);
        this.addWoodenRecipes(VCBlocks.couch_wood, "   X", "   X", "XXXX", "X  X", Character.valueOf('X'), null);
        this.addWoodenRecipes(VCBlocks.couch_wool, "  ZX", "  ZX", "ZZZX", "XXXX", Character.valueOf('X'), null, Character.valueOf('Z'), Blocks.field_150325_L);
        this.addWoodenRecipes(VCBlocks.table, "XXXX", "X  X", "X  X", "X  X", Character.valueOf('X'), null);
        this.addWoodenRecipes(VCBlocks.stool, "XXXX", " XX ", "X  X", Character.valueOf('X'), null);
        this.addWoodenRecipes(VCBlocks.barrel, "XXX", "X X", "X X", "XXX", Character.valueOf('X'), null);
        this.addWoodenRecipes(new ItemStack(VCBlocks.shelf, 3), "XXXX", "X Y ", "XY  ", Character.valueOf('Y'), Items.field_151055_y, Character.valueOf('X'), null);
        this.addWoodenRecipes(new ItemStack(VCBlocks.beam, 2), "XXXX", Character.valueOf('X'), null);
        this.addWoodenRecipes(new ItemStack(VCBlocks.sign, 3), "YYY", "XXX", "XXX", Character.valueOf('X'), null, Character.valueOf('Y'), Items.field_151042_j);
        this.addRecipe(new RecipeContainer(), new ItemStack(VCBlocks.lamp), "XXX", "Y Y", "YZY", "XXX", Character.valueOf('X'), Items.field_151042_j, Character.valueOf('Y'), Blocks.field_150359_w, Character.valueOf('Z'), Blocks.field_150478_aa);
        this.addRecipe(new RecipeContainer(), new ItemStack(VCBlocks.candle), "XZX", " X ", Character.valueOf('X'), Items.field_151042_j, Character.valueOf('Z'), Blocks.field_150478_aa);
        this.addRecipe(new RecipeContainer(), new ItemStack(VCBlocks.big_sign, 2), "XXX", "XXX", "XXX", Character.valueOf('X'), Blocks.field_150344_f);
        this.addRecipes(VCWeapons.wooden_gun, Blocks.field_150344_f, VCWeapons.stone_gun, Blocks.field_150348_b, VCWeapons.iron_gun, Items.field_151042_j, VCWeapons.golden_gun, Items.field_151043_k, VCWeapons.diamond_gun, Items.field_151045_i, VCWeapons.emerald_gun, Items.field_151166_bC, VCWeapons.bronze_gun, VCItems.ingot_bronze, "XXXY", " ZM ", "  M ", Character.valueOf('Y'), Blocks.field_150442_at, Character.valueOf('M'), Items.field_151055_y, Character.valueOf('Z'), Blocks.field_150430_aB, Character.valueOf('X'), null);
        this.addRecipes(VCWeapons.wooden_battleaxe, Blocks.field_150344_f, VCWeapons.stone_battleaxe, Blocks.field_150348_b, VCWeapons.iron_battleaxe, Items.field_151042_j, VCWeapons.golden_battleaxe, Items.field_151043_k, VCWeapons.diamond_battleaxe, Items.field_151045_i, VCWeapons.bronze_battleaxe, VCItems.ingot_bronze, VCWeapons.emerald_battleaxe, Items.field_151166_bC, VCWeapons.mithril_battleaxe, VCItems.ingot_mithril, VCWeapons.frost_battleaxe, Blocks.field_150403_cj, VCWeapons.demonic_battleaxe, VCItems.ingot_demonic, "XX", "XY", " Y", " Y", Character.valueOf('Y'), Items.field_151055_y, Character.valueOf('X'), null);
        this.addRecipes(VCWeapons.wooden_halberd, Blocks.field_150344_f, VCWeapons.stone_halberd, Blocks.field_150348_b, VCWeapons.iron_halberd, Items.field_151042_j, VCWeapons.golden_halberd, Items.field_151043_k, VCWeapons.diamond_halberd, Items.field_151045_i, VCWeapons.bronze_halberd, VCItems.ingot_bronze, VCWeapons.emerald_halberd, Items.field_151166_bC, VCWeapons.mithril_halberd, VCItems.ingot_mithril, VCWeapons.frost_halberd, Blocks.field_150403_cj, VCWeapons.demonic_halberd, VCItems.ingot_demonic, "XYX", "XY ", " Y ", " Y ", Character.valueOf('Y'), Items.field_151055_y, Character.valueOf('X'), null);
        this.addRecipes(VCWeapons.wooden_glaive, Blocks.field_150344_f, VCWeapons.stone_glaive, Blocks.field_150348_b, VCWeapons.iron_glaive, Items.field_151042_j, VCWeapons.golden_glaive, Items.field_151043_k, VCWeapons.diamond_glaive, Items.field_151045_i, VCWeapons.bronze_glaive, VCItems.ingot_bronze, VCWeapons.emerald_glaive, Items.field_151166_bC, VCWeapons.mithril_glaive, VCItems.ingot_mithril, VCWeapons.frost_glaive, Blocks.field_150403_cj, VCWeapons.demonic_glaive, VCItems.ingot_demonic, "   X", "  Y ", " Y  ", "X   ", Character.valueOf('Y'), Items.field_151055_y, Character.valueOf('X'), null);
        this.addRecipes(VCWeapons.wooden_trident, Blocks.field_150344_f, VCWeapons.stone_trident, Blocks.field_150348_b, VCWeapons.iron_trident, Items.field_151042_j, VCWeapons.golden_trident, Items.field_151043_k, VCWeapons.diamond_trident, Items.field_151045_i, VCWeapons.bronze_trident, VCItems.ingot_bronze, VCWeapons.emerald_trident, Items.field_151166_bC, VCWeapons.mithril_trident, VCItems.ingot_mithril, VCWeapons.frost_trident, Blocks.field_150403_cj, VCWeapons.demonic_trident, VCItems.ingot_demonic, "X X", " X ", " Y ", " Y ", Character.valueOf('Y'), Items.field_151055_y, Character.valueOf('X'), null);
        this.addRecipes(VCWeapons.wooden_scythe, Blocks.field_150344_f, VCWeapons.stone_scythe, Blocks.field_150348_b, VCWeapons.iron_scythe, Items.field_151042_j, VCWeapons.golden_scythe, Items.field_151043_k, VCWeapons.diamond_scythe, Items.field_151045_i, VCWeapons.bronze_scythe, VCItems.ingot_bronze, VCWeapons.emerald_scythe, Items.field_151166_bC, VCWeapons.mithril_scythe, VCItems.ingot_mithril, VCWeapons.frost_scythe, Blocks.field_150403_cj, VCWeapons.demonic_scythe, VCItems.ingot_demonic, "XXX", "  Y", "  Y", "  Y", Character.valueOf('Y'), Items.field_151055_y, Character.valueOf('X'), null);
        this.addRecipes(VCWeapons.wooden_warhammer, Blocks.field_150344_f, VCWeapons.stone_warhammer, Blocks.field_150348_b, VCWeapons.iron_warhammer, Items.field_151042_j, VCWeapons.golden_warhammer, Items.field_151043_k, VCWeapons.diamond_warhammer, Items.field_151045_i, VCWeapons.bronze_warhammer, VCItems.ingot_bronze, VCWeapons.emerald_warhammer, Items.field_151166_bC, VCWeapons.mithril_warhammer, VCItems.ingot_mithril, VCWeapons.frost_warhammer, Blocks.field_150403_cj, VCWeapons.demonic_warhammer, VCItems.ingot_demonic, "XXX", " Y ", " Y ", " Y ", Character.valueOf('Y'), Items.field_151055_y, Character.valueOf('X'), null);
        this.addRecipes(VCWeapons.wooden_spear, Blocks.field_150344_f, VCWeapons.stone_spear, Blocks.field_150348_b, VCWeapons.iron_spear, Items.field_151042_j, VCWeapons.golden_spear, Items.field_151043_k, VCWeapons.diamond_spear, Items.field_151045_i, VCWeapons.bronze_spear, VCItems.ingot_bronze, VCWeapons.emerald_spear, Items.field_151166_bC, VCWeapons.mithril_spear, VCItems.ingot_mithril, VCWeapons.frost_spear, Blocks.field_150403_cj, VCWeapons.demonic_spear, VCItems.ingot_demonic, "X", "Y", "Y", "Y", Character.valueOf('Y'), Items.field_151055_y, Character.valueOf('X'), null);
        this.addRecipes(VCWeapons.wooden_broadsword, Blocks.field_150344_f, VCWeapons.stone_broadsword, Blocks.field_150348_b, VCWeapons.iron_broadsword, Items.field_151042_j, VCWeapons.golden_broadsword, Items.field_151043_k, VCWeapons.diamond_broadsword, Items.field_151045_i, VCWeapons.bronze_broadsword, VCItems.ingot_bronze, VCWeapons.emerald_broadsword, Items.field_151166_bC, VCWeapons.mithril_broadsword, VCItems.ingot_mithril, VCWeapons.frost_broadsword, Blocks.field_150403_cj, VCWeapons.demonic_broadsword, VCItems.ingot_demonic, "X", "X", "X", "Y", Character.valueOf('Y'), Items.field_151055_y, Character.valueOf('X'), null);
        this.addRecipes(VCWeapons.wooden_dagger, Blocks.field_150344_f, VCWeapons.stone_dagger, Blocks.field_150348_b, VCWeapons.iron_dagger, Items.field_151042_j, VCWeapons.golden_dagger, Items.field_151043_k, VCWeapons.diamond_dagger, Items.field_151045_i, VCWeapons.bronze_dagger, VCItems.ingot_bronze, VCWeapons.emerald_dagger, Items.field_151166_bC, VCWeapons.mithril_dagger, VCItems.ingot_mithril, VCWeapons.frost_dagger, Blocks.field_150403_cj, VCWeapons.demonic_dagger, VCItems.ingot_demonic, " X", "Y ", Character.valueOf('Y'), Items.field_151055_y, Character.valueOf('X'), null);
        this.addRecipes(VCWeapons.bronze_sword, VCItems.ingot_bronze, VCWeapons.emerald_sword, Items.field_151166_bC, VCWeapons.mithril_sword, VCItems.ingot_mithril, VCWeapons.frost_sword, Blocks.field_150403_cj, VCWeapons.demonic_sword, VCItems.ingot_demonic, "X", "X", "Y", Character.valueOf('Y'), Items.field_151055_y, Character.valueOf('X'), null);
        this.addRecipes(VCWeapons.wooden_shield_round, Blocks.field_150344_f, VCWeapons.stone_shield_round, Blocks.field_150348_b, VCWeapons.iron_shield_round, Items.field_151042_j, VCWeapons.golden_shield_round, Items.field_151043_k, VCWeapons.diamond_shield_round, Items.field_151045_i, VCWeapons.bronze_shield_round, VCItems.ingot_bronze, VCWeapons.emerald_shield_round, Items.field_151166_bC, VCWeapons.mithril_shield_round, VCItems.ingot_mithril, VCWeapons.demonic_shield_round, VCItems.ingot_demonic, " XX ", "XXXX", "XXXX", " XX ", Character.valueOf('X'), null);
        this.addRecipes(VCWeapons.wooden_shield, Blocks.field_150344_f, VCWeapons.stone_shield, Blocks.field_150348_b, VCWeapons.iron_shield, Items.field_151042_j, VCWeapons.golden_shield, Items.field_151043_k, VCWeapons.diamond_shield, Items.field_151045_i, VCWeapons.bronze_shield, VCItems.ingot_bronze, VCWeapons.emerald_shield, Items.field_151166_bC, VCWeapons.frost_shield, Blocks.field_150403_cj, "X  X", "XXXX", "XXXX", " XX ", Character.valueOf('X'), null);
        this.addRecipes(VCArmors.chain_skirt, VCItems.ingot_bronze, VCArmors.leather_skirt, Items.field_151116_aA, VCArmors.iron_skirt, Items.field_151042_j, VCArmors.golden_skirt, Items.field_151043_k, VCArmors.diamond_skirt, Items.field_151045_i, VCArmors.bronze_skirt, VCItems.ingot_bronze, VCArmors.emerald_skirt, Items.field_151166_bC, VCArmors.mithril_skirt, VCItems.ingot_mithril, VCArmors.demonic_skirt, VCItems.ingot_demonic, " XX ", "XXXX", Character.valueOf('X'), null);
        this.addRecipes(VCArmors.mithril_head, VCItems.ingot_mithril, VCArmors.demonic_head, VCItems.ingot_demonic, "XXX", "X X", Character.valueOf('X'), null);
        this.addRecipes(VCArmors.mithril_chest, VCItems.ingot_mithril, VCArmors.demonic_chest, VCItems.ingot_demonic, "X X", "XXX", "XXX", Character.valueOf('X'), null);
        this.addRecipes(VCArmors.mithril_legs, VCItems.ingot_mithril, VCArmors.demonic_legs, VCItems.ingot_demonic, VCArmors.full_emerald_legs, Items.field_151166_bC, VCArmors.full_bronze_legs, VCItems.ingot_bronze, "XXX", "X X", "X X", Character.valueOf('X'), null);
        this.addRecipes(VCArmors.mithril_boots, VCItems.ingot_mithril, VCArmors.demonic_boots, VCItems.ingot_demonic, VCArmors.full_emerald_boots, Items.field_151166_bC, VCArmors.full_bronze_boots, VCItems.ingot_bronze, "X X", "X X", Character.valueOf('X'), null);
        this.addRecipes(VCArmors.full_leather_head, Items.field_151116_aA, VCArmors.full_iron_head, Items.field_151042_j, VCArmors.full_golden_head, Items.field_151043_k, VCArmors.full_diamond_head, Items.field_151045_i, VCArmors.full_bronze_head, VCItems.ingot_bronze, VCArmors.full_emerald_head, Items.field_151166_bC, VCArmors.full_wooden_head, Blocks.field_150364_r, VCArmors.full_wooden_head, Blocks.field_150363_s, "XXXX", "X  X", Character.valueOf('X'), null);
        this.addRecipes(VCArmors.full_leather_chest, Items.field_151116_aA, VCArmors.full_iron_chest, Items.field_151042_j, VCArmors.full_golden_chest, Items.field_151043_k, VCArmors.full_diamond_chest, Items.field_151045_i, VCArmors.full_bronze_chest, VCItems.ingot_bronze, VCArmors.full_emerald_chest, Items.field_151166_bC, VCArmors.full_wooden_chest, Blocks.field_150364_r, VCArmors.full_wooden_chest, Blocks.field_150363_s, "X X", "XXX", "XXX", "XXX", Character.valueOf('X'), null);
    }

    public static ItemStack match(InventoryCrafting inv, World worldIn) {
        for (IRecipe irecipe : registry.getValues()) {
            int j;
            int i;
            ShapedRecipes recipe;
            if (irecipe instanceof ShapedRecipes) {
                recipe = (ShapedRecipes)irecipe;
                for (i = 0; i <= 4 - recipe.field_77576_b; ++i) {
                    for (j = 0; j <= 4 - recipe.field_77577_c; ++j) {
                        if (!VCRecipes.checkMatch(recipe, inv, i, j, true) && !VCRecipes.checkMatch(recipe, inv, i, j, false)) continue;
                        return irecipe.func_77572_b(inv);
                    }
                }
                continue;
            }
            if (irecipe instanceof ShapedOreRecipe) {
                recipe = (ShapedOreRecipe)irecipe;
                for (i = 0; i <= 4 - recipe.getWidth(); ++i) {
                    for (j = 0; j <= 4 - recipe.getHeight(); ++j) {
                        if (!VCRecipes.checkMatch((ShapedOreRecipe)recipe, inv, i, j, true) && !VCRecipes.checkMatch((ShapedOreRecipe)recipe, inv, i, j, false)) continue;
                        return irecipe.func_77572_b(inv);
                    }
                }
                continue;
            }
            if (!irecipe.func_77569_a(inv, worldIn)) continue;
            return irecipe.func_77572_b(inv);
        }
        return ItemStack.field_190927_a;
    }

    private static boolean checkMatch(ShapedOreRecipe recipe, InventoryCrafting inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Ingredient target = Ingredient.field_193370_a;
                if (subX >= 0 && subY >= 0 && subX < recipe.getWidth() && subY < recipe.getHeight()) {
                    target = mirror ? (Ingredient)recipe.func_192400_c().get(recipe.getWidth() - subX - 1 + subY * recipe.getWidth()) : (Ingredient)recipe.func_192400_c().get(subX + subY * recipe.getWidth());
                }
                if (target.apply(inv.func_70463_b(x, y))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean checkMatch(ShapedRecipes recipe, InventoryCrafting p_77573_1_, int p_77573_2_, int p_77573_3_, boolean p_77573_4_) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int k = i - p_77573_2_;
                int l = j - p_77573_3_;
                Ingredient ingredient = Ingredient.field_193370_a;
                if (k >= 0 && l >= 0 && k < recipe.field_77576_b && l < recipe.field_77577_c) {
                    ingredient = p_77573_4_ ? (Ingredient)recipe.field_77574_d.get(recipe.field_77576_b - k - 1 + l * recipe.field_77576_b) : (Ingredient)recipe.field_77574_d.get(k + l * recipe.field_77576_b);
                }
                if (ingredient.apply(p_77573_1_.func_70463_b(i, j))) continue;
                return false;
            }
        }
        return true;
    }

    public class RecipeContainer {
        private LinkedHashMap<ItemStack, List<ItemStack>> items = new LinkedHashMap();
        public int width = 1;
        public int height = 1;
        public boolean isFurnace = false;

        public RecipeContainer() {
            List.add(this);
        }

        public void add(ItemStack output, Object[] params) {
            CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])params);
            IRecipe r = (IRecipe)new ShapedRecipes("variedcommodities", primer.width, primer.height, primer.input, output).setRegistryName(output.func_77973_b().getRegistryName() + "_" + output.func_77952_i());
            if (r.func_77571_b() == null || r.func_77571_b().func_190926_b()) {
                return;
            }
            ArrayList<ItemStack> input = new ArrayList<ItemStack>();
            if (r instanceof ShapedRecipes) {
                ShapedRecipes recipe = (ShapedRecipes)r;
                this.width = recipe.field_77576_b;
                this.height = recipe.field_77577_c;
                for (Ingredient in : recipe.field_77574_d) {
                    if (in == Ingredient.field_193370_a) {
                        input.add(ItemStack.field_190927_a);
                        continue;
                    }
                    Collections.addAll(input, in.func_193365_a());
                }
            }
            this.items.put(r.func_77571_b(), input);
            registry.register((IForgeRegistryEntry)r);
        }

        public void furnace(ItemStack input, ItemStack output) {
            this.isFurnace = true;
            this.add(input, output);
        }

        public void add(ItemStack input, ItemStack output) {
            ArrayList<ItemStack> l = new ArrayList<ItemStack>();
            l.add(input);
            this.items.put(output, l);
        }

        public ItemStack output() {
            int i = 0;
            if (this.items.size() > 1) {
                i = (int)(System.currentTimeMillis() / 2000L % (long)this.items.size());
            }
            for (Map.Entry<ItemStack, List<ItemStack>> entry : this.items.entrySet()) {
                if (i == 0) {
                    return entry.getKey();
                }
                --i;
            }
            return null;
        }

        public List<ItemStack> input() {
            int i = 0;
            if (this.items.size() > 1) {
                i = (int)(System.currentTimeMillis() / 2000L % (long)this.items.size());
            }
            for (Map.Entry<ItemStack, List<ItemStack>> entry : this.items.entrySet()) {
                if (i == 0) {
                    return entry.getValue();
                }
                --i;
            }
            return null;
        }

        public boolean isFurnace() {
            return this.isFurnace;
        }
    }

    class RecipeReverse
    extends IForgeRegistryEntry.Impl<IRecipe>
    implements IRecipe {
        private final Item[] items = new Item[]{VCWeapons.wooden_dagger, VCWeapons.wooden_dagger_reversed, VCWeapons.stone_dagger, VCWeapons.stone_dagger_reversed, VCWeapons.iron_dagger, VCWeapons.iron_dagger_reversed, VCWeapons.golden_dagger, VCWeapons.golden_dagger_reversed, VCWeapons.diamond_dagger, VCWeapons.diamond_dagger_reversed, VCWeapons.bronze_dagger, VCWeapons.bronze_dagger_reversed, VCWeapons.emerald_dagger, VCWeapons.emerald_dagger_reversed, VCWeapons.demonic_dagger, VCWeapons.demonic_dagger_reversed, VCWeapons.frost_dagger, VCWeapons.frost_dagger_reversed, VCWeapons.mithril_dagger, VCWeapons.mithril_dagger_reversed};

        public RecipeReverse() {
            RecipeContainer c = new RecipeContainer();
            for (int i = 0; i < this.items.length; i += 2) {
                c.add(new ItemStack(this.items[i]), new ItemStack(this.items[i + 1]));
                c.add(new ItemStack(this.items[i + 1]), new ItemStack(this.items[i]));
            }
        }

        public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
            return !this.func_77572_b(inv).func_190926_b();
        }

        public ItemStack func_77572_b(InventoryCrafting inv) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack itemstack = inv.func_70301_a(i);
                for (int j = 0; j < this.items.length; ++j) {
                    if (this.items[j] != itemstack.func_77973_b()) continue;
                    return CommonUtils.ChangeItemStack(itemstack, this.items[j + (j % 2 == 1 ? -1 : 1)]);
                }
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack func_77571_b() {
            return ItemStack.field_190927_a;
        }

        public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
            NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < nonnulllist.size(); ++i) {
                ItemStack itemstack = inv.func_70301_a(i);
                nonnulllist.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
            }
            return nonnulllist;
        }

        public boolean func_194133_a(int width, int height) {
            return width == 1 && height == 1;
        }
    }
}

