/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.CustomNpcs;
import noppes.npcs.Server;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.event.CustomGuiEvent;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.PlayerWrapper;
import noppes.npcs.api.wrapper.WrapperNpcAPI;
import noppes.npcs.api.wrapper.gui.CustomGuiWrapper;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.containers.ContainerCustomGui;

public class CustomGuiController {
    public static void openGui(PlayerWrapper player, CustomGuiWrapper gui) {
        ((EntityPlayerMP)player.getMCEntity()).openGui((Object)CustomNpcs.instance, EnumGuiType.CustomGui.ordinal(), (World)player.getWorld().getMCWorld(), gui.getSlots().size(), 0, 0);
        Server.sendDataChecked((EntityPlayerMP)player.getMCEntity(), EnumPacketClient.GUI_DATA, gui.toNBT());
        ((ContainerCustomGui)((EntityPlayerMP)player.getMCEntity()).field_71070_bA).setGui(gui, (EntityPlayer)player.getMCEntity());
    }

    public static boolean updateGui(PlayerWrapper player, CustomGuiWrapper gui) {
        if (((EntityPlayerMP)player.getMCEntity()).field_71070_bA instanceof ContainerCustomGui) {
            return Server.sendDataChecked((EntityPlayerMP)player.getMCEntity(), EnumPacketClient.GUI_DATA, gui.toNBT());
        }
        return false;
    }

    static boolean checkGui(CustomGuiEvent event) {
        Object player = event.player.getMCEntity();
        if (!(((EntityPlayer)player).field_71070_bA instanceof ContainerCustomGui)) {
            return false;
        }
        return ((ContainerCustomGui)((EntityPlayer)player).field_71070_bA).customGui.getID() == event.gui.getID();
    }

    public static IItemStack[] getSlotContents(EntityPlayer player) {
        IItemStack[] slotContents = new IItemStack[]{};
        if (player.field_71070_bA instanceof ContainerCustomGui) {
            ContainerCustomGui container = (ContainerCustomGui)player.field_71070_bA;
            slotContents = new IItemStack[container.guiInventory.func_70302_i_()];
            for (int i = 0; i < container.guiInventory.func_70302_i_(); ++i) {
                slotContents[i] = NpcAPI.Instance().getIItemStack(container.guiInventory.func_70301_a(i));
            }
        }
        return slotContents;
    }

    public static void onButton(CustomGuiEvent.ButtonEvent event) {
        Object player = event.player.getMCEntity();
        if (CustomGuiController.checkGui(event) && CustomGuiController.getOpenGui(player).getScriptHandler() != null) {
            CustomGuiController.getOpenGui(player).getScriptHandler().run(EnumScriptType.CUSTOM_GUI_BUTTON, event);
        }
        WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static void onSlotChange(CustomGuiEvent.SlotEvent event) {
        Object player = event.player.getMCEntity();
        if (CustomGuiController.checkGui(event) && CustomGuiController.getOpenGui(player).getScriptHandler() != null) {
            CustomGuiController.getOpenGui(player).getScriptHandler().run(EnumScriptType.CUSTOM_GUI_SLOT, event);
        }
        WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static boolean onSlotClick(CustomGuiEvent.SlotClickEvent event) {
        Object player = event.player.getMCEntity();
        if (CustomGuiController.checkGui(event) && CustomGuiController.getOpenGui(player).getScriptHandler() != null) {
            CustomGuiController.getOpenGui(player).getScriptHandler().run(EnumScriptType.CUSTOM_GUI_SLOT_CLICKED, event);
        }
        return WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static void onScrollClick(CustomGuiEvent.ScrollEvent event) {
        Object player = event.player.getMCEntity();
        if (CustomGuiController.checkGui(event) && CustomGuiController.getOpenGui(player).getScriptHandler() != null) {
            CustomGuiController.getOpenGui(player).getScriptHandler().run(EnumScriptType.CUSTOM_GUI_SCROLL, event);
        }
        WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static void onClose(CustomGuiEvent.CloseEvent event) {
        Object player = event.player.getMCEntity();
        CustomGuiWrapper gui = CustomGuiController.getOpenGui(player);
        if (CustomGuiController.checkGui(event) && CustomGuiController.getOpenGui(player).getScriptHandler() != null) {
            gui.getScriptHandler().run(EnumScriptType.CUSTOM_GUI_CLOSED, event);
        }
        WrapperNpcAPI.EVENT_BUS.post((Event)event);
    }

    public static CustomGuiWrapper getOpenGui(EntityPlayer player) {
        if (player.field_71070_bA instanceof ContainerCustomGui) {
            return ((ContainerCustomGui)player.field_71070_bA).customGui;
        }
        return null;
    }

    public static String[] readScrollSelection(ByteBuf buffer) {
        try {
            NBTTagList list = Server.readNBT(buffer).func_150295_c("selection", 8);
            String[] selection = new String[list.func_74745_c()];
            for (int i = 0; i < list.func_74745_c(); ++i) {
                selection[i] = ((NBTTagString)list.func_179238_g(i)).func_150285_a_();
            }
            return selection;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

