/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.accessory;

import lyon.aom.accessory.models.ModelCape;
import lyon.aom.accessory.models.ModelGoggles;
import lyon.aom.capabilities.accessory.IAccessory;
import lyon.aom.init.ItemInit;
import lyon.aom.items.ItemCape;
import lyon.aom.items.base_items.ItemAccessory;
import lyon.aom.utils.CustomModelBiped;
import lyon.aom.utils.Utils;
import lyon.aom.utils.enums.EnumAccessorySlot;
import lyon.aom.utils.render.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RenderAccessoryHandler {
    private static final ModelGoggles gogglesModel = new ModelGoggles(0.1f);
    private static final ModelBiped neckModel = new CustomModelBiped(0.57f);
    private static final ModelBiped eyepatchModel = new CustomModelBiped(0.05f);
    private static final ModelBiped bodyModel = new CustomModelBiped(0.55f);
    private static final ModelBiped standingCapeModel = new CustomModelBiped(0.59f);
    private static final ModelCape movingCapeModel = new ModelCape(0.59f);

    @SideOnly(value=Side.CLIENT)
    public static void render(RenderPlayerEvent.Post event) {
        EntityPlayer player;
        IAccessory accessory;
        if (event.getEntity() instanceof EntityPlayer && (accessory = Utils.getAccessory(player = (EntityPlayer)event.getEntity())) != null && !player.func_175149_v() && !player.func_82150_aj()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            if (player.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.0133f, (float)0.0f);
            }
            if (!accessory.getAccessory(EnumAccessorySlot.EYEPATCH).func_190926_b()) {
                RenderAccessoryHandler.renderEyepatch(accessory.getAccessory(EnumAccessorySlot.EYEPATCH), (ModelBiped)event.getRenderer().func_177087_b(), player, event.getPartialRenderTick());
            }
            if (!accessory.getAccessory(EnumAccessorySlot.GOOGLES).func_190926_b()) {
                RenderAccessoryHandler.renderGoggles(accessory.getAccessory(EnumAccessorySlot.GOOGLES), (ModelBiped)event.getRenderer().func_177087_b(), player, event.getPartialRenderTick());
            }
            if (!accessory.getAccessory(EnumAccessorySlot.NECK).func_190926_b()) {
                RenderAccessoryHandler.renderNeck(accessory.getAccessory(EnumAccessorySlot.NECK), (ModelBiped)event.getRenderer().func_177087_b(), player, event.getPartialRenderTick());
            }
            if (!accessory.getAccessory(EnumAccessorySlot.BODY).func_190926_b()) {
                RenderAccessoryHandler.renderBody(accessory.getAccessory(EnumAccessorySlot.BODY), (ModelBiped)event.getRenderer().func_177087_b(), player, event.getPartialRenderTick());
            }
            if (!accessory.getAccessory(EnumAccessorySlot.CAPE).func_190926_b()) {
                RenderAccessoryHandler.renderCape(accessory.getAccessory(EnumAccessorySlot.CAPE), accessory.isHoodEnabled(), (ModelBiped)event.getRenderer().func_177087_b(), player, event.getPartialRenderTick());
            }
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    private static void renderGoggles(ItemStack stack, ModelBiped playerModel, EntityPlayer player, float partialTicks) {
        if (stack.func_77973_b() instanceof ItemAccessory) {
            gogglesModel.func_178686_a((ModelBase)playerModel);
            RenderUtils.setRotationAngles((ModelBase)gogglesModel, (EntityLivingBase)player, partialTicks);
            Utils.copyRotationAngles(playerModel, gogglesModel);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(((ItemAccessory)stack.func_77973_b()).getModelTexture());
            gogglesModel.func_78088_a((Entity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0626f);
        }
    }

    private static void renderEyepatch(ItemStack stack, ModelBiped playerModel, EntityPlayer player, float partialTicks) {
        if (stack.func_77973_b() instanceof ItemAccessory) {
            eyepatchModel.func_178686_a((ModelBase)playerModel);
            RenderUtils.setRotationAngles((ModelBase)eyepatchModel, (EntityLivingBase)player, partialTicks);
            Utils.copyRotationAngles(playerModel, eyepatchModel);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(((ItemAccessory)stack.func_77973_b()).getModelTexture());
            eyepatchModel.func_78088_a((Entity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        }
    }

    private static void renderBody(ItemStack stack, ModelBiped playerModel, EntityPlayer player, float partialTicks) {
        if (stack.func_77973_b() instanceof ItemAccessory) {
            ModelBiped model = bodyModel;
            if (stack.func_77973_b() == ItemInit.ELDIAN_ARMBAND) {
                model = eyepatchModel;
                model.field_178723_h.field_78807_k = true;
            }
            model.func_178686_a((ModelBase)playerModel);
            RenderUtils.setRotationAngles((ModelBase)model, (EntityLivingBase)player, partialTicks);
            Utils.copyRotationAngles(playerModel, model);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(((ItemAccessory)stack.func_77973_b()).getModelTexture());
            model.func_78088_a((Entity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            if (stack.func_77973_b() == ItemInit.ELDIAN_ARMBAND) {
                model.field_178723_h.field_78807_k = false;
            }
        }
    }

    private static void renderNeck(ItemStack stack, ModelBiped playerModel, EntityPlayer player, float partialTicks) {
        if (stack.func_77973_b() instanceof ItemAccessory) {
            neckModel.func_178686_a((ModelBase)playerModel);
            RenderUtils.setRotationAngles((ModelBase)neckModel, (EntityLivingBase)player, partialTicks);
            Utils.copyRotationAngles(playerModel, neckModel);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(((ItemAccessory)stack.func_77973_b()).getModelTexture());
            neckModel.func_78088_a((Entity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        }
    }

    private static void renderCape(ItemStack stack, boolean isHoodEnabled, ModelBiped playerModel, EntityPlayer player, float partialTicks) {
        if (stack.func_77973_b() instanceof ItemCape) {
            ModelBiped model = null;
            ResourceLocation texture = null;
            float angle = RenderAccessoryHandler.getCapeRotationAngle(player, partialTicks);
            if (angle < 0.05f) {
                model = standingCapeModel;
                texture = isHoodEnabled ? ((ItemCape)stack.func_77973_b()).getTextureStandingWithHood() : ((ItemCape)stack.func_77973_b()).getTextureStandingWithoutHood();
            } else {
                model = movingCapeModel;
                texture = isHoodEnabled ? ((ItemCape)stack.func_77973_b()).getTextureMovingWithHood() : ((ItemCape)stack.func_77973_b()).getTextureMovingWithoutHood();
            }
            if (model != null && texture != null) {
                model.func_178686_a((ModelBase)playerModel);
                RenderUtils.setRotationAngles((ModelBase)model, (EntityLivingBase)player, partialTicks);
                Utils.copyRotationAngles(playerModel, model);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
                model.func_78088_a((Entity)player, angle, 0.0f, partialTicks, 0.0f, 0.0f, 0.0625f);
            }
        }
    }

    private static float getCapeRotationAngle(EntityPlayer player, float partialTicks) {
        if (Utils.getPlayerVelocity(player) > 0.01f) {
            float factor = 0.85f;
            if (player.func_184218_aH()) {
                factor = 0.35f;
            }
            Vec3d playerPos = new Vec3d((double)Utils.interpolate((float)player.field_70165_t, (float)player.field_70169_q, partialTicks), (double)Utils.interpolate((float)player.field_70163_u, (float)player.field_70167_r, partialTicks), (double)Utils.interpolate((float)player.field_70161_v, (float)player.field_70166_s, partialTicks));
            Vec3d chasingPos = new Vec3d((double)Utils.interpolate((float)player.field_71094_bP, (float)player.field_71091_bM, partialTicks), (double)Utils.interpolate((float)player.field_71095_bQ, (float)player.field_71096_bN, partialTicks), (double)Utils.interpolate((float)player.field_71085_bR, (float)player.field_71097_bO, partialTicks));
            Vec3d movementVec = playerPos.func_178788_d(chasingPos);
            float movement = (float)movementVec.func_72433_c() * factor;
            movement = (float)((double)movement * (movementVec.func_72430_b(player.func_70040_Z()) / (movementVec.func_72433_c() * player.func_70040_Z().func_72433_c())));
            movement = Math.max(0.0f, movement);
            movement = Math.min(movement, 1.0f);
            float angle = (float)Math.asin(movement);
            return angle;
        }
        return 0.0f;
    }
}

