/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.blocks.blast_furnace;

import java.util.Random;
import lyon.aom.Main;
import lyon.aom.blocks.base_blocks.BlockFakeBlock;
import lyon.aom.blocks.base_blocks.BlockMultiBlockStructure;
import lyon.aom.blocks.blast_furnace.TileEntityBlastFurnace;
import lyon.aom.init.BlockInit;
import lyon.aom.init.ItemInit;
import lyon.aom.utils.interfaces.IHasModel;
import lyon.aom.utils.render.UtilsRender;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBlastFurnace
extends BlockMultiBlockStructure
implements IHasModel {
    public static final AxisAlignedBB BLAST_FURNACE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0);
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");

    public BlockBlastFurnace(String name, Material material) {
        super(name, material);
        this.addFakeBlockToBeRegistered(new BlockFakeBlastFurnace(this, "block_fake_blast_furnace", material));
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149711_c(3.5f);
        this.func_149752_b(17.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
        this.addBlockToMultiBlockStructure(this.getFakeBlockFromClass(BlockFakeBlastFurnace.class), new BlockPos(0, 1, 0));
        BlockInit.BLOCKS.add(this);
        ItemInit.ITEMS.add((Item)new ItemBlockBlastFurnace("blast_furnace", this));
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (worldIn.field_72995_K && ((Boolean)stateIn.func_177229_b((IProperty)LIT)).booleanValue()) {
            if (rand.nextDouble() < 0.3) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 0.97f + rand.nextFloat() * 0.06f, false);
            }
            UtilsRender.Orientations orientation = UtilsRender.Orientations.getOrientationForFacing((EnumFacing)stateIn.func_177229_b((IProperty)FACING));
            double x = rand.nextDouble();
            double horizontalOffset = 0.1875;
            double verticalOffset = 0.125;
            double rHorizontalOffset = x * 10.0 / 16.0;
            double rVerticalOffset = rand.nextDouble() * (-0.16 * x * x + 1.6 * x) / 16.0;
            Vec3d v = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            v = v.func_178787_e(orientation.getNormVec().func_186678_a(0.5));
            v = v.func_178788_d(orientation.getXVec().func_186678_a(0.5));
            v = v.func_178787_e(orientation.getXVec().func_186678_a(horizontalOffset + rHorizontalOffset));
            v = v.func_178787_e(orientation.getYVec().func_186678_a(verticalOffset + rVerticalOffset));
            worldIn.func_175688_a(EnumParticleTypes.FLAME, v.field_72450_a, v.field_72448_b, v.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, v.field_72450_a, v.field_72448_b, v.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
            for (int i = 0; i < (int)(rand.nextDouble() * 30.0 + 30.0); ++i) {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.3, (double)pos.func_177952_p() + 0.5, 0.0, rand.nextDouble() * 0.1, 0.0, new int[0]);
            }
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            return 13;
        }
        return 0;
    }

    @Override
    public void onMultiBlockStructureHarvested(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!worldIn.field_72995_K && worldIn.func_175625_s(pos) instanceof TileEntityBlastFurnace) {
            ((TileEntityBlastFurnace)worldIn.func_175625_s(pos)).dropAll();
        }
    }

    @Override
    public void onMultiBlockStructureDestroyedByExplosion(World worldIn, BlockPos pos, Explosion explosionIn) {
        if (!worldIn.field_72995_K && worldIn.func_175625_s(pos) instanceof TileEntityBlastFurnace) {
            ((TileEntityBlastFurnace)worldIn.func_175625_s(pos)).dropAll();
        }
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K && this.belongsBlockToMultiBlockStructure((IBlockAccess)worldIn, state, pos)) {
            BlockPos offset = this.getOffsetFromMultiStructureBlock((IBlockAccess)worldIn, state, pos);
            return this.onMultiBlockStructureActivated(worldIn, pos.func_177982_a(-offset.func_177958_n(), -offset.func_177956_o(), -offset.func_177952_p()), worldIn.func_180495_p(pos.func_177982_a(-offset.func_177958_n(), -offset.func_177956_o(), -offset.func_177952_p())), playerIn, hand, facing, hitX, hitY, hitZ);
        }
        return true;
    }

    @Override
    public boolean onMultiBlockStructureActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            playerIn.openGui((Object)Main.instance, 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public static void setState(boolean lit, World worldIn, BlockPos pos) {
        if (!worldIn.field_72995_K) {
            IBlockState state = worldIn.func_180495_p(pos);
            TileEntity tileentity = worldIn.func_175625_s(pos);
            worldIn.func_180501_a(pos, BlockInit.BLAST_FURNACE.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(lit)), 3);
            if (tileentity != null) {
                tileentity.func_145829_t();
                worldIn.func_175690_a(pos, tileentity);
            }
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityBlastFurnace();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, LIT});
    }

    public IBlockState func_176203_a(int meta) {
        boolean lit;
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        boolean bl = lit = meta > EnumFacing.values().length;
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(lit));
    }

    public int func_176201_c(IBlockState state) {
        return EnumFacing.values().length * ((Boolean)state.func_177229_b((IProperty)LIT) != false ? 1 : 0) + ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BLAST_FURNACE_AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.MIDDLE_POLE_THICK;
    }

    @Override
    public void registerModels() {
        Main.proxy.registerItemRenderer(Item.func_150898_a((Block)this), 0, "inventory");
    }

    private class ItemBlockBlastFurnace
    extends ItemBlock {
        public ItemBlockBlastFurnace(String name, Block block) {
            super(block);
            this.func_77655_b(name);
            this.setRegistryName("aom", name);
        }

        public boolean func_77662_d() {
            return false;
        }
    }

    private class BlockFakeBlastFurnace
    extends BlockFakeBlock {
        public BlockFakeBlastFurnace(BlockMultiBlockStructure mainBlock, String name, Material material) {
            super(mainBlock, name, material);
        }
    }
}

