/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.blocks.blast_furnace;

import lyon.aom.blocks.blast_furnace.BlockBlastFurnace;
import lyon.aom.recipes.BlastFurnaceRecipes;
import lyon.aom.utils.WrapperItemStackHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityBlastFurnace
extends TileEntity
implements ITickable {
    private ItemStackHandler itemHandler = new ItemStackHandler(4);
    private String customName;
    private int experienceStored = 0;
    private int burnTime;
    private int currentBurnTime;
    private int cookTime;
    private int totalCookTime = -1;

    public void dropAll() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i) == ItemStack.field_190927_a) continue;
            this.func_145831_w().func_72838_d((Entity)new EntityItem(this.func_145831_w(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), this.itemHandler.getStackInSlot(i)));
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)new BlastFurnaceItemStackHandlerWrapper());
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCustomName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public ITextComponent func_145748_c_() {
        return this.hasCustomName() ? new TextComponentString(this.customName) : new TextComponentTranslation("container.blast_furnace.name", new Object[0]);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.itemHandler.deserializeNBT(compound.func_74775_l("Inventory"));
        this.burnTime = compound.func_74762_e("BurnTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.totalCookTime = compound.func_74762_e("CookTimeTotal");
        this.experienceStored = compound.func_74762_e("ExperienceStored");
        this.currentBurnTime = compound.func_74762_e("CurrentBurnTime");
        if (compound.func_150297_b("CustomName", 8)) {
            this.setCustomName(compound.func_74779_i("CustomName"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", this.burnTime);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("CookTimeTotal", this.totalCookTime);
        compound.func_74768_a("ExperienceStored", this.experienceStored);
        compound.func_74768_a("CurrentBurnTime", this.currentBurnTime);
        compound.func_74782_a("Inventory", (NBTBase)this.itemHandler.serializeNBT());
        if (this.hasCustomName()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(TileEntityBlastFurnace te) {
        return te.getField(0) > 0;
    }

    public void func_73660_a() {
        int time;
        if (this.isBurning()) {
            --this.burnTime;
            BlockBlastFurnace.setState(true, this.field_145850_b, this.field_174879_c);
        } else {
            this.cookTime = 0;
            BlockBlastFurnace.setState(false, this.field_145850_b, this.field_174879_c);
        }
        ItemStack[] inputs = new ItemStack[]{this.itemHandler.getStackInSlot(0), this.itemHandler.getStackInSlot(1)};
        ItemStack fuel = this.itemHandler.getStackInSlot(2);
        if ((this.isBurning() || !fuel.func_190926_b()) && !this.isBurning() && this.canSmelt()) {
            this.currentBurnTime = this.burnTime = TileEntityBlastFurnace.getItemBurnTime(fuel);
            if (this.isBurning() && !fuel.func_190926_b()) {
                Item item = fuel.func_77973_b();
                fuel.func_190918_g(1);
                if (fuel.func_190926_b()) {
                    ItemStack item1 = item.getContainerItem(fuel);
                    this.itemHandler.setStackInSlot(2, item1);
                }
            }
        }
        if ((time = BlastFurnaceRecipes.getInstance().getCookTime(inputs[0], inputs[1])) < 0 || time != this.totalCookTime) {
            this.totalCookTime = -1;
            this.cookTime = 0;
        }
        if (this.isBurning() && this.cookTime > 0) {
            if (!this.canSmelt()) {
                this.cookTime = 0;
                return;
            }
            ++this.cookTime;
            if (this.cookTime == this.totalCookTime) {
                if (!this.field_145850_b.field_72995_K) {
                    this.itemHandler.insertItem(3, this.getResult(), false);
                }
                inputs[0].func_190918_g(1);
                inputs[1].func_190918_g(1);
                this.experienceStored = (int)((float)this.experienceStored + BlastFurnaceRecipes.getInstance().getExperience(inputs[0], inputs[1]).floatValue());
                this.cookTime = 0;
            }
        } else if (this.canSmelt() && this.isBurning() && time >= 0) {
            ++this.cookTime;
            this.totalCookTime = time;
        }
    }

    private ItemStack getResult() {
        ItemStack result = ItemStack.field_190927_a;
        ItemStack stack = this.itemHandler.getStackInSlot(3);
        int spaceLeft = 0;
        int slotLimit = this.itemHandler.getSlotLimit(3);
        if (!stack.func_190926_b() && stack.func_77976_d() < slotLimit) {
            slotLimit = stack.func_77976_d();
        }
        spaceLeft = stack.func_190926_b() ? slotLimit : slotLimit - stack.func_190916_E();
        result = BlastFurnaceRecipes.getInstance().getResult(this.itemHandler.getStackInSlot(0), this.itemHandler.getStackInSlot(1), spaceLeft);
        return result;
    }

    private boolean canSmelt() {
        ItemStack result = this.getResult();
        if (result.func_190926_b()) {
            return false;
        }
        ItemStack output = this.itemHandler.getStackInSlot(3);
        if (output.func_190926_b()) {
            return true;
        }
        if (!output.func_77969_a(result)) {
            return false;
        }
        int res = output.func_190916_E() + result.func_190916_E();
        return res <= 64 && res <= output.func_77976_d();
    }

    public static int getItemBurnTime(ItemStack fuel) {
        if (fuel.func_190926_b()) {
            return 0;
        }
        Item item = fuel.func_77973_b();
        if (item == Items.field_151129_at) {
            return 20000;
        }
        return 0;
    }

    public static boolean isItemFuel(ItemStack fuel) {
        return TileEntityBlastFurnace.getItemBurnTime(fuel) > 0;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.burnTime;
            }
            case 1: {
                return this.currentBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.burnTime = value;
                break;
            }
            case 1: {
                this.currentBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    public int getExperienceStored() {
        return this.experienceStored;
    }

    public void setExperienceStored(int e) {
        if (e >= 0) {
            this.experienceStored = e;
        }
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    private class BlastFurnaceItemStackHandlerWrapper
    extends WrapperItemStackHandler {
        public BlastFurnaceItemStackHandlerWrapper() {
            super(TileEntityBlastFurnace.this.itemHandler);
            this.addSlot(0, new Item[]{Item.func_150898_a((Block)Blocks.field_150343_Z)}, false);
            this.addSlot(1, new Item[]{Items.field_151042_j}, false);
            this.addSlot(2, new Item[]{Items.field_151129_at}, true);
            this.addSlot(3, null, true);
        }

        @Override
        public boolean canTakeStack(int index) {
            if (!super.canTakeStack(index)) {
                return false;
            }
            if (index == 2) {
                return TileEntityBlastFurnace.this.itemHandler.getStackInSlot(index).func_77973_b() == Items.field_151133_ar;
            }
            return true;
        }
    }
}

