/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.blocks.pipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lyon.aom.blocks.base_blocks.BlockBase;
import lyon.aom.blocks.pipe.TileEntityPipe;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class BlockPipe
extends BlockBase {
    public static final AxisAlignedBB PIPE_AABB = new AxisAlignedBB(0.34375, 0.34375, 0.34375, 0.65625, 0.65625, 0.65625);
    public static final AxisAlignedBB NORTH_SOUTH_AABB = new AxisAlignedBB(0.34375, 0.34375, 0.375, 0.65625, 0.65625, 0.0);
    public static final AxisAlignedBB EAST_WEST_AABB = new AxisAlignedBB(0.625, 0.34375, 0.34375, 1.0, 0.65625, 0.65625);
    public static final AxisAlignedBB UP_DOWN_AABB = new AxisAlignedBB(0.34375, 0.625, 0.34375, 0.65625, 1.0, 0.65625);
    public static final Map<EnumFacing, PropertyBool> CONNECTIONS = Collections.unmodifiableMap(Stream.of(EnumFacing.values()).collect(Collectors.toMap(e -> e, e -> PropertyBool.func_177716_a((String)e.func_176610_l()))));

    public BlockPipe(String name, Material material) {
        super(name, material);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149713_g(100);
        IBlockState state = this.field_176227_L.func_177621_b();
        for (int i = 0; i < CONNECTIONS.size(); ++i) {
            state = state.func_177226_a((IProperty)CONNECTIONS.get(EnumFacing.values()[i]), (Comparable)Boolean.valueOf(true));
        }
        this.func_180632_j(state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity != null && tileentity instanceof TileEntityPipe && ((TileEntityPipe)tileentity).hasNetwork()) {
            ((TileEntityPipe)tileentity).getNetwork().updatePipe((TileEntityPipe)tileentity);
            ((TileEntityPipe)tileentity).updateConnections();
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity != null && tileentity instanceof TileEntityPipe && ((TileEntityPipe)tileentity).hasNetwork()) {
            ((TileEntityPipe)tileentity).getNetwork().resetNetwork();
        }
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity != null && tileentity instanceof TileEntityPipe && ((TileEntityPipe)tileentity).hasNetwork()) {
            ((TileEntityPipe)tileentity).getNetwork().resetNetwork();
        }
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity != null && tileentity instanceof TileEntityPipe && ((TileEntityPipe)tileentity).hasNetwork()) {
            ((TileEntityPipe)tileentity).getNetwork().resetNetwork();
        }
    }

    public static boolean canConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        TileEntity tileentity1 = world.func_175625_s(pos);
        TileEntity tileentity2 = world.func_175625_s(pos.func_177967_a(facing, 1));
        if (tileentity1 != null && tileentity2 != null && tileentity1.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing) && tileentity2.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())) {
            IFluidHandler pipe = (IFluidHandler)tileentity1.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
            IFluidHandler connectTo = (IFluidHandler)tileentity2.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d());
            for (int i = 0; i < connectTo.getTankProperties().length; ++i) {
                if (!BlockPipe.areTanksCompatible(pipe.getTankProperties()[0], connectTo.getTankProperties()[i])) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean areTanksCompatible(IFluidTankProperties tank1, IFluidTankProperties tank2) {
        return !(tank1 == null || tank2 == null || !tank1.canDrain() && !tank1.canFill() || !tank2.canDrain() && !tank2.canFill() || (tank1.getContents() != null || tank2.getContents() != null) && (tank1.getContents() == null || !tank2.canFillFluidType(tank1.getContents()) && !tank2.canDrainFluidType(tank1.getContents())) && (tank2.getContents() == null || !tank1.canFillFluidType(tank2.getContents()) && !tank1.canDrainFluidType(tank2.getContents())));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        for (int i = 0; i < CONNECTIONS.size(); ++i) {
            TileEntity tileentity = worldIn.func_175625_s(pos.func_177967_a(EnumFacing.values()[i], 1));
            state = tileentity != null && BlockPipe.canConnectTo(worldIn, pos, EnumFacing.values()[i]) ? state.func_177226_a((IProperty)CONNECTIONS.get(EnumFacing.values()[i]), (Comparable)Boolean.valueOf(true)) : state.func_177226_a((IProperty)CONNECTIONS.get(EnumFacing.values()[i]), (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public List<EnumFacing> getConnectedFaces(IBlockState state, World world, BlockPos pos) {
        ArrayList<EnumFacing> faces = new ArrayList<EnumFacing>();
        state = this.func_176221_a(state, (IBlockAccess)world, pos);
        for (int i = 0; i < EnumFacing.values().length; ++i) {
            if (!((Boolean)state.func_177229_b((IProperty)CONNECTIONS.get(EnumFacing.values()[i]))).booleanValue()) continue;
            faces.add(EnumFacing.values()[i]);
        }
        return faces;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        if (!isActualState) {
            state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        }
        BlockPipe.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)PIPE_AABB);
        if (((Boolean)state.func_177229_b((IProperty)CONNECTIONS.get(EnumFacing.NORTH))).booleanValue() || ((Boolean)state.func_177229_b((IProperty)CONNECTIONS.get(EnumFacing.SOUTH))).booleanValue()) {
            BlockPipe.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_SOUTH_AABB.func_72317_d(0.0, 0.0, (Boolean)state.func_177229_b((IProperty)CONNECTIONS.get(EnumFacing.SOUTH)) != false ? 0.625 : 0.0));
        }
        if (((Boolean)state.func_177229_b((IProperty)CONNECTIONS.get(EnumFacing.EAST))).booleanValue() || ((Boolean)state.func_177229_b((IProperty)CONNECTIONS.get(EnumFacing.WEST))).booleanValue()) {
            BlockPipe.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_WEST_AABB.func_72317_d((Boolean)state.func_177229_b((IProperty)CONNECTIONS.get(EnumFacing.WEST)) != false ? -0.625 : 0.0, 0.0, 0.0));
        }
        if (((Boolean)state.func_177229_b((IProperty)CONNECTIONS.get(EnumFacing.UP))).booleanValue() || ((Boolean)state.func_177229_b((IProperty)CONNECTIONS.get(EnumFacing.DOWN))).booleanValue()) {
            BlockPipe.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)UP_DOWN_AABB.func_72317_d(0.0, (Boolean)state.func_177229_b((IProperty)CONNECTIONS.get(EnumFacing.DOWN)) != false ? -0.625 : 0.0, 0.0));
        }
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, CONNECTIONS.values().toArray(new IProperty[0]));
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.CENTER;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityPipe();
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        AxisAlignedBB box1 = this.func_185496_a(state, (IBlockAccess)worldIn, pos);
        AxisAlignedBB box2 = new AxisAlignedBB(box1.field_72340_a, box1.field_72338_b, box1.field_72339_c, box1.field_72336_d, box1.field_72337_e, box1.field_72334_f);
        for (int i = 0; i < CONNECTIONS.size(); ++i) {
            if (!((Boolean)state.func_177229_b((IProperty)CONNECTIONS.get(EnumFacing.values()[i]))).booleanValue()) continue;
            EnumFacing facing = EnumFacing.values()[i];
            box2 = box2.func_72321_a((double)facing.func_176730_m().func_177958_n() * 5.5 / 16.0, (double)facing.func_176730_m().func_177956_o() * 5.5 / 16.0, (double)facing.func_176730_m().func_177952_p() * 5.5 / 16.0);
        }
        return box2.func_186670_a(pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PIPE_AABB;
    }
}

