/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.blocks.pipe;

import java.util.ArrayList;
import java.util.List;
import lyon.aom.blocks.pipe.PipeNetwork;
import lyon.aom.capabilities.fluid_tank.FluidTank;
import lyon.aom.capabilities.fluid_tank.FluidTankPipe;
import lyon.aom.capabilities.fluid_tank.FluidTankStorage;
import lyon.aom.utils.Utils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityPipe
extends TileEntity
implements ITickable {
    private FluidTank fluidTank = new FluidTankPipe();
    private PipeNetwork network;
    private List<IFluidHandler> pipes = new ArrayList<IFluidHandler>();
    private List<IFluidHandler> consumers = new ArrayList<IFluidHandler>();
    private List<IFluidHandler> producers = new ArrayList<IFluidHandler>();
    private final int maxFluidPerTick = 6;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.fluidTank.sendChanges(null, this.fluidTank.getNBTForSync(this, null));
            if (!this.hasNetwork()) {
                this.updateConnections();
                List<TileEntityPipe> pipes = this.getConnectedPipes();
                if (pipes == null || pipes.isEmpty()) {
                    this.addThisToNetwork(new PipeNetwork());
                } else {
                    boolean foundPipeWithNetwork = false;
                    for (int i = 0; i < pipes.size(); ++i) {
                        if (!pipes.get(i).hasNetwork()) continue;
                        foundPipeWithNetwork = true;
                        if (!this.hasNetwork()) {
                            this.addThisToNetwork(pipes.get(i).getNetwork());
                            continue;
                        }
                        if (pipes.get(i).getNetwork() == this.getNetwork()) continue;
                        this.network.addNetworkToThis(pipes.get(i).getNetwork());
                    }
                    if (!foundPipeWithNetwork) {
                        this.addThisToNetwork(new PipeNetwork());
                    }
                }
            }
            if (this.network.canTransportFluid()) {
                int a;
                if (!this.producers.isEmpty()) {
                    if (this.network.getFluid() == null && this.fluidTank.getFluid() == null) {
                        block1: for (int i = 0; i < this.producers.size(); ++i) {
                            for (int a2 = 0; a2 < this.producers.get(i).getTankProperties().length; ++a2) {
                                if (this.producers.get(i).getTankProperties()[a2].getContents() == null || this.producers.get(i).getTankProperties()[a2].getContents().getFluid() == null || !this.fluidTank.getTankProperties()[0].canFillFluidType(this.producers.get(i).getTankProperties()[a2].getContents())) continue;
                                this.network.setFluid(this.producers.get(i).getTankProperties()[a2].getContents().getFluid());
                                continue block1;
                            }
                        }
                    } else if (this.network.getFluid() == null && this.fluidTank.getFluid() != null) {
                        this.network.setFluid(this.fluidTank.getFluid().getFluid());
                    }
                    if (this.network.getFluid() != null) {
                        int i;
                        int drainedLastRound;
                        int[] drains = new int[this.producers.size()];
                        int toDrain = Math.min(this.maxFluidPerTick, this.fluidTank.getCapacity() - (this.fluidTank.getFluid() != null ? this.fluidTank.getFluid().amount : 0));
                        do {
                            drainedLastRound = 0;
                            int drainPerProducer = toDrain / this.producers.size();
                            for (i = 0; i < this.producers.size(); ++i) {
                                FluidStack f = this.producers.get(i).drain(new FluidStack(this.network.getFluid(), this.fluidTank.getCapacity()), false);
                                if (f == null) continue;
                                int canDrain = f.amount;
                                a = Math.min(canDrain, drainPerProducer);
                                int n = i;
                                drains[n] = drains[n] + a;
                                drainedLastRound += a;
                                toDrain -= a;
                            }
                        } while (toDrain > 0 && drainedLastRound > 0);
                        int b = 0;
                        for (i = 0; i < drains.length; ++i) {
                            if (drains[i] == 0) continue;
                            b += this.producers.get((int)i).drain((FluidStack)new FluidStack((Fluid)this.network.getFluid(), (int)drains[i]), (boolean)true).amount;
                        }
                        this.fluidTank.fill(new FluidStack(this.network.getFluid(), b), true);
                    }
                }
                if (this.network.getFluid() != null) {
                    int toFill;
                    int filled = 0;
                    if (!this.consumers.isEmpty() && this.fluidTank.getTankProperties()[0].getContents() != null) {
                        int i;
                        int filledLastRound;
                        int[] fills = new int[this.consumers.size()];
                        toFill = Math.min(this.maxFluidPerTick, this.fluidTank.getFluid() != null ? this.fluidTank.getFluid().amount : 0);
                        do {
                            filledLastRound = 0;
                            int fillPerProducer = toFill / this.consumers.size();
                            i = 0;
                            while (i < this.consumers.size()) {
                                int canFill = this.consumers.get(i).fill(new FluidStack(this.network.getFluid(), this.fluidTank.getCapacity()), false);
                                a = Math.min(canFill, fillPerProducer);
                                int n = i++;
                                fills[n] = fills[n] + a;
                                filledLastRound += a;
                                toFill -= a;
                            }
                        } while (toFill > 0 && filledLastRound > 0);
                        int b = 0;
                        for (i = 0; i < fills.length; ++i) {
                            if (fills[i] == 0) continue;
                            b += this.consumers.get(i).fill(new FluidStack(this.network.getFluid(), fills[i]), true);
                        }
                        filled = b;
                        this.fluidTank.drain(new FluidStack(this.network.getFluid(), b), true);
                    }
                    if (!this.pipes.isEmpty() && this.fluidTank.getTankProperties()[0].getContents() != null) {
                        int filledLastRound;
                        int[] fills = new int[this.pipes.size()];
                        int x = toFill = Math.min(this.maxFluidPerTick - filled, this.fluidTank.getFluid() != null ? this.fluidTank.getFluid().amount : 0);
                        do {
                            filledLastRound = 0;
                            for (int i = 0; i < this.pipes.size(); ++i) {
                                if (((FluidTank)this.pipes.get(i)).getFluidAmount() + fills[i] >= this.fluidTank.getFluidAmount() - Utils.getArraySum(fills)) continue;
                                int a3 = 1;
                                int n = i;
                                fills[n] = fills[n] + a3;
                                filledLastRound += a3;
                                toFill -= a3;
                            }
                        } while (toFill > 0 && filledLastRound > 0);
                        int b = 0;
                        for (int i = 0; i < fills.length; ++i) {
                            if (fills[i] == 0) continue;
                            b += this.pipes.get(i).fill(new FluidStack(this.network.getFluid(), fills[i]), true);
                        }
                        this.fluidTank.drain(new FluidStack(this.network.getFluid(), b), true);
                    }
                }
            }
        }
    }

    public void updateConnections() {
        this.pipes.clear();
        this.consumers.clear();
        this.producers.clear();
        for (int i = 0; i < EnumFacing.values().length; ++i) {
            if (this.isPipe(EnumFacing.values()[i])) {
                this.pipes.add((IFluidHandler)this.field_145850_b.func_175625_s(this.field_174879_c.func_177967_a(EnumFacing.values()[i], 1)).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.values()[i].func_176734_d()));
                continue;
            }
            if (this.isConsumer(EnumFacing.values()[i])) {
                this.consumers.add((IFluidHandler)this.field_145850_b.func_175625_s(this.field_174879_c.func_177967_a(EnumFacing.values()[i], 1)).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.values()[i].func_176734_d()));
                continue;
            }
            if (!this.isProducer(EnumFacing.values()[i])) continue;
            this.producers.add((IFluidHandler)this.field_145850_b.func_175625_s(this.field_174879_c.func_177967_a(EnumFacing.values()[i], 1)).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.values()[i].func_176734_d()));
        }
    }

    public PipeNetwork getNetwork() {
        return this.network;
    }

    public boolean hasNetwork() {
        return this.network != null;
    }

    public List<TileEntityPipe> getConnectedPipes() {
        ArrayList<TileEntityPipe> pipes = new ArrayList<TileEntityPipe>();
        for (int i = 0; i < EnumFacing.values().length; ++i) {
            TileEntity tileentity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177967_a(EnumFacing.values()[i], 1));
            if (tileentity == null || !(tileentity instanceof TileEntityPipe)) continue;
            pipes.add((TileEntityPipe)tileentity);
        }
        return pipes;
    }

    public void addThisToNetwork(PipeNetwork network) {
        this.network = network;
        this.network.addPipeToNetwork(this);
    }

    public void resetNetwork() {
        this.network = null;
    }

    public boolean areProducerAndConsumerTheSame() {
        for (int i = 0; i < EnumFacing.values().length; ++i) {
            if (!(this.isProducer(EnumFacing.values()[i]) ^ this.isConsumer(EnumFacing.values()[i]))) continue;
            return false;
        }
        return true;
    }

    public boolean isConnectedToProducer() {
        for (int i = 0; i < EnumFacing.values().length; ++i) {
            if (!this.isProducer(EnumFacing.values()[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isConnectedToConsumer() {
        for (int i = 0; i < EnumFacing.values().length; ++i) {
            if (!this.isConsumer(EnumFacing.values()[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isConsumer(EnumFacing facing) {
        TileEntity tileentity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177967_a(facing, 1));
        if (tileentity != null && tileentity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())) {
            IFluidHandler handler = (IFluidHandler)tileentity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d());
            for (int i = 0; i < handler.getTankProperties().length; ++i) {
                if (!handler.getTankProperties()[i].canFill() || tileentity instanceof TileEntityPipe || this.fluidTank.getFluid() != null && !handler.getTankProperties()[i].canFillFluidType(this.fluidTank.getFluid())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isProducer(EnumFacing facing) {
        TileEntity tileentity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177967_a(facing, 1));
        if (tileentity != null && tileentity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())) {
            IFluidHandler handler = (IFluidHandler)tileentity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d());
            for (int i = 0; i < handler.getTankProperties().length; ++i) {
                if (!handler.getTankProperties()[i].canDrain() || tileentity instanceof TileEntityPipe || this.fluidTank.getFluid() != null && !handler.getTankProperties()[i].canDrainFluidType(this.fluidTank.getFluid())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPipe(EnumFacing facing) {
        TileEntity tileentity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177967_a(facing, 1));
        return tileentity != null && tileentity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d()) && tileentity instanceof TileEntityPipe;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.fluidTank;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("FluidTank")) {
            new FluidTankStorage().readNBT((Capability<IFluidHandler>)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.fluidTank, (EnumFacing)null, compound.func_74781_a("FluidTank"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("FluidTank", new FluidTankStorage().writeNBT((Capability<IFluidHandler>)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.fluidTank, (EnumFacing)null));
        return compound;
    }
}

