/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.capabilities;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.Callable;
import lyon.aom.capabilities.accessory.AccessoryProvider;
import lyon.aom.capabilities.iceburst_container.IceburstCanisterProvider;
import lyon.aom.capabilities.odm_gear.ODMGearProvider;
import lyon.aom.capabilities.special_equipment.SpecialEquipmentProvider;
import lyon.aom.init.ItemInit;
import lyon.aom.utils.interfaces.ISyncableCap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CapabilityHandler {
    private static final Map<String, Class<? extends ISyncableCap>> CAPS = Maps.newHashMap();
    public static final ResourceLocation SPECIAL_EQUIPMENT_CAP = new ResourceLocation("aom", "special_equipment");
    public static final ResourceLocation ACCESSORY_CAP = new ResourceLocation("aom", "accessory");
    public static final ResourceLocation ODMGear_CAP = new ResourceLocation("aom", "odm_gear");
    public static final ResourceLocation ICEBURST_CANISTER_CAP = new ResourceLocation("aom", "iceburst_canister");

    @SubscribeEvent
    public void attachCapabilityEntity(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(SPECIAL_EQUIPMENT_CAP, (ICapabilityProvider)new SpecialEquipmentProvider());
            event.addCapability(ACCESSORY_CAP, (ICapabilityProvider)new AccessoryProvider());
        }
    }

    @SubscribeEvent
    public void attachCapabilityItemStack(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).func_77973_b() == ItemInit.ODM_GEAR) {
            event.addCapability(ODMGear_CAP, (ICapabilityProvider)new ODMGearProvider());
        } else if (((ItemStack)event.getObject()).func_77973_b() == ItemInit.ICEBURST_SHARD) {
            event.addCapability(ICEBURST_CANISTER_CAP, (ICapabilityProvider)new IceburstCanisterProvider());
        }
    }

    public static <T> void registerCapability(Class<T> interfaceClass, Capability.IStorage<T> storage, final Class<? extends T> defaultImplClass) {
        CapabilityManager.INSTANCE.register(interfaceClass, storage, new Callable<T>(){

            @Override
            public T call() throws Exception {
                return defaultImplClass.newInstance();
            }
        });
    }

    public static void addDefaultImplToSyncable(Class defaultImplClass) {
        if (ISyncableCap.class.isAssignableFrom(defaultImplClass)) {
            CAPS.put(defaultImplClass.getName(), defaultImplClass);
        }
    }

    public static Class<? extends ISyncableCap> getClassByInterfaceName(String name) {
        if (CAPS.containsKey(name)) {
            return CAPS.get(name);
        }
        return null;
    }
}

