/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.capabilities.accessory;

import lyon.aom.capabilities.accessory.AccessoryProvider;
import lyon.aom.capabilities.accessory.AccessoryStorage;
import lyon.aom.capabilities.accessory.IAccessory;
import lyon.aom.packets.PacketHandler;
import lyon.aom.packets.both.sync_capability_client_req.PacketSyncCapabilityClientReq;
import lyon.aom.packets.client.sync_capability_req.PacketSyncCapabilityReq;
import lyon.aom.utils.Utils;
import lyon.aom.utils.enums.EnumAccessorySlot;
import lyon.aom.utils.interfaces.ISyncableCap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemStackHandler;

public class Accessory
implements IAccessory {
    private boolean isDirty = true;
    private ItemStackHandler stackHandler = new ItemStackHandler(5);
    private boolean isHoodEnabled;

    @Override
    public ItemStack getAccessory(EnumAccessorySlot slot) {
        if (slot.getSlot() < this.stackHandler.getSlots()) {
            return this.stackHandler.getStackInSlot(slot.getSlot());
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void setAccessory(EnumAccessorySlot slot, ItemStack stack) {
        if (slot.getSlot() < this.stackHandler.getSlots() && stack != null) {
            this.stackHandler.setStackInSlot(slot.getSlot(), stack);
            this.isDirty = true;
        }
    }

    @Override
    public boolean isHoodEnabled() {
        return this.isHoodEnabled;
    }

    @Override
    public void setIsHoodEnabled(boolean b) {
        this.isHoodEnabled = b;
        this.isDirty = true;
    }

    @Override
    public ItemStackHandler getStackHandler() {
        return this.stackHandler;
    }

    @Override
    public void copyValues(IAccessory accessory) {
        if (accessory != null) {
            this.stackHandler = accessory.getStackHandler();
            this.isHoodEnabled = accessory.isHoodEnabled();
        }
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void setIsDirty(boolean b) {
        this.isDirty = b;
    }

    @Override
    public NBTTagCompound getNBTForSync(EntityPlayer player) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (player != null) {
            nbt.func_186854_a("UUID", player.func_110124_au());
        }
        return nbt;
    }

    @Override
    public void sendChanges(EntityPlayer player, NBTTagCompound nbt) {
        PacketSyncCapabilityReq packet = new PacketSyncCapabilityReq(Accessory.class.getName(), new AccessoryStorage().writeNBT(AccessoryProvider.ACCESSORY_CAP, this, null), nbt);
        if (player == null) {
            PacketHandler.INSTANCE.sendToAll((IMessage)packet);
            this.isDirty = false;
        } else if (player instanceof EntityPlayerMP) {
            PacketHandler.INSTANCE.sendTo((IMessage)packet, (EntityPlayerMP)player);
        }
    }

    @Override
    public void sendChanges(EntityPlayer player) {
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSyncCapabilityClientReq(player, Accessory.class));
        this.isDirty = false;
    }

    @Override
    public ISyncableCap getCapabilty(EntityPlayer player) {
        return Utils.getAccessory(player);
    }

    @Override
    public void applyChanges(ISyncableCap instance, NBTBase nbtCap, NBTTagCompound nbt) {
        if (instance instanceof IAccessory && Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71441_e != null) {
            IAccessory accessory2;
            EntityPlayer player;
            IAccessory accessory1 = (IAccessory)instance;
            new AccessoryStorage().readNBT(AccessoryProvider.ACCESSORY_CAP, accessory1, null, nbtCap);
            if (nbt.func_186855_b("UUID") && (player = Minecraft.func_71410_x().field_71441_e.func_152378_a(nbt.func_186857_a("UUID"))) != null && (accessory2 = Utils.getAccessory(player)) != null) {
                accessory2.copyValues(accessory1);
            }
        }
    }
}

