/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.capabilities.fluid_tank;

import java.util.ArrayList;
import java.util.List;
import lyon.aom.capabilities.fluid_tank.FluidTankStorage;
import lyon.aom.packets.PacketHandler;
import lyon.aom.packets.client.sync_capability_req.PacketSyncCapabilityReq;
import lyon.aom.utils.interfaces.ISyncableCap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class FluidTank
implements IFluidHandler,
IFluidTank,
ISyncableCap {
    protected FluidStack fluidStack;
    protected final List<Fluid> acceptedFluids = new ArrayList<Fluid>();
    protected int capacity;
    protected boolean canFill;
    protected boolean canDrain;

    public void setFluidStack(FluidStack stack) {
        this.fluidStack = stack.copy();
    }

    public FluidStack getFluid() {
        return this.fluidStack != null ? this.fluidStack.copy() : null;
    }

    public int getFluidAmount() {
        return this.fluidStack != null ? this.fluidStack.amount : 0;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo(this.fluidStack.copy(), this.capacity);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new IFluidTankProperties(){

            public FluidStack getContents() {
                return FluidTank.this.fluidStack != null ? FluidTank.this.fluidStack.copy() : null;
            }

            public int getCapacity() {
                return FluidTank.this.capacity;
            }

            public boolean canFillFluidType(FluidStack fluidStack) {
                return FluidTank.this.doesTankAcceptFluid(fluidStack.getFluid());
            }

            public boolean canFill() {
                return FluidTank.this.canFill;
            }

            public boolean canDrainFluidType(FluidStack fluidStack) {
                return FluidTank.this.doesTankAcceptFluid(fluidStack.getFluid());
            }

            public boolean canDrain() {
                return FluidTank.this.canDrain;
            }
        }};
    }

    public boolean doesTankAcceptFluid(Fluid fluid) {
        return this.acceptedFluids.isEmpty() || this.acceptedFluids.contains(fluid);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (!(this.fluidStack == null || resource.getFluid() == this.fluidStack.getFluid() && this.doesTankAcceptFluid(resource.getFluid()))) {
            return 0;
        }
        int amountInTank = this.fluidStack == null ? 0 : this.fluidStack.amount;
        int amount = Math.min(amountInTank + resource.amount, this.capacity);
        int filled = amount - amountInTank;
        if (doFill) {
            if (this.fluidStack == null) {
                this.fluidStack = new FluidStack(resource.getFluid(), resource.amount);
            } else {
                this.fluidStack.amount = amount;
            }
            if (this.fluidStack.amount == 0) {
                this.fluidStack = null;
            }
        }
        return filled;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.fluidStack != null && resource.getFluid() == this.fluidStack.getFluid()) {
            return this.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.fluidStack == null) {
            return null;
        }
        Fluid fluid = this.fluidStack.getFluid();
        int amount = Math.max(this.fluidStack.amount - maxDrain, 0);
        int drained = this.fluidStack.amount - amount;
        if (doDrain) {
            if (amount == 0) {
                this.fluidStack = null;
            } else {
                this.fluidStack.amount = amount;
            }
        }
        return new FluidStack(fluid, drained);
    }

    public void copyValues(FluidTank tank) {
        if (tank != null) {
            this.fluidStack = tank.getFluid() != null ? tank.getFluid().copy() : tank.getFluid();
        }
    }

    public NBTTagCompound getNBTForSync(TileEntity tileentity, EnumFacing facing) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("X", tileentity.func_174877_v().func_177958_n());
        nbt.func_74768_a("Y", tileentity.func_174877_v().func_177956_o());
        nbt.func_74768_a("Z", tileentity.func_174877_v().func_177952_p());
        if (facing != null) {
            nbt.func_74778_a("Facing", facing.func_176742_j());
        }
        return nbt;
    }

    @Override
    public void sendChanges(EntityPlayer player, NBTTagCompound nbt) {
        PacketSyncCapabilityReq packet = new PacketSyncCapabilityReq(FluidTank.class.getName(), new FluidTankStorage().writeNBT((Capability<IFluidHandler>)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this, EnumFacing.func_176739_a((String)nbt.func_74779_i("Facing"))), nbt);
        if (player == null) {
            PacketHandler.INSTANCE.sendToAll((IMessage)packet);
        } else if (player instanceof EntityPlayerMP) {
            PacketHandler.INSTANCE.sendTo((IMessage)packet, (EntityPlayerMP)player);
        }
    }

    @Override
    public void applyChanges(ISyncableCap instance, NBTBase nbtCap, NBTTagCompound nbt) {
        if (instance instanceof FluidTank) {
            IFluidHandler fluidHandler;
            TileEntity tileentity;
            FluidTank fluidTank = (FluidTank)instance;
            new FluidTankStorage().readNBT((Capability<IFluidHandler>)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, fluidTank, (EnumFacing)null, nbtCap);
            if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71441_e != null && (tileentity = Minecraft.func_71410_x().field_71441_e.func_175625_s(new BlockPos(nbt.func_74762_e("X"), nbt.func_74762_e("Y"), nbt.func_74762_e("Z")))) != null && tileentity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.func_176739_a((String)nbt.func_74779_i("Facing"))) && (fluidHandler = (IFluidHandler)tileentity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.func_176739_a((String)nbt.func_74779_i("Facing")))) != null && fluidHandler instanceof FluidTank) {
                ((FluidTank)fluidHandler).copyValues(fluidTank);
            }
        }
    }
}

