/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.capabilities.odm_gear;

import java.util.Arrays;
import lyon.aom.capabilities.odm_gear.IODMGear;
import lyon.aom.capabilities.odm_gear.ODMGearProvider;
import lyon.aom.capabilities.odm_gear.ODMGearStorage;
import lyon.aom.capabilities.special_equipment.ISpecialEquipment;
import lyon.aom.entity.hook.EntityHook;
import lyon.aom.init.ItemInit;
import lyon.aom.init.SoundInit;
import lyon.aom.packets.PacketHandler;
import lyon.aom.packets.both.play_sound_req.PacketPlaySoundReq;
import lyon.aom.packets.both.sync_capability_client_req.PacketSyncCapabilityClientReq;
import lyon.aom.packets.client.spawn_projectile_req.PacketSpawnProjectileReq;
import lyon.aom.packets.client.sync_capability_req.PacketSyncCapabilityReq;
import lyon.aom.utils.AOMConfig;
import lyon.aom.utils.Utils;
import lyon.aom.utils.enums.EnumEntitys;
import lyon.aom.utils.enums.EnumMain;
import lyon.aom.utils.interfaces.ISyncableCap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public class ODMGear
implements IODMGear {
    private ItemStackHandler stackHandler = new ItemStackHandler(14);
    private boolean areThunderspearActive = false;
    private int mainHandBladeSlot = 0;
    private int offHandBladeSlot = 0;
    private EntityHook leftHook;
    private EntityHook rightHook;
    private int leftHookID;
    private int rightHookID;
    private float leftLength;
    private float rightLength;
    private int leftBoostTicks = 0;
    private boolean isDirty = true;

    @Override
    public boolean areThunderspearsActive() {
        return this.areThunderspearActive;
    }

    @Override
    public void setThunderspearsActive(boolean b) {
        this.areThunderspearActive = b;
        this.isDirty = true;
    }

    @Override
    public void setCableLength(EnumHandSide side, float length) {
        if (side == EnumHandSide.LEFT) {
            this.leftLength = length;
        } else if (side == EnumHandSide.RIGHT) {
            this.rightLength = length;
        }
        this.isDirty = true;
    }

    @Override
    public float getCableLengthCopy(EnumHandSide side) {
        if (side == EnumHandSide.LEFT) {
            return this.leftLength;
        }
        return this.rightLength;
    }

    @Override
    public float getCableLength(EnumHandSide side, World world) {
        EntityHook hook = this.getHook(side, world);
        if (hook != null) {
            if (hook.isStuck()) {
                return side == EnumHandSide.LEFT ? this.leftLength : this.rightLength;
            }
            return 0.0f;
        }
        return -1.0f;
    }

    @Override
    public void shootHook(EntityPlayerMP player, EnumMain.EnumHands side) {
        ISpecialEquipment equipment = Utils.getSpecialEquipment((EntityPlayer)player);
        if (equipment != null && !player.func_184218_aH() && (AOMConfig.canUseODMGearWithElytra || !AOMConfig.canUseODMGearWithElytra && !player.func_184613_cA())) {
            if (equipment.getEquipment(EnumEntitys.SpecialEquipmentSlot.ODM_GEAR).func_77973_b() == ItemInit.ODM_GEAR && player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == ItemInit.HANDLE && player.func_184586_b(EnumHand.OFF_HAND).func_77973_b() == ItemInit.HANDLE) {
                if (side == EnumMain.EnumHands.BOTH && (this.getHook(EnumHandSide.RIGHT, player.field_70170_p) != null || this.getHook(EnumHandSide.LEFT, player.field_70170_p) != null)) {
                    this.deleteAllHooks();
                    this.leftLength = 0.0f;
                    this.rightLength = 0.0f;
                    player.field_70143_R = 0.0f;
                } else if (side == EnumMain.EnumHands.LEFT && this.leftHook != null) {
                    this.leftHook.func_70106_y();
                    this.setHook(null, EnumHandSide.LEFT);
                    this.leftLength = 0.0f;
                    player.field_70143_R = 0.0f;
                } else if (side == EnumMain.EnumHands.RIGHT && this.rightHook != null) {
                    this.rightHook.func_70106_y();
                    this.setHook(null, EnumHandSide.RIGHT);
                    this.rightLength = 0.0f;
                    player.field_70143_R = 0.0f;
                } else {
                    PacketHandler.INSTANCE.sendToAll((IMessage)new PacketPlaySoundReq(SoundInit.HOOKS_SHOOT, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundCategory.PLAYERS, 1.0f, 1.0f, false));
                    PacketHandler.INSTANCE.sendTo((IMessage)new PacketSpawnProjectileReq(EnumEntitys.Projectiles.HOOK, player.func_110124_au(), player.func_174791_d(), 4.5, Arrays.asList(side.getID())), player);
                }
            }
            this.isDirty = true;
        }
    }

    @Override
    public boolean canSwing(World world) {
        return this.getHook(EnumHandSide.LEFT, world) != null && this.leftHook.isStuck() || this.getHook(EnumHandSide.RIGHT, world) != null && this.rightHook.isStuck();
    }

    @Override
    public void deleteAllHooks() {
        if (this.rightHook != null && this.getHook(EnumHandSide.RIGHT, this.rightHook.field_70170_p) != null) {
            this.rightHook.func_70106_y();
        }
        if (this.leftHook != null && this.getHook(EnumHandSide.RIGHT, this.leftHook.field_70170_p) != null) {
            this.leftHook.func_70106_y();
        }
        this.setHook(null, EnumHandSide.RIGHT);
        this.setHook(null, EnumHandSide.LEFT);
        this.isDirty = true;
    }

    @Override
    public EntityHook getHook(EnumHandSide side, World world) {
        if (world != null) {
            EntityHook hook;
            Entity entity = world.func_73045_a(side == EnumHandSide.RIGHT ? this.rightHookID : this.leftHookID);
            EntityHook entityHook = hook = entity instanceof EntityHook ? (EntityHook)entity : null;
            if (side == EnumHandSide.RIGHT) {
                this.rightHook = hook;
            } else if (side == EnumHandSide.LEFT) {
                this.leftHook = hook;
            }
        }
        if (side == EnumHandSide.RIGHT) {
            return this.rightHook;
        }
        if (side == EnumHandSide.LEFT) {
            return this.leftHook;
        }
        return null;
    }

    @Override
    public int getHookID(EnumHandSide side) {
        if (side == EnumHandSide.RIGHT) {
            return this.rightHookID;
        }
        if (side == EnumHandSide.LEFT) {
            return this.leftHookID;
        }
        return -1;
    }

    @Override
    public void setHookID(int hookID, EnumHandSide side) {
        if (side == EnumHandSide.RIGHT) {
            this.rightHookID = hookID;
        } else if (side == EnumHandSide.LEFT) {
            this.leftHookID = hookID;
        }
        this.isDirty = true;
    }

    @Override
    public void setHook(EntityHook hook, EnumHandSide side) {
        if (side == EnumHandSide.RIGHT) {
            this.rightHookID = hook != null ? hook.func_145782_y() : -1;
            this.rightHook = hook;
        } else if (side == EnumHandSide.LEFT) {
            this.leftHookID = hook != null ? hook.func_145782_y() : -1;
            this.leftHook = hook;
        }
        this.isDirty = true;
    }

    @Override
    public void setStackInSlot(int index, ItemStack stack) {
        this.stackHandler.setStackInSlot(index, stack);
    }

    @Override
    public ItemStack getStackInSlot(int index) {
        return this.stackHandler.getStackInSlot(index);
    }

    @Override
    public ItemStackHandler getStackHandler() {
        return this.stackHandler;
    }

    @Override
    public void copyValues(IODMGear odm_gear) {
        if (odm_gear instanceof ODMGear) {
            for (int i = 0; i < this.stackHandler.getSlots(); ++i) {
                this.stackHandler.setStackInSlot(i, odm_gear.getStackInSlot(i).func_77946_l());
            }
            this.mainHandBladeSlot = odm_gear.getCurrentBladeSlot(EnumHand.MAIN_HAND);
            this.offHandBladeSlot = odm_gear.getCurrentBladeSlot(EnumHand.OFF_HAND);
            this.areThunderspearActive = odm_gear.areThunderspearsActive();
            this.leftHookID = odm_gear.getHookID(EnumHandSide.LEFT);
            this.rightHookID = odm_gear.getHookID(EnumHandSide.RIGHT);
            this.leftLength = odm_gear.getCableLengthCopy(EnumHandSide.LEFT);
            this.rightLength = odm_gear.getCableLengthCopy(EnumHandSide.RIGHT);
            this.leftBoostTicks = odm_gear.getLeftBoostTicks();
        }
    }

    @Override
    public int getActualCurrentBladeSlot(EnumHand hand) {
        return hand == EnumHand.MAIN_HAND ? this.mainHandBladeSlot : 4 + this.offHandBladeSlot;
    }

    @Override
    public int getCurrentBladeSlot(EnumHand hand) {
        return hand == EnumHand.MAIN_HAND ? this.mainHandBladeSlot : this.offHandBladeSlot;
    }

    @Override
    public void incrementCurrentBladeSlot(EnumHand hand) {
        if (!this.areThunderspearActive) {
            if (hand == EnumHand.MAIN_HAND) {
                this.mainHandBladeSlot = (this.mainHandBladeSlot + 1) % 4;
            } else if (hand == EnumHand.OFF_HAND) {
                this.offHandBladeSlot = (this.offHandBladeSlot + 1) % 4;
            }
            this.isDirty = true;
        }
    }

    @Override
    public void setCurrentBladeSlot(int slot, EnumHand hand) {
        if (slot >= 0 && slot <= 3) {
            if (hand == EnumHand.MAIN_HAND) {
                this.mainHandBladeSlot = slot;
            } else if (hand == EnumHand.OFF_HAND) {
                this.offHandBladeSlot = slot;
            }
            this.isDirty = true;
        }
    }

    @Override
    public boolean canBoost() {
        return this.leftBoostTicks > 0;
    }

    @Override
    public void setLeftBoostTicks(int ticks) {
        if (ticks >= 0) {
            this.leftBoostTicks = ticks;
            this.isDirty = true;
        }
    }

    @Override
    public void subtractLeftBoostTicks(int ticks) {
        this.leftBoostTicks = Math.max(0, this.leftBoostTicks - ticks);
        this.isDirty = true;
    }

    @Override
    public void addLeftBoostTicks(int ticks) {
        this.leftBoostTicks += ticks;
        this.isDirty = true;
    }

    @Override
    public int getLeftBoostTicks() {
        return this.leftBoostTicks;
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void setIsDirty(boolean b) {
        this.isDirty = b;
    }

    @Override
    public void sendChanges(EntityPlayer player, NBTTagCompound nbt) {
        PacketSyncCapabilityReq packet = new PacketSyncCapabilityReq(ODMGear.class.getName(), new ODMGearStorage().writeNBT(ODMGearProvider.ODMGear_CAP, this, null), nbt);
        if (player == null) {
            PacketHandler.INSTANCE.sendToAll((IMessage)packet);
            this.isDirty = false;
        } else if (player instanceof EntityPlayerMP) {
            PacketHandler.INSTANCE.sendTo((IMessage)packet, (EntityPlayerMP)player);
        }
    }

    @Override
    public void sendChanges(EntityPlayer player) {
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSyncCapabilityClientReq(player, ODMGear.class));
        this.isDirty = false;
    }

    @Override
    public ISyncableCap getCapabilty(EntityPlayer player) {
        if (player != null) {
            return Utils.getODMGear(player);
        }
        return null;
    }

    @Override
    public NBTTagCompound getNBTForSync(EntityPlayer player) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_186854_a("UUID", player.func_110124_au());
        return nbt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void applyChanges(ISyncableCap instance, NBTBase nbtCap, NBTTagCompound nbt) {
        if (instance instanceof ODMGear && Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71441_e != null) {
            IODMGear odm_gear_2;
            EntityPlayer player;
            IODMGear odm_gear_1 = (IODMGear)instance;
            new ODMGearStorage().readNBT(ODMGearProvider.ODMGear_CAP, odm_gear_1, null, nbtCap);
            odm_gear_1.getHook(EnumHandSide.RIGHT, (World)Minecraft.func_71410_x().field_71441_e);
            odm_gear_1.getHook(EnumHandSide.LEFT, (World)Minecraft.func_71410_x().field_71441_e);
            if (nbt != null && nbt.func_186855_b("UUID") && (player = Minecraft.func_71410_x().field_71441_e.func_152378_a(nbt.func_186857_a("UUID"))) != null && (odm_gear_2 = Utils.getODMGear(player)) != null) {
                odm_gear_2.copyValues(odm_gear_1);
            }
        }
    }
}

