/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.capabilities.special_equipment;

import lyon.aom.capabilities.special_equipment.ISpecialEquipment;
import lyon.aom.capabilities.special_equipment.SpecialEquipmentProvider;
import lyon.aom.capabilities.special_equipment.SpecialEquipmentStorage;
import lyon.aom.packets.PacketHandler;
import lyon.aom.packets.both.sync_capability_client_req.PacketSyncCapabilityClientReq;
import lyon.aom.packets.client.sync_capability_req.PacketSyncCapabilityReq;
import lyon.aom.utils.Utils;
import lyon.aom.utils.enums.EnumEntitys;
import lyon.aom.utils.interfaces.ISyncableCap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemStackHandler;

public class SpecialEquipment
implements ISpecialEquipment {
    private ItemStackHandler stackHandler = new ItemStackHandler(2);
    private boolean isDirty = true;

    @Override
    public ISyncableCap getCapabilty(EntityPlayer player) {
        if (player != null) {
            return Utils.getSpecialEquipment(player);
        }
        return null;
    }

    @Override
    public void setEquipment(EnumEntitys.SpecialEquipmentSlot slot, ItemStack stack) {
        this.stackHandler.setStackInSlot(slot.getSlot(), stack);
        this.isDirty = true;
    }

    @Override
    public ItemStack getEquipment(EnumEntitys.SpecialEquipmentSlot slot) {
        return this.stackHandler.getStackInSlot(slot.getSlot());
    }

    @Override
    public ItemStackHandler getStackHandler() {
        return this.stackHandler;
    }

    @Override
    public void copyValues(ISpecialEquipment equipment) {
        if (equipment != null) {
            this.stackHandler = equipment.getStackHandler();
            this.isDirty = true;
        }
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public NBTTagCompound getNBTForSync(EntityPlayer player) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (player != null) {
            nbt.func_186854_a("UUID", player.func_110124_au());
        }
        return nbt;
    }

    @Override
    public void sendChanges(EntityPlayer player, NBTTagCompound nbt) {
        PacketSyncCapabilityReq packet = new PacketSyncCapabilityReq(SpecialEquipment.class.getName(), new SpecialEquipmentStorage().writeNBT(SpecialEquipmentProvider.SPECIAL_EQUIPMENT_CAP, this, null), nbt);
        if (player == null) {
            PacketHandler.INSTANCE.sendToAll((IMessage)packet);
            this.isDirty = false;
        } else if (player instanceof EntityPlayerMP) {
            PacketHandler.INSTANCE.sendTo((IMessage)packet, (EntityPlayerMP)player);
        }
    }

    @Override
    public void sendChanges(EntityPlayer player) {
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSyncCapabilityClientReq(player, SpecialEquipment.class));
        this.isDirty = false;
    }

    @Override
    public void applyChanges(ISyncableCap instance, NBTBase nbtCap, NBTTagCompound nbt) {
        if (instance instanceof ISpecialEquipment && Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71441_e != null) {
            ISpecialEquipment equipment2;
            EntityPlayer player;
            ISpecialEquipment equipment1 = (ISpecialEquipment)instance;
            new SpecialEquipmentStorage().readNBT(SpecialEquipmentProvider.SPECIAL_EQUIPMENT_CAP, equipment1, null, nbtCap);
            if (nbt.func_186855_b("UUID") && (player = Minecraft.func_71410_x().field_71441_e.func_152378_a(nbt.func_186857_a("UUID"))) != null && (equipment2 = Utils.getSpecialEquipment(player)) != null) {
                equipment2.copyValues(equipment1);
            }
        }
    }

    @Override
    public void setIsDirty(boolean b) {
        this.isDirty = b;
    }
}

