/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.capabilities.special_equipment;

import lyon.aom.capabilities.special_equipment.ISpecialEquipment;
import lyon.aom.utils.Utils;
import lyon.aom.utils.enums.EnumEntitys;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class SpecialEquipmentHandler {
    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ISpecialEquipment equipment;
        if (event.phase == TickEvent.Phase.END && (equipment = Utils.getSpecialEquipment(event.player)) != null && equipment.isDirty()) {
            if (!event.player.field_70170_p.field_72995_K) {
                equipment.sendChanges(null, equipment.getNBTForSync(event.player));
            } else {
                equipment.sendChanges(event.player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPlayer) {
            ISpecialEquipment equipment;
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (!player.field_70170_p.func_82736_K().func_82766_b("keepInventory") && (equipment = Utils.getSpecialEquipment(player)) != null) {
                if (!equipment.getEquipment(EnumEntitys.SpecialEquipmentSlot.BELT).func_190926_b()) {
                    player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, equipment.getEquipment(EnumEntitys.SpecialEquipmentSlot.BELT)));
                }
                if (!equipment.getEquipment(EnumEntitys.SpecialEquipmentSlot.ODM_GEAR).func_190926_b()) {
                    player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, equipment.getEquipment(EnumEntitys.SpecialEquipmentSlot.ODM_GEAR)));
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerCloneEvent(PlayerEvent.Clone event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = event.getOriginal();
            EntityPlayer clone = (EntityPlayer)event.getEntity();
            if (player.field_70170_p.func_82736_K().func_82766_b("keepInventory") && event.isWasDeath() || !event.isWasDeath()) {
                ISpecialEquipment equipPlayer = Utils.getSpecialEquipment(player);
                ISpecialEquipment equipClone = Utils.getSpecialEquipment(clone);
                if (equipPlayer != null && equipClone != null) {
                    equipClone.copyValues(equipPlayer);
                    equipClone.setIsDirty(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerCloneEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        ISpecialEquipment equipment;
        if (!event.player.field_70170_p.field_72995_K && (equipment = Utils.getSpecialEquipment(event.player)) != null) {
            equipment.setIsDirty(true);
        }
    }

    @SubscribeEvent
    public void onPlayerStatredTracking(PlayerEvent.StartTracking event) {
        ISpecialEquipment equipment;
        if (!event.getEntity().field_70170_p.field_72995_K && event.getTarget() instanceof EntityPlayer && (equipment = Utils.getSpecialEquipment((EntityPlayer)event.getTarget())) != null) {
            equipment.sendChanges((EntityPlayer)event.getEntity(), equipment.getNBTForSync((EntityPlayer)event.getTarget()));
        }
    }
}

