/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.entity;

import java.util.List;
import lyon.aom.entity.CustomEntityProjectile;
import lyon.aom.utils.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class CustomEntityProjectileStick
extends CustomEntityProjectile {
    protected static DataParameter<Boolean> IS_IN_BLOCK = EntityDataManager.func_187226_a(CustomEntityProjectileStick.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static DataParameter<BlockPos> BLOCK_HIT = EntityDataManager.func_187226_a(CustomEntityProjectileStick.class, (DataSerializer)DataSerializers.field_187200_j);
    protected IBlockState blockState;
    protected static DataParameter<Boolean> IS_IN_ENTITY = EntityDataManager.func_187226_a(CustomEntityProjectileStick.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static DataParameter<Integer> ENTITY_HIT_ID = EntityDataManager.func_187226_a(CustomEntityProjectileStick.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static DataParameter<Float> OFFSET_X = EntityDataManager.func_187226_a(CustomEntityProjectileStick.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static DataParameter<Float> OFFSET_Y = EntityDataManager.func_187226_a(CustomEntityProjectileStick.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static DataParameter<Float> OFFSET_Z = EntityDataManager.func_187226_a(CustomEntityProjectileStick.class, (DataSerializer)DataSerializers.field_187193_c);
    protected Entity entityHit;

    public CustomEntityProjectileStick(World worldIn) {
        super(worldIn);
        this.field_70145_X = true;
    }

    public CustomEntityProjectileStick(World worldIn, double x, double y, double z) {
        super(worldIn);
    }

    public CustomEntityProjectileStick(World worldIn, double x, double y, double z, float yaw, float pitch) {
        super(worldIn, x, y, z);
    }

    public CustomEntityProjectileStick(World worldIn, double x, double y, double z, double velocity, float yaw, float pitch, int lifeTime, Entity entity) {
        super(worldIn, x, y, z, velocity, yaw, pitch, lifeTime, entity);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_IN_ENTITY, (Object)false);
        this.field_70180_af.func_187214_a(ENTITY_HIT_ID, (Object)-1);
        this.field_70180_af.func_187214_a(OFFSET_X, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(OFFSET_Y, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(OFFSET_Z, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(IS_IN_BLOCK, (Object)false);
        this.field_70180_af.func_187214_a(BLOCK_HIT, (Object)new BlockPos(0, 0, 0));
    }

    @Override
    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa == this.lifeTime && !this.field_70128_L) {
            this.onLifeTimeEnd();
            this.func_70106_y();
            return;
        }
        if (!this.isInEntity() && !this.isInBlock()) {
            if (!this.field_70170_p.field_72995_K) {
                this.checkForEntityCollision();
                this.checkForBlockCollision();
            }
            if (!this.isStuck()) {
                this.func_70101_b((float)Math.toDegrees(Utils.getATanWithOffset(this.field_70179_y, -this.field_70159_w)), (float)Math.toDegrees(Math.asin(-this.field_70181_x / Utils.calcVel(this.field_70159_w, this.field_70181_x, this.field_70179_y))));
            }
        } else if (this.isInEntity()) {
            if (this.entityHit.field_70128_L) {
                this.onEntityDeath();
                this.func_70106_y();
                return;
            }
            Vec3d vec = this.entityHit.func_174791_d().func_72441_c(0.0, (double)(this.field_70131_O / 2.0f), 0.0).func_178787_e(this.getOffset());
            this.field_70159_w = vec.field_72450_a - this.field_70165_t;
            this.field_70181_x = vec.field_72448_b - this.field_70163_u;
            this.field_70179_y = vec.field_72449_c - this.field_70161_v;
            this.func_70018_K();
        } else if (this.isInBlock()) {
            if (this.blockState == null) {
                this.blockState = this.field_70170_p.func_180495_p((BlockPos)this.field_70180_af.func_187225_a(BLOCK_HIT));
            } else if (this.field_70170_p.func_180495_p((BlockPos)this.field_70180_af.func_187225_a(BLOCK_HIT)) != this.blockState) {
                this.onBlockRemoved();
                this.func_70106_y();
                return;
            }
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.func_70018_K();
        }
        this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
    }

    public void onLifeTimeEnd() {
    }

    public void onEntityDeath() {
    }

    public void onBlockRemoved() {
    }

    @Override
    public void checkForBlockCollision() {
        RayTraceResult ray;
        if (!this.isInEntity() && (ray = this.field_70170_p.func_147447_a(this.func_174791_d().func_72441_c(0.0, (double)(this.field_70131_O / 2.0f), 0.0), this.func_174791_d().func_72441_c(this.field_70159_w, (double)(this.field_70131_O / 2.0f) + this.field_70181_x, this.field_70179_y), false, true, false)) != null && ray.field_72313_a == RayTraceResult.Type.BLOCK && ray.func_178782_a() != null && ray.field_72307_f != null) {
            this.field_70180_af.func_187227_b(IS_IN_BLOCK, (Object)true);
            this.field_70180_af.func_187227_b(BLOCK_HIT, (Object)ray.func_178782_a());
            this.fixVelOnHit(ray.field_72307_f);
            this.onBlockHit();
        }
    }

    public void onBlockHit() {
    }

    @Override
    public void checkForEntityCollision() {
        RayTraceResult ray;
        List list;
        if (!this.isInBlock() && (list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, (double)(this.field_70131_O / 2.0f) + this.field_70181_x, this.field_70179_y).func_186662_g(1.0))) != null && !list.isEmpty() && (ray = Utils.rayTraceEntitys(this.func_174791_d().func_72441_c(0.0, (double)(this.field_70131_O / 2.0f), 0.0), this.func_174791_d().func_72441_c(0.0, (double)(this.field_70131_O / 2.0f), 0.0).func_72441_c(this.field_70159_w, this.field_70181_x, this.field_70179_y), list, this.shooter)) != null && ray.field_72308_g != null && ray.field_72307_f != null) {
            this.entityHit = ray.field_72308_g;
            Vec3d vec = ray.field_72307_f.func_178788_d(this.entityHit.func_174791_d().func_72441_c(0.0, (double)(this.field_70131_O / 2.0f), 0.0));
            this.field_70180_af.func_187227_b(OFFSET_X, (Object)Float.valueOf((float)vec.field_72450_a));
            this.field_70180_af.func_187227_b(OFFSET_Y, (Object)Float.valueOf((float)vec.field_72448_b));
            this.field_70180_af.func_187227_b(OFFSET_Z, (Object)Float.valueOf((float)vec.field_72449_c));
            this.field_70180_af.func_187227_b(IS_IN_ENTITY, (Object)true);
            this.field_70180_af.func_187227_b(ENTITY_HIT_ID, (Object)this.entityHit.func_145782_y());
            this.fixVelOnHit(ray.field_72307_f);
            this.onEntityHit();
        }
    }

    public void onEntityHit() {
    }

    public void fixVelOnHit(Vec3d hit) {
        this.field_70159_w = (float)(hit.field_72450_a - this.field_70165_t);
        this.field_70181_x = (float)(hit.field_72448_b - this.field_70163_u);
        this.field_70179_y = (float)(hit.field_72449_c - this.field_70161_v);
        float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        this.field_70159_w -= this.field_70159_w / (double)f2 * (double)0.05f;
        this.field_70181_x -= this.field_70181_x / (double)f2 * (double)0.05f;
        this.field_70179_y -= this.field_70179_y / (double)f2 * (double)0.05f;
        this.func_70018_K();
    }

    public boolean isStuck() {
        return this.isInBlock() || this.isInEntity();
    }

    public Entity getEntityHit() {
        return this.entityHit;
    }

    public boolean isInEntity() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_IN_ENTITY) != false && this.entityHit != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isInBlock() {
        if ((Boolean)this.field_70180_af.func_187225_a(IS_IN_BLOCK) == false) return false;
        if (this.field_70180_af.func_187225_a(BLOCK_HIT) == null) return false;
        return true;
    }

    public Vec3d getOffset() {
        return new Vec3d((double)((Float)this.field_70180_af.func_187225_a(OFFSET_X)).floatValue(), (double)((Float)this.field_70180_af.func_187225_a(OFFSET_Y)).floatValue(), (double)((Float)this.field_70180_af.func_187225_a(OFFSET_Z)).floatValue());
    }

    public void func_184206_a(DataParameter<?> key) {
        if (key.equals(ENTITY_HIT_ID)) {
            this.entityHit = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(ENTITY_HIT_ID)).intValue());
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("Hit") && compound.func_74779_i("Hit").equals("block")) {
            this.field_70180_af.func_187227_b(IS_IN_BLOCK, (Object)true);
            this.field_70180_af.func_187227_b(BLOCK_HIT, (Object)new BlockPos(compound.func_74762_e("BlockPosX"), compound.func_74762_e("BlockPosY"), compound.func_74762_e("BlockPosZ")));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.isInBlock()) {
            compound.func_74778_a("Hit", "block");
            compound.func_74768_a("BlockPosX", ((BlockPos)this.field_70180_af.func_187225_a(BLOCK_HIT)).func_177958_n());
            compound.func_74768_a("BlockPosY", ((BlockPos)this.field_70180_af.func_187225_a(BLOCK_HIT)).func_177956_o());
            compound.func_74768_a("BlockPosz", ((BlockPos)this.field_70180_af.func_187225_a(BLOCK_HIT)).func_177952_p());
        }
    }
}

