/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.entity.hook;

import lyon.aom.capabilities.odm_gear.IODMGear;
import lyon.aom.entity.CustomEntityProjectileStick;
import lyon.aom.utils.AOMConfig;
import lyon.aom.utils.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityHook
extends CustomEntityProjectileStick {
    private EnumHandSide side;

    public EntityHook(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.25f, 0.25f);
    }

    public EntityHook(World worldIn, double x, double y, double z, double velocity, float yaw, float pitch, EntityPlayer entity, EnumHandSide side) {
        super(worldIn, x, y, z, velocity, yaw, pitch, -1, (Entity)entity);
        IODMGear odm_gear = Utils.getODMGear((EntityPlayer)this.shooter);
        if (odm_gear != null) {
            odm_gear.setHook(this, side);
        }
        this.side = side;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.shooter != null) {
            Vec3d vec3d = this.func_174791_d().func_72441_c(0.0, (double)(this.field_70131_O / 2.0f), 0.0);
            Vec3d vec3d2 = this.shooter.func_174791_d();
            double d = this.shooter.func_70093_af() ? 0.2133 : 0.0;
            if (Utils.vecDist(vec3d, vec3d2.func_72441_c(0.0, 0.8125 - d, 0.0)) > (double)AOMConfig.maxCableLength) {
                this.func_70106_y();
            }
        }
    }

    @Override
    public void onBlockHit() {
        this.setCableLength();
    }

    @Override
    public void onEntityHit() {
        this.setCableLength();
    }

    public void setCableLength() {
        IODMGear odm_gear;
        if (!this.field_70170_p.field_72995_K && this.shooter != null && this.shooter instanceof EntityPlayer && (odm_gear = Utils.getODMGear((EntityPlayer)this.shooter)) != null) {
            odm_gear.setCableLength(this.side, (float)Utils.vecDist(this.func_174791_d().func_72441_c(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72441_c(0.0, (double)(this.field_70131_O / 2.0f), 0.0), this.shooter.func_174791_d().func_72441_c(0.0, 0.8125 - (this.shooter.func_70093_af() ? 0.2133 : 0.0), 0.0)));
        }
    }

    public void setShooter(Entity shooter) {
        this.shooter = shooter;
    }

    public void onRemovedFromWorld() {
        IODMGear odm_gear;
        super.onRemovedFromWorld();
        if (this.shooter != null && this.shooter instanceof EntityPlayer && (odm_gear = Utils.getODMGear((EntityPlayer)this.shooter)) != null) {
            odm_gear.setHook(null, this.side);
        }
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        return null;
    }

    public boolean func_70039_c(NBTTagCompound compound) {
        return false;
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
    }

    @Override
    protected void writeSpawnData(NBTTagCompound nbt) {
        if (this.side != null) {
            nbt.func_74778_a("Side", this.side.name());
        }
    }

    @Override
    public void readSpawnData(NBTTagCompound nbt) {
        IODMGear odm_gear;
        if (nbt.func_74764_b("Side")) {
            this.side = EnumHandSide.valueOf((String)nbt.func_74779_i("Side"));
        }
        if (this.shooter != null && this.shooter instanceof EntityPlayer && (odm_gear = Utils.getODMGear((EntityPlayer)this.shooter)) != null && this.side != null) {
            odm_gear.setHook(this, this.side);
        }
    }
}

