/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.entity.thunderspear;

import lyon.aom.Main;
import lyon.aom.entity.CustomEntityProjectileStick;
import lyon.aom.init.SoundInit;
import lyon.aom.packets.PacketHandler;
import lyon.aom.packets.both.play_sound_req.PacketPlaySoundReq;
import lyon.aom.utils.Utils;
import lyon.aom.utils.enums.EnumParticles;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityThunderspear
extends CustomEntityProjectileStick {
    public EntityThunderspear(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.5f, 1.5f);
    }

    public EntityThunderspear(World worldIn, double x, double y, double z, double velocity, float yaw, float pitch, int lifeTime, Entity entity) {
        super(worldIn, x, y, z, velocity, yaw, pitch, lifeTime, entity);
    }

    @Override
    public void func_70071_h_() {
        if (!this.isStuck()) {
            int particleNum = 10;
            Vec3d vec = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72432_b();
            Vec3d vec2 = Utils.rotateVector(new Vec3d(0.0, 0.0, 1.0), (float)Math.toRadians(this.field_70125_A), (float)Math.toRadians(this.field_70177_z), 0.0f).func_72432_b().func_186678_a(-0.75);
            for (int i = 0; i < particleNum; ++i) {
                Vec3d vec3 = vec.func_186678_a((double)i * 1.0 / (double)particleNum);
                Vec3d vec4 = vec2.func_186678_a(0.05);
                Main.proxy.spawnParticle(EnumParticles.EnumAOMParticleTypes.BOOST, this.field_70170_p, this.field_70165_t + vec2.field_72450_a + vec3.field_72450_a, this.field_70163_u + (double)(this.field_70131_O / 2.0f) + vec2.field_72448_b + vec3.field_72448_b, this.field_70161_v + vec2.field_72449_c + vec3.field_72449_c, (float)(vec4.field_72450_a - (double)0.02f + Math.random() * (double)0.04f), (float)(vec4.field_72448_b - (double)0.02f + Math.random() * (double)0.04f), (float)(vec4.field_72449_c - (double)0.02f + Math.random() * (double)0.04f), 0);
            }
            if (Math.random() > (double)0.4f) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187631_bo, SoundCategory.NEUTRAL, 1.0f, 1.0f, false);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.getTicksToExplosion() == 24) {
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketPlaySoundReq(SoundInit.THUNDERSPEAR_CHARGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundCategory.NEUTRAL, 1.0f, 1.0f, false), new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0));
        }
        super.func_70071_h_();
    }

    @Override
    public void fixVelOnHit(Vec3d hit) {
        this.field_70159_w = (float)(hit.field_72450_a - this.field_70165_t);
        this.field_70181_x = (float)(hit.field_72448_b - this.field_70163_u - (double)(this.field_70131_O / 2.0f));
        this.field_70179_y = (float)(hit.field_72449_c - this.field_70161_v);
        float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        this.field_70159_w -= this.field_70159_w / (double)f2 * (double)0.05f;
        this.field_70181_x -= this.field_70181_x / (double)f2 * (double)0.05f;
        this.field_70179_y -= this.field_70179_y / (double)f2 * (double)0.05f;
        this.func_70018_K();
    }

    @Override
    public void onEntityHit() {
        if (this.entityHit != null) {
            this.entityHit.func_70097_a(DamageSource.field_76377_j, 1.0f);
        }
    }

    @Override
    public void onEntityDeath() {
        this.explode();
    }

    @Override
    public void onLifeTimeEnd() {
        this.explode();
    }

    @Override
    public void onBlockRemoved() {
        this.explode();
    }

    public void explode() {
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 7.0f, true);
    }

    public int getTicksToExplosion() {
        return this.lifeTime - this.field_70173_aa;
    }

    public float func_70047_e() {
        return this.field_70131_O / 2.0f;
    }
}

