/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import lyon.aom.init.BlockInit;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class OreGenerator
implements IWorldGenerator {
    private final int maxLevelCave = 128;
    private ChunkGeneratorSettings generatorSettingOverworld;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                this.generateOverworld(world, random, chunkX, chunkZ);
            }
        }
    }

    private void generateOverworld(World world, Random random, int chunkX, int chunkZ) {
        this.generateIceBurstStones(world, random, chunkX, chunkZ, 64, 8);
    }

    private void generateIceBurstStones(World world, Random random, int chunkX, int chunkZ, int maxY, int minY) {
        if (this.generatorSettingOverworld == null) {
            String generatorOptions = world.func_72912_H().func_82571_y();
            this.generatorSettingOverworld = ChunkGeneratorSettings.Factory.func_177865_a((String)generatorOptions).func_177864_b();
        }
        if (this.generatorSettingOverworld.field_177839_r) {
            int i;
            int x0 = chunkX * 16 + 8;
            int z0 = chunkZ * 16 + 8;
            int count = random.nextInt(4);
            int q0Width = 1 + random.nextInt(6);
            int q0Height = 1 + random.nextInt(6);
            ArrayList possiblePositions = new ArrayList();
            for (i = 0; i < 4; ++i) {
                possiblePositions.add(new ArrayList());
            }
            for (int a = 0; a < 4; ++a) {
                for (int x = a % 2 > 0 ? 6 + q0Width : 2; x < (a % 2 > 0 ? 14 : 2 + q0Width); ++x) {
                    for (int z = a > 1 ? 6 + q0Width : 2; z < (a > 1 ? 14 : 2 + q0Width); ++z) {
                        int yBegin = 128;
                        boolean foundTop = false;
                        for (int y = yBegin; y >= minY; --y) {
                            BlockPos currentPos = new BlockPos(x0 + x, y, z0 + z);
                            if (!foundTop && world.func_180495_p(currentPos).func_177230_c() != Blocks.field_150350_a) {
                                foundTop = true;
                                continue;
                            }
                            if (!foundTop || y > maxY || world.func_180495_p(currentPos).func_177230_c() != Blocks.field_150350_a || world.func_180495_p(currentPos.func_177977_b()).func_185904_a() != Material.field_151576_e || world.func_175642_b(EnumSkyBlock.SKY, currentPos) > 10 || world.func_175642_b(EnumSkyBlock.BLOCK, currentPos) != 0) continue;
                            ((List)possiblePositions.get(a)).add(currentPos);
                        }
                    }
                }
            }
            if (!possiblePositions.isEmpty()) {
                for (i = 0; i < count && !possiblePositions.isEmpty(); ++i) {
                    int qIndex = random.nextInt(possiblePositions.size());
                    if (!((List)possiblePositions.get(qIndex)).isEmpty()) {
                        int pIndex = random.nextInt(((List)possiblePositions.get(qIndex)).size());
                        world.func_175656_a(new BlockPos(((BlockPos)((List)possiblePositions.get(qIndex)).get(pIndex)).func_177958_n(), ((BlockPos)((List)possiblePositions.get(qIndex)).get(pIndex)).func_177956_o(), ((BlockPos)((List)possiblePositions.get(qIndex)).get(pIndex)).func_177952_p()), BlockInit.ICEBURST_STONE.func_176223_P());
                    }
                    possiblePositions.remove(qIndex);
                }
            }
        }
    }
}

