/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.gui.blast_furnace;

import lyon.aom.blocks.blast_furnace.TileEntityBlastFurnace;
import lyon.aom.gui.blast_furnace.slots.SlotBlastFurnaceFuel;
import lyon.aom.gui.blast_furnace.slots.SlotBlastFurnaceInput1;
import lyon.aom.gui.blast_furnace.slots.SlotBlastFurnaceInput2;
import lyon.aom.gui.blast_furnace.slots.SlotBlastFurnaceOutput;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ContainerBlastFurnace
extends Container {
    private final TileEntityBlastFurnace tileentity;
    private int cookTime;
    private int totalCookTime;
    private int burnTime;
    private int currentBurnTime;

    public ContainerBlastFurnace(InventoryPlayer player, TileEntityBlastFurnace tileentity) {
        this.tileentity = tileentity;
        ItemStackHandler handler = tileentity.getItemHandler();
        this.func_75146_a((Slot)new SlotBlastFurnaceInput1((IItemHandler)handler, 0, 53, 11));
        this.func_75146_a((Slot)new SlotBlastFurnaceInput2((IItemHandler)handler, 1, 53, 59));
        this.func_75146_a((Slot)new SlotBlastFurnaceFuel((IItemHandler)handler, 2, 7, 35));
        this.func_75146_a((Slot)new SlotBlastFurnaceOutput(tileentity, (IItemHandler)handler, 3, 108, 36));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)player, x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)player, x, 8 + x * 18, 142));
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        this.sendFields(false);
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        this.sendFields(false);
    }

    public void sendFields(boolean checkForChanges) {
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            IContainerListener listener = (IContainerListener)this.field_75149_d.get(i);
            if (this.cookTime != this.tileentity.getField(2) || !checkForChanges) {
                listener.func_71112_a((Container)this, 2, this.tileentity.getField(2));
            }
            if (this.burnTime != this.tileentity.getField(0) || !checkForChanges) {
                listener.func_71112_a((Container)this, 0, this.tileentity.getField(0));
            }
            if (this.currentBurnTime != this.tileentity.getField(1) || !checkForChanges) {
                listener.func_71112_a((Container)this, 1, this.tileentity.getField(1));
            }
            if (this.totalCookTime == this.tileentity.getField(3) && checkForChanges) continue;
            listener.func_71112_a((Container)this, 3, this.tileentity.getField(3));
        }
        this.cookTime = this.tileentity.getField(2);
        this.burnTime = this.tileentity.getField(0);
        this.currentBurnTime = this.tileentity.getField(1);
        this.totalCookTime = this.tileentity.getField(3);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        this.tileentity.setField(id, data);
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return this.tileentity.isUsableByPlayer(playerIn);
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        Slot source = this.func_75139_a(index);
        ItemStack sourceStack = source.func_75211_c();
        int inventorySize = this.func_75138_a().size();
        if (source.func_75211_c() == ItemStack.field_190927_a || !this.func_75139_a(index).func_82869_a(playerIn)) {
            return ItemStack.field_190927_a;
        }
        int count = source.func_75211_c().func_190916_E();
        boolean isPlayerSlot = this.isPlayerSlot(index);
        for (int i = 2 * inventorySize; count > 0 && i >= 0; --i) {
            ItemStack s;
            if (this.isPlayerSlot(i % inventorySize) == isPlayerSlot) continue;
            if (this.func_75139_a(i % inventorySize).func_75211_c().func_190926_b() && this.func_75139_a(i % inventorySize).func_75214_a(sourceStack) && i < inventorySize) {
                if (count > this.func_75139_a(i % inventorySize).func_178170_b(sourceStack)) {
                    s = new ItemStack(sourceStack.func_77973_b(), this.func_75139_a(i % inventorySize).func_178170_b(sourceStack), sourceStack.func_77960_j());
                    s.func_77982_d(sourceStack.func_77978_p());
                    this.func_75139_a(i % inventorySize).func_75215_d(s);
                    count -= this.func_75139_a(i % inventorySize).func_178170_b(sourceStack);
                    continue;
                }
                if (count > sourceStack.func_77976_d()) {
                    s = new ItemStack(sourceStack.func_77973_b(), sourceStack.func_77976_d(), sourceStack.func_77960_j());
                    s.func_77982_d(sourceStack.func_77978_p());
                    this.func_75139_a(i % inventorySize).func_75215_d(s);
                    count -= sourceStack.func_77976_d();
                    continue;
                }
                s = new ItemStack(sourceStack.func_77973_b(), count, sourceStack.func_77960_j());
                s.func_77982_d(sourceStack.func_77978_p());
                this.func_75139_a(i % inventorySize).func_75215_d(s);
                count = 0;
                continue;
            }
            if (this.func_75139_a(i % inventorySize).func_75211_c().func_190926_b() || !this.func_75139_a(i % inventorySize).func_75214_a(sourceStack) || i <= inventorySize || !ContainerBlastFurnace.areItemStacksEqual(sourceStack, this.func_75139_a(i % inventorySize).func_75211_c())) continue;
            if (this.func_75139_a(i % inventorySize).func_75211_c().func_190916_E() + count > this.func_75139_a(i % inventorySize).func_178170_b(sourceStack)) {
                s = new ItemStack(sourceStack.func_77973_b(), this.func_75139_a(i % inventorySize).func_178170_b(sourceStack), sourceStack.func_77960_j());
                s.func_77982_d(sourceStack.func_77978_p());
                this.func_75139_a(i % inventorySize).func_75215_d(s);
                count = this.func_75139_a(i % inventorySize).func_75211_c().func_190916_E() + count - this.func_75139_a(i % inventorySize).func_178170_b(sourceStack);
                continue;
            }
            if (this.func_75139_a(i % inventorySize).func_75211_c().func_190916_E() + count > sourceStack.func_77976_d()) {
                s = new ItemStack(sourceStack.func_77973_b(), sourceStack.func_77976_d(), sourceStack.func_77960_j());
                s.func_77982_d(sourceStack.func_77978_p());
                this.func_75139_a(i % inventorySize).func_75215_d(s);
                count = this.func_75139_a(i % inventorySize).func_75211_c().func_190916_E() + count - sourceStack.func_77976_d();
                continue;
            }
            s = new ItemStack(sourceStack.func_77973_b(), this.func_75139_a(i % inventorySize).func_75211_c().func_190916_E() + count, sourceStack.func_77960_j());
            s.func_77982_d(sourceStack.func_77978_p());
            this.func_75139_a(i % inventorySize).func_75215_d(s);
            count = 0;
        }
        if (sourceStack.func_190916_E() != count) {
            ItemStack s = new ItemStack(sourceStack.func_77973_b(), sourceStack.func_190916_E() - count, sourceStack.func_77960_j());
            s.func_77982_d(sourceStack.func_77978_p());
            this.func_75139_a(index).func_190901_a(playerIn, s);
        }
        ItemStack s = new ItemStack(sourceStack.func_77973_b(), count, sourceStack.func_77960_j());
        s.func_77982_d(sourceStack.func_77978_p());
        source.func_75215_d(s);
        return ItemStack.field_190927_a;
    }

    private static boolean areItemStacksEqual(ItemStack stackA, ItemStack stackB) {
        return stackB.func_77973_b() == stackA.func_77973_b() && (!stackA.func_77981_g() || stackA.func_77960_j() == stackB.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB);
    }

    private boolean isPlayerSlot(int index) {
        return !this.func_75139_a(index).isSameInventory(this.func_75139_a(1));
    }
}

