/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.gui.tabbed_survival;

import java.util.ArrayList;
import java.util.List;
import lyon.aom.gui.tabbed_survival.tabs.SurvivalTab;
import lyon.aom.gui.tabbed_survival.tabs.accessory_tab.SurvivalTabAccessory;
import lyon.aom.gui.tabbed_survival.tabs.accessory_tab.SurvivalTabAccessoryClient;
import lyon.aom.gui.tabbed_survival.tabs.default_tab.SurvivalTabDefault;
import lyon.aom.gui.tabbed_survival.tabs.default_tab.SurvivalTabDefaultClient;
import lyon.aom.gui.tabbed_survival.tabs.odm_gear_tab.SurvivalTabODMGear;
import lyon.aom.gui.tabbed_survival.tabs.odm_gear_tab.SurvivalTabODMGearClient;
import lyon.aom.gui.tabbed_survival.tabs.slots.SlotCraftingTabbed;
import lyon.aom.gui.tabbed_survival.tabs.slots.SlotODMGear;
import lyon.aom.packets.PacketHandler;
import lyon.aom.packets.both.set_active_tab_req.PacketSetActiveTabReq;
import lyon.aom.utils.Utils;
import lyon.aom.utils.interfaces.ISetEnabled;
import lyon.aom.utils.interfaces.ITabCrafting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IRecipeContainer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ContainerTabbedSurvival
extends Container
implements IRecipeContainer {
    private List<SurvivalTab> tabs = new ArrayList<SurvivalTab>();
    private SurvivalTab activeTab;
    private EntityPlayer player;

    public ContainerTabbedSurvival(EntityPlayer playerIn) {
        this.player = playerIn;
        this.field_75152_c = 1;
    }

    public ContainerTabbedSurvival(InventoryPlayer playerInventory, boolean localWorld, EntityPlayer playerIn) {
        this(playerIn);
        this.addTab(new SurvivalTabDefault(playerIn, this));
        this.addTab(new SurvivalTabAccessory(playerIn, this));
        this.addTab(new SurvivalTabODMGear(playerIn, this));
        this.initDefaultSlots();
        this.setActiveTab(this.tabs.get(0));
    }

    public ContainerTabbedSurvival(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        this(playerIn);
        this.addTab(new SurvivalTabDefaultClient(new SurvivalTabDefault(playerIn, this), this));
        this.addTab(new SurvivalTabAccessoryClient(new SurvivalTabAccessory(playerIn, this), this));
        this.addTab(new SurvivalTabODMGearClient(new SurvivalTabODMGear(playerIn, this), this));
        this.initDefaultSlots();
        this.setActiveTab(this.tabs.get(0));
    }

    public void setActiveTab(SurvivalTab t) {
        if (t != null && !this.tabs.isEmpty() && this.tabs.contains(t)) {
            for (SurvivalTab tab : this.tabs) {
                if (tab.getSlots() == null || tab.getSlots().isEmpty()) continue;
                for (Slot slot1 : tab.getSlots()) {
                    if (!(slot1 instanceof ISetEnabled)) continue;
                    ((ISetEnabled)slot1).setEnabled(false);
                }
            }
            for (Slot slot2 : t.getSlots()) {
                if (!(slot2 instanceof ISetEnabled)) continue;
                ((ISetEnabled)slot2).setEnabled(true);
            }
            if (this.player.field_70170_p.field_72995_K) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSetActiveTabReq(t.getLabel(), this.player.func_110124_au()));
            }
            this.activeTab = t;
        }
    }

    public void addTab(SurvivalTab tab) {
        if (tab != null && this.tabs != null && this.tabs.size() <= 6) {
            for (SurvivalTab t : this.tabs) {
                if (!t.getLabel().equals(tab.getLabel())) continue;
                return;
            }
            this.tabs.add(tab);
            if (tab.getSlots() != null && !tab.getSlots().isEmpty()) {
                for (Slot s : tab.getSlots()) {
                    this.func_75146_a(s);
                }
            }
        }
    }

    public void removeTab(SurvivalTab tab) {
        if (tab != null && this.tabs != null && !this.tabs.isEmpty() && this.tabs.contains(tab)) {
            this.tabs.remove(tab);
            if (tab.getSlots() != null && !tab.getSlots().isEmpty()) {
                for (Slot s : tab.getSlots()) {
                    int i = this.field_75151_b.indexOf(s);
                    this.field_75151_b.remove(i);
                    this.field_75153_a.remove(i);
                }
            }
        }
    }

    public SurvivalTab getTabWithLabel(String label) {
        if (this.tabs != null && !this.tabs.isEmpty()) {
            for (SurvivalTab t : this.tabs) {
                if (!t.getLabel().equals(label)) continue;
                return t;
            }
        }
        return null;
    }

    public List<SurvivalTab> getTabs() {
        return this.tabs;
    }

    public boolean isSlotActive(Slot s) {
        return s != null && this.field_75151_b.contains(s) && (s.getSlotIndex() >= 9 && s.getSlotIndex() <= 44 || this.activeTab.getSlots().contains(s));
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    public void func_75130_a(IInventory inventoryIn) {
        if (this.activeTab instanceof ITabCrafting) {
            ((ITabCrafting)((Object)this.activeTab)).onCraftMatrixChanged(inventoryIn);
        }
    }

    public void initDefaultSlots() {
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, j1 + (l + 1) * 9, 8 + j1 * 18, 84 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, i1, 8 + i1 * 18, 142));
        }
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (this.tabs != null && !this.tabs.isEmpty()) {
            for (SurvivalTab t : this.tabs) {
                t.onContainerClosed();
            }
        }
    }

    public void clearInventory(EntityPlayer playerIn, World worldIn, IInventory inventoryIn) {
        this.func_193327_a(this.player, worldIn, inventoryIn);
    }

    public SurvivalTab getActiveTab() {
        return this.activeTab;
    }

    public InventoryCraftResult getCraftResult() {
        if (this.activeTab instanceof ITabCrafting) {
            return ((ITabCrafting)((Object)this.activeTab)).getInventoryCraftReslut();
        }
        return null;
    }

    public InventoryCrafting getCraftMatrix() {
        if (this.activeTab instanceof ITabCrafting) {
            return ((ITabCrafting)((Object)this.activeTab)).getInventoryCrafting();
        }
        return null;
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            boolean b = false;
            if (slot instanceof SlotODMGear) {
                ((SlotODMGear)slot).onSlotTransfer();
            }
            if (index < this.field_75151_b.size()) {
                if (Utils.contains(this.activeTab.getSlots().toArray(), slot)) {
                    b = this.transferStackInSlotDefault(playerIn, index);
                } else if (index >= this.field_75151_b.size() - 36 && !this.activeTab.transferStackInSlot(playerIn, index)) {
                    b = this.transferStackInSlotDefault(playerIn, index);
                }
            }
            if (b && slot instanceof SlotCraftingTabbed) {
                return ItemStack.field_190927_a;
            }
            if (slot instanceof SlotCraftingTabbed) {
                slot.func_75220_a(itemstack1, itemstack);
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack itemstack2 = slot.func_190901_a(playerIn, itemstack1);
            if (slot instanceof SlotCraftingTabbed) {
                playerIn.func_71019_a(itemstack2, false);
            }
        }
        return itemstack;
    }

    public boolean transferStackInSlotDefault(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < this.field_75151_b.size() - 36 ? !this.func_75135_a(itemstack1, this.field_75151_b.size() - 36, this.field_75151_b.size(), slot instanceof SlotCraftingTabbed) : (index >= this.field_75151_b.size() - 9 ? !this.func_75135_a(itemstack1, this.field_75151_b.size() - 36, this.field_75151_b.size() - 9, false) : index >= this.field_75151_b.size() - 36 && index < this.field_75151_b.size() - 9 && !this.func_75135_a(itemstack1, this.field_75151_b.size() - 9, this.field_75151_b.size(), false))) {
                return true;
            }
        }
        return false;
    }

    public int getPreviousSlotsNum(SurvivalTab tab) {
        int num = 0;
        if (tab != null && this.tabs.contains(tab)) {
            for (int i = 0; i < this.tabs.size() && !this.tabs.get(i).equals(tab); ++i) {
                num += this.tabs.get(i).getSlots().size();
            }
        }
        return num;
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return this.activeTab.canMergeSlot(stack, slotIn);
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }
}

