/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.items;

import java.util.List;
import lyon.aom.capabilities.odm_gear.IODMGear;
import lyon.aom.capabilities.odm_gear.ODMGearProvider;
import lyon.aom.capabilities.special_equipment.ISpecialEquipment;
import lyon.aom.init.ItemInit;
import lyon.aom.items.base_items.ItemBase;
import lyon.aom.utils.AOMConfig;
import lyon.aom.utils.Utils;
import lyon.aom.utils.enums.EnumEntitys;
import lyon.aom.utils.handlers.KeyBindingHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemODMGear
extends ItemBase {
    public ItemODMGear(String name) {
        super(name);
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ISpecialEquipment equipment = Utils.getSpecialEquipment(playerIn);
        if (equipment != null && playerIn.func_184586_b(handIn).func_77973_b().equals(ItemInit.ODM_GEAR) && equipment.getEquipment(EnumEntitys.SpecialEquipmentSlot.ODM_GEAR).func_190926_b() && equipment.getEquipment(EnumEntitys.SpecialEquipmentSlot.BELT).func_77973_b().equals(ItemInit.BELT)) {
            if (!worldIn.field_72995_K) {
                equipment.setEquipment(EnumEntitys.SpecialEquipmentSlot.ODM_GEAR, playerIn.func_184586_b(handIn).func_77946_l());
                if (!playerIn.func_184812_l_()) {
                    playerIn.func_184611_a(handIn, ItemStack.field_190927_a);
                }
            } else {
                worldIn.func_184134_a(playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187725_r, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        if (nbt != null && nbt.func_74764_b("Parent")) {
            ODMGearProvider provider = new ODMGearProvider();
            return provider;
        }
        return null;
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (stack.func_77942_o()) {
            nbt = super.getNBTShareTag(stack);
        }
        if (stack.hasCapability(ODMGearProvider.ODMGear_CAP, null)) {
            nbt.func_74782_a("Cap", ODMGearProvider.ODMGear_CAP.writeNBT(stack.getCapability(ODMGearProvider.ODMGear_CAP, null), null));
        }
        return nbt;
    }

    public void readNBTShareTag(ItemStack stack, NBTTagCompound nbt) {
        super.readNBTShareTag(stack, nbt);
        if (nbt != null && nbt.func_74764_b("Cap") && stack.hasCapability(ODMGearProvider.ODMGear_CAP, null)) {
            ODMGearProvider.ODMGear_CAP.readNBT(stack.getCapability(ODMGearProvider.ODMGear_CAP, null), null, nbt.func_74781_a("Cap"));
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        Style style = new Style().func_150238_a(TextFormatting.YELLOW);
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71462_r.func_146272_n()) {
            tooltip.add(new TextComponentString(KeyBindingHandler.keyBindToggleODMGearMode.getDisplayName()).func_150255_a(style).func_150254_d() + new TextComponentTranslation("tooltip.odm_gear_text_1.name", new Object[0]).func_150255_a(style).func_150254_d());
            tooltip.add(new TextComponentString(KeyBindingHandler.keyBindToggleBoostMode.getDisplayName()).func_150255_a(style).func_150254_d() + new TextComponentTranslation("tooltip.odm_gear_text_2.name", new Object[0]).func_150255_a(style).func_150254_d());
            tooltip.add(new TextComponentString(KeyBindingHandler.keyBindPullToHooks.getDisplayName()).func_150255_a(style).func_150254_d() + new TextComponentTranslation("tooltip.odm_gear_text_3.name", new Object[0]).func_150255_a(style).func_150254_d());
            tooltip.add(new TextComponentString(KeyBindingHandler.keyBindExtendCables.getDisplayName()).func_150255_a(style).func_150254_d() + new TextComponentTranslation("tooltip.odm_gear_text_4.name", new Object[0]).func_150255_a(style).func_150254_d());
            if (!AOMConfig.useAdvancedODMGearControls) {
                tooltip.add(new TextComponentString(KeyBindingHandler.keyBindDefaultShootHooks.getDisplayName()).func_150255_a(style).func_150254_d() + new TextComponentTranslation("tooltip.odm_gear_text_5.name", new Object[0]).func_150255_a(style).func_150254_d());
            } else {
                tooltip.add(new TextComponentString(KeyBindingHandler.keyBindAdvancedShootLeftHook.getDisplayName()).func_150255_a(style).func_150254_d() + new TextComponentTranslation("tooltip.odm_gear_text_6.name", new Object[0]).func_150255_a(style).func_150254_d());
                tooltip.add(new TextComponentString(KeyBindingHandler.keyBindAdvancedShootRightHook.getDisplayName()).func_150255_a(style).func_150254_d() + new TextComponentTranslation("tooltip.odm_gear_text_7.name", new Object[0]).func_150255_a(style).func_150254_d());
            }
        } else {
            tooltip.add(new TextComponentTranslation("tooltip.extend_controls.name", new Object[]{0}).func_150255_a(style).func_150254_d());
        }
        style = new Style().func_150238_a(TextFormatting.RED);
        Minecraft minecraft2 = Minecraft.func_71410_x();
        if (minecraft2.field_71462_r.func_146271_m()) {
            int gas = 0;
            int blades = 0;
            if (stack.hasCapability(ODMGearProvider.ODMGear_CAP, null)) {
                IODMGear odm_gear = (IODMGear)stack.getCapability(ODMGearProvider.ODMGear_CAP, null);
                gas = this.getGasInODMGear(odm_gear);
                blades = this.getBladesInODMGear(odm_gear);
            }
            tooltip.add(new TextComponentTranslation("tooltip.odm_gear_text_8.name", new Object[]{0}).func_150255_a(style).func_150254_d() + new TextComponentString(": ").func_150255_a(style).func_150254_d() + new TextComponentString(Integer.toString(gas) + "/600 mB").func_150255_a(style).func_150254_d());
            tooltip.add(new TextComponentTranslation("tooltip.odm_gear_text_9.name", new Object[]{0}).func_150255_a(style).func_150254_d() + new TextComponentString(": ").func_150255_a(style).func_150254_d() + new TextComponentString(Integer.toString(blades) + "/8").func_150255_a(style).func_150254_d());
        } else {
            tooltip.add(new TextComponentTranslation("tooltip.extend_info.name", new Object[]{0}).func_150255_a(style).func_150254_d());
        }
    }

    public int getGasInODMGear(IODMGear odm_gear) {
        int gas = 0;
        for (int i = 0; i < odm_gear.getStackHandler().getSlots(); ++i) {
            if (odm_gear.getStackInSlot(i).func_77973_b() != ItemInit.GAS_CARTRIDGE) continue;
            gas += odm_gear.getStackInSlot(i).func_77958_k() - odm_gear.getStackInSlot(i).func_77952_i();
        }
        return gas;
    }

    public int getBladesInODMGear(IODMGear odm_gear) {
        int blades = 0;
        for (int i = 0; i < odm_gear.getStackHandler().getSlots(); ++i) {
            if (odm_gear.getStackInSlot(i).func_77973_b() != ItemInit.BLADE) continue;
            ++blades;
        }
        return blades;
    }
}

