/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.items.tools;

import java.util.Arrays;
import java.util.List;
import lyon.aom.Main;
import lyon.aom.init.ItemInit;
import lyon.aom.init.SoundInit;
import lyon.aom.items.base_items.ItemBase;
import lyon.aom.packets.PacketHandler;
import lyon.aom.packets.both.play_sound_req.PacketPlaySoundReq;
import lyon.aom.packets.both.spawn_particle_req.PacketSpawnParticleReq;
import lyon.aom.packets.client.spawn_projectile_req.PacketSpawnProjectileReq;
import lyon.aom.utils.Utils;
import lyon.aom.utils.enums.EnumEntitys;
import lyon.aom.utils.enums.EnumMeta;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ToolRifle
extends ItemBase {
    private EnumMeta.RifleStates[] subTypes = EnumMeta.RifleStates.values();
    private String name;

    public ToolRifle(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77656_e(50);
        this.name = name;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (!stack.func_77978_p().func_74764_b("State")) {
                stack.func_77978_p().func_74768_a("State", 0);
            }
            if (this.getState(stack) == EnumMeta.RifleStates.EMPTY.getID()) {
                int slot = this.findBullets(playerIn);
                if (slot >= 0) {
                    ItemStack s = playerIn.field_71069_bz.func_75139_a(slot).func_75211_c();
                    ItemStack newS = new ItemStack(s.func_77973_b(), s.func_190916_E() - 1, s.func_77952_i());
                    newS.func_77982_d(s.func_77978_p());
                    playerIn.field_71069_bz.func_75141_a(slot, newS);
                    stack.func_77978_p().func_74768_a("State", EnumMeta.RifleStates.LOADINGSTART.getID());
                }
            } else if (this.getState(stack) == EnumMeta.RifleStates.LOADED.getID()) {
                boolean isRightHand = handIn == EnumHand.MAIN_HAND && playerIn.func_184591_cq() == EnumHandSide.RIGHT || handIn == EnumHand.OFF_HAND && playerIn.func_184591_cq() == EnumHandSide.LEFT;
                double xOff = 1.5 * -Math.sin(Math.toRadians(playerIn.field_70177_z)) * Math.cos(Math.toRadians(playerIn.field_70125_A)) + (double)(isRightHand ? -1 : 1) * Math.cos(Math.toRadians(Utils.modulo(playerIn.field_70177_z, 360.0))) * 0.3125;
                double yOff = 1.5 * -Math.sin(Math.toRadians(playerIn.field_70125_A)) + (playerIn.func_70093_af() ? 1.03125 : 1.28125);
                double zOff = 1.5 * Math.cos(Math.toRadians(playerIn.field_70177_z)) * Math.cos(Math.toRadians(playerIn.field_70125_A)) + (double)(isRightHand ? -1 : 1) * Math.sin(Math.toRadians(Utils.modulo(playerIn.field_70177_z, 360.0))) * 0.3125;
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketPlaySoundReq(SoundInit.RIFLE_SHOT, playerIn.field_70165_t + xOff, playerIn.field_70163_u + yOff, playerIn.field_70161_v + zOff, SoundCategory.PLAYERS, 2.0f, 0.8f, false), new NetworkRegistry.TargetPoint(playerIn.field_71093_bK, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, 40.0));
                for (int i = 0; i < 10; ++i) {
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketSpawnParticleReq(EnumParticleTypes.SMOKE_NORMAL, playerIn.field_70165_t + xOff, playerIn.field_70163_u + yOff, playerIn.field_70161_v + zOff, (double)-0.01f + Math.random() * (double)0.005f, (double)0.01f, (double)-0.01f + Math.random() * (double)0.005f, 0), new NetworkRegistry.TargetPoint(playerIn.field_71093_bK, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, 40.0));
                }
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketSpawnProjectileReq(EnumEntitys.Projectiles.BULLET, playerIn.func_110124_au(), new Vec3d(playerIn.field_70165_t + xOff, playerIn.field_70163_u + yOff, playerIn.field_70161_v + zOff), 5.0, Arrays.asList(600)), (EntityPlayerMP)playerIn);
                stack.func_77978_p().func_74768_a("State", EnumMeta.RifleStates.EMPTY.getID());
                if (!playerIn.func_184812_l_()) {
                    stack.func_77964_b(stack.func_77952_i() + 1);
                }
                if (stack.func_77952_i() >= stack.func_77958_k()) {
                    stack.func_190920_e(0);
                }
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.field_72995_K && this.getState(stack) >= EnumMeta.RifleStates.LOADINGSTART.getID() && this.getState(stack) < EnumMeta.RifleStates.LOADED.getID()) {
            stack.func_77978_p().func_74768_a("State", this.getState(stack) + 1);
            if (this.getState(stack) == EnumMeta.RifleStates.LOADED.getID()) {
                double xOff = 1.5 * -Math.sin(Math.toRadians(entityIn.field_70177_z)) * Math.cos(Math.toRadians(entityIn.field_70125_A)) - Math.cos(Math.toRadians(Utils.modulo(entityIn.field_70177_z, 360.0))) * 0.3125;
                double yOff = 1.5 * -Math.sin(Math.toRadians(entityIn.field_70125_A)) + (entityIn.func_70093_af() ? 1.03125 : 1.28125);
                double zOff = 1.5 * Math.cos(Math.toRadians(entityIn.field_70177_z)) * Math.cos(Math.toRadians(entityIn.field_70125_A)) - Math.sin(Math.toRadians(Utils.modulo(entityIn.field_70177_z, 360.0))) * 0.3125;
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketPlaySoundReq(SoundInit.RIFLE_RELOAD, entityIn.field_70165_t + xOff, entityIn.field_70163_u + yOff, entityIn.field_70161_v + zOff, SoundCategory.PLAYERS, 1.35f, 1.0f, false), new NetworkRegistry.TargetPoint(entityIn.field_71093_bK, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, 40.0));
            }
        }
    }

    private int getState(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("State")) {
            return stack.func_77978_p().func_74762_e("State");
        }
        return 0;
    }

    private int findBullets(EntityPlayer playerIn) {
        List inventory = playerIn.field_71069_bz.field_75151_b;
        for (int i = inventory.size() - 1; i >= 0; --i) {
            if (((Slot)inventory.get(i)).func_75211_c().func_77973_b() != ItemInit.BULLET) continue;
            return i;
        }
        return -1;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77952_i() != newStack.func_77952_i();
    }

    public String func_77667_c(ItemStack stack) {
        return "item." + this.name + "." + (this.getState(stack) == EnumMeta.RifleStates.LOADED.getID() ? EnumMeta.RifleStates.LOADED : EnumMeta.RifleStates.EMPTY).getName();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void registerModels() {
        for (int i = 0; i < this.subTypes.length; ++i) {
            Main.proxy.registerItemMetaRenderer(this, i, "aom:" + this.getName(), "inventory");
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        Style style = new Style().func_150238_a(TextFormatting.YELLOW);
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71462_r.func_146272_n()) {
            tooltip.add(new TextComponentString(Minecraft.func_71410_x().field_71474_y.field_74313_G.getDisplayName()).func_150255_a(style).func_150254_d() + new TextComponentTranslation("tooltip.rifle_text_1.name", new Object[0]).func_150255_a(style).func_150254_d());
        } else {
            tooltip.add(new TextComponentTranslation("tooltip.extend_controls.name", new Object[]{0}).func_150255_a(style).func_150254_d());
        }
    }
}

