/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.odm_gear.handlers;

import java.util.ArrayList;
import java.util.List;
import lyon.aom.Main;
import lyon.aom.capabilities.odm_gear.IODMGear;
import lyon.aom.capabilities.special_equipment.ISpecialEquipment;
import lyon.aom.entity.hook.EntityHook;
import lyon.aom.init.ItemInit;
import lyon.aom.init.SoundInit;
import lyon.aom.packets.PacketHandler;
import lyon.aom.packets.both.decrease_left_ticks_boost_req.PacketDecreaseLeftTicksBoostReq;
import lyon.aom.packets.both.play_sound_req.PacketPlaySoundReq;
import lyon.aom.packets.both.set_cable_length_req.PacketSetCableLengthReq;
import lyon.aom.packets.both.set_fall_distance_req.PacketSetFallDistanceReq;
import lyon.aom.packets.both.spawn_particle_req.PacketSpawnParticleReq;
import lyon.aom.proxy.ClientProxy;
import lyon.aom.utils.AOMConfig;
import lyon.aom.utils.Utils;
import lyon.aom.utils.enums.EnumEntitys;
import lyon.aom.utils.enums.EnumMain;
import lyon.aom.utils.enums.EnumParticles;
import lyon.aom.utils.handlers.KeyBindingHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import scala.Tuple2;

public class ODMGearMovementHandler {
    public static final float gravitation = 0.08f;
    private int ticksToBrake = 0;
    private int ticksToPlay = 0;
    private boolean isPulling = false;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        IODMGear odm_gear;
        EntityPlayer player = event.player;
        Vec3d playerVec = player.func_174791_d().func_72441_c(0.0, 0.8125 - (player.func_70093_af() ? 0.2133 : 0.0), 0.0);
        if (event.side == Side.CLIENT && event.phase == TickEvent.Phase.START) {
            if (player == Minecraft.func_71410_x().field_71439_g && player.field_70170_p.field_72995_K) {
                ISpecialEquipment equipment = Utils.getSpecialEquipment(player);
                IODMGear odm_gear2 = Utils.getODMGear(player);
                int toDecrease = 0;
                if (odm_gear2 != null && equipment != null) {
                    if (equipment.getEquipment(EnumEntitys.SpecialEquipmentSlot.ODM_GEAR).func_77973_b() == ItemInit.ODM_GEAR && !player.func_184218_aH()) {
                        this.handleSwinging(player, odm_gear2, playerVec);
                        if (this.handleEmergencyBoost(player, playerVec, odm_gear2)) {
                            ++toDecrease;
                        } else {
                            this.extendCables(odm_gear2, player);
                            this.pullToHook(EnumMain.EnumHands.BOTH, player, playerVec, odm_gear2);
                            toDecrease = this.isPulling ? ++toDecrease : (toDecrease += this.handleBoost(player, equipment, odm_gear2, playerVec));
                        }
                        if (toDecrease > 0 && !player.func_184812_l_()) {
                            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketDecreaseLeftTicksBoostReq(toDecrease));
                        }
                    }
                } else {
                    this.isPulling = false;
                    this.ticksToBrake = 0;
                    this.ticksToPlay = 0;
                }
                if (player.field_70181_x >= 0.0) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSetFallDistanceReq(0.0f));
                    player.field_70143_R = 0.0f;
                }
                if (this.ticksToPlay > 0) {
                    --this.ticksToPlay;
                }
            }
        } else if (event.side == Side.SERVER && event.phase == TickEvent.Phase.END && !player.field_70170_p.field_72995_K && (odm_gear = Utils.getODMGear(player)) != null) {
            this.handleServerSide(player, odm_gear, playerVec);
        }
    }

    private void handleSwinging(EntityPlayer player, IODMGear odm_gear, Vec3d playerVec) {
        ArrayList<Tuple2> anchorList = new ArrayList<Tuple2>();
        EntityHook leftHook = odm_gear.getHook(EnumHandSide.LEFT, player.field_70170_p);
        EntityHook rightHook = odm_gear.getHook(EnumHandSide.RIGHT, player.field_70170_p);
        if (leftHook != null && leftHook.isStuck()) {
            anchorList.add(new Tuple2((Object)leftHook, (Object)EnumHandSide.LEFT));
        }
        if (rightHook != null && rightHook.isStuck()) {
            anchorList.add(new Tuple2((Object)rightHook, (Object)EnumHandSide.RIGHT));
        }
        if (!anchorList.isEmpty()) {
            float dxVel = 0.0f;
            float dyVel = 0.0f;
            float dzVel = 0.0f;
            boolean b = false;
            if (player.field_70181_x < 0.0) {
                float fall = (float)Math.abs((double)0.04f * Math.pow(player.field_70181_x / (double)0.08f, 2.0));
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSetFallDistanceReq(fall));
                player.field_70143_R = fall;
            }
            for (int i = 0; i < anchorList.size(); ++i) {
                float cableLength = odm_gear.getCableLength((EnumHandSide)((Tuple2)anchorList.get((int)i))._2, player.field_70170_p);
                if (!(cableLength >= 0.0f)) continue;
                Vec3d hookVec = ((EntityHook)((Object)((Tuple2)anchorList.get((int)i))._1)).func_174791_d().func_72441_c(0.0, (double)(((EntityHook)((Object)((Tuple2)anchorList.get((int)i))._1)).field_70131_O / 2.0f), 0.0);
                Vec3d connectionVec = hookVec.func_178788_d(playerVec);
                if (connectionVec.func_72433_c() >= (double)cableLength) {
                    if (!player.field_70122_E && !b) {
                        if (Math.sqrt(player.field_70159_w * player.field_70159_w + player.field_70181_x * player.field_70181_x + player.field_70179_y * player.field_70179_y) < 1.5) {
                            player.field_70159_w /= 0.94;
                            player.field_70181_x /= 0.94;
                            player.field_70179_y /= 0.94;
                        } else {
                            player.field_70159_w /= 0.97;
                            player.field_70181_x /= 0.97;
                            player.field_70179_y /= 0.97;
                        }
                        b = true;
                    }
                    float s = (float)(-(player.field_70159_w * connectionVec.field_72450_a + player.field_70181_x * connectionVec.field_72448_b + player.field_70179_y * connectionVec.field_72449_c + (double)0.08f * connectionVec.field_72448_b) / connectionVec.func_72430_b(connectionVec));
                    Vec3d ft = connectionVec.func_186678_a((double)s);
                    dxVel = (float)((double)dxVel + ft.field_72450_a);
                    dyVel = (float)((double)dyVel + ft.field_72448_b);
                    dzVel = (float)((double)dzVel + ft.field_72449_c);
                }
                if (!(connectionVec.func_72433_c() > (double)cableLength)) continue;
                Vec3d vec = playerVec.func_178788_d(((EntityHook)((Object)((Tuple2)anchorList.get((int)i))._1)).func_174791_d()).func_72432_b().func_186678_a((double)cableLength);
                dxVel = (float)((double)dxVel + (((EntityHook)((Object)((Tuple2)anchorList.get((int)i))._1)).func_174791_d().field_72450_a + vec.field_72450_a - playerVec.field_72450_a));
                dyVel = (float)((double)dyVel + (((EntityHook)((Object)((Tuple2)anchorList.get((int)i))._1)).func_174791_d().field_72448_b + vec.field_72448_b - playerVec.field_72448_b));
                dzVel = (float)((double)dzVel + (((EntityHook)((Object)((Tuple2)anchorList.get((int)i))._1)).func_174791_d().field_72449_c + vec.field_72449_c - playerVec.field_72449_c));
            }
            player.field_70159_w += (double)(dxVel / (float)anchorList.size());
            player.field_70181_x += (double)(dyVel / (float)anchorList.size());
            player.field_70179_y += (double)(dzVel / (float)anchorList.size());
        }
    }

    private boolean handleEmergencyBoost(EntityPlayer player, Vec3d playerVec, IODMGear odm_gear) {
        if (AOMConfig.useEmergencyBoost && KeyBindingHandler.isBoostModeActive && (odm_gear.canBoost() || player.func_184812_l_())) {
            Vec3d vec = new Vec3d(0.0, 0.0, 0.0);
            int particleNum = 5;
            float velFac = 1.0f;
            List list = player.field_70170_p.func_184144_a((Entity)player, player.func_174813_aQ().func_72321_a(player.field_70159_w, player.field_70181_x - 1.5, player.field_70179_y));
            if (list != null && !list.isEmpty() && !player.field_70122_E && player.field_70181_x <= (double)-0.075f && player.field_70143_R > 3.0f) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSetFallDistanceReq(0.0f));
                player.field_70143_R = 0.0f;
                vec = vec.func_72441_c(0.0, (double)-0.06f - player.field_70181_x, 0.0);
                velFac = 0.2f;
                this.ticksToBrake = 5;
            } else if (this.ticksToBrake > 0) {
                if (player.field_70122_E || player.field_70128_L) {
                    this.ticksToBrake = 0;
                } else {
                    vec = vec.func_72441_c(0.0, -player.field_70181_x * (double)0.3f, 0.0);
                    particleNum = 10;
                    velFac = 13.0f;
                    --this.ticksToBrake;
                }
            }
            player.field_70159_w += vec.field_72450_a;
            player.field_70181_x += vec.field_72448_b;
            player.field_70179_y += vec.field_72449_c;
            if (vec.func_72433_c() != 0.0) {
                this.spawnParticlesAndPlaySound(player, playerVec, vec, velFac, particleNum);
                return true;
            }
        }
        return false;
    }

    private void extendCables(IODMGear odm_gear, EntityPlayer player) {
        EntityHook leftHook = odm_gear.getHook(EnumHandSide.LEFT, player.field_70170_p);
        EntityHook rightHook = odm_gear.getHook(EnumHandSide.RIGHT, player.field_70170_p);
        if (KeyBindingHandler.keyBindExtendCables.func_151470_d() && !KeyBindingHandler.keyBindPullToHooks.func_151470_d()) {
            if (leftHook != null && leftHook.isStuck()) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSetCableLengthReq(EnumHandSide.LEFT, Math.min(odm_gear.getCableLength(EnumHandSide.LEFT, player.field_70170_p) + 0.15f, (float)AOMConfig.maxCableLength)));
            }
            if (rightHook != null && rightHook.isStuck()) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSetCableLengthReq(EnumHandSide.RIGHT, Math.min(odm_gear.getCableLength(EnumHandSide.RIGHT, player.field_70170_p) + 0.15f, (float)AOMConfig.maxCableLength)));
            }
        }
    }

    private int handleBoost(EntityPlayer player, ISpecialEquipment equipment, IODMGear odm_gear, Vec3d playerVec) {
        int toDecrease = 0;
        if (odm_gear.canBoost() || player.func_184812_l_()) {
            boolean b = AOMConfig.canUseODMGearWithElytra;
            if (Main.proxy instanceof ClientProxy && !Minecraft.func_71410_x().func_71356_B() && ((ClientProxy)Main.proxy).getSyncedField("canUseODMGearWithElytra", Boolean.class) != null) {
                b = ((ClientProxy)Main.proxy).getSyncedField("canUseODMGearWithElytra", Boolean.class);
            }
            if ((b || !b && !player.func_184613_cA()) && KeyBindingHandler.isBoostModeActive && (odm_gear.canBoost() || player.func_184812_l_())) {
                int particleNum = 5;
                float velFac = 1.0f;
                Vec3d vec = new Vec3d(0.0, 0.0, 0.0);
                if (!this.isPulling) {
                    if (Minecraft.func_71410_x().field_71474_y.field_74351_w.func_151470_d()) {
                        vec = vec.func_178787_e(Utils.rotateVector(new Vec3d(0.0, 0.0, 1.0), (float)Math.toRadians(player.field_70125_A), (float)Math.toRadians(player.field_70126_B), 0.0f));
                    }
                    if (Minecraft.func_71410_x().field_71474_y.field_74368_y.func_151470_d()) {
                        vec = vec.func_178787_e(Utils.rotateVector(new Vec3d(0.0, 0.0, -1.0), (float)Math.toRadians(player.field_70125_A), (float)Math.toRadians(player.field_70126_B), 0.0f));
                    }
                    if (Minecraft.func_71410_x().field_71474_y.field_74370_x.func_151470_d()) {
                        vec = vec.func_178787_e(Utils.rotateVector(new Vec3d(1.0, 0.0, 0.0), (float)Math.toRadians(player.field_70125_A), (float)Math.toRadians(player.field_70126_B), 0.0f));
                    }
                    if (Minecraft.func_71410_x().field_71474_y.field_74366_z.func_151470_d()) {
                        vec = vec.func_178787_e(Utils.rotateVector(new Vec3d(-1.0, 0.0, 0.0), (float)Math.toRadians(player.field_70125_A), (float)Math.toRadians(player.field_70126_B), 0.0f));
                    }
                    if (!(!Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d() || odm_gear.canSwing(player.field_70170_p) && this.areCablesStretched(odm_gear, player, playerVec))) {
                        vec = vec.func_72441_c(0.0, 1.0, 0.0);
                    }
                    if ((vec = vec.func_72432_b().func_186678_a((double)0.054f)).func_72433_c() != 0.0) {
                        ++toDecrease;
                    }
                    if (Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d() && odm_gear.canSwing(player.field_70170_p) && this.areCablesStretched(odm_gear, player, playerVec)) {
                        vec = vec.func_72441_c(0.0, (double)0.14f, 0.0);
                        ++toDecrease;
                    }
                }
                if (vec.func_72433_c() > 0.0) {
                    player.field_70159_w += vec.field_72450_a;
                    player.field_70181_x += vec.field_72448_b;
                    player.field_70179_y += vec.field_72449_c;
                    this.spawnParticlesAndPlaySound(player, playerVec, vec, velFac, particleNum);
                }
            }
        }
        return toDecrease;
    }

    public void pullToHook(EnumMain.EnumHands hand, EntityPlayer player, Vec3d playerVec, IODMGear odm_gear) {
        if (KeyBindingHandler.keyBindPullToHooks.func_151470_d() && !KeyBindingHandler.keyBindExtendCables.func_151470_d()) {
            if (!this.isPulling) {
                if (this.areCablesStretched(odm_gear, player, playerVec) && (odm_gear.canBoost() || player.func_184812_l_())) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketPlaySoundReq(SoundInit.ODM_GEAR_PULL, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundCategory.PLAYERS, 1.0f, 1.0f, false));
                    this.resetCableLength(odm_gear, player, playerVec);
                    if (player.func_70093_af()) {
                        player.field_70159_w = 0.0;
                        player.field_70181_x = -0.08f;
                        player.field_70179_y = 0.0;
                    }
                    this.isPulling = true;
                } else {
                    this.retractCables(odm_gear, player, playerVec, 5.0f);
                }
            }
            if (this.isPulling && (odm_gear.canBoost() || player.func_184812_l_())) {
                EntityHook leftHook = odm_gear.getHook(EnumHandSide.LEFT, player.field_70170_p);
                EntityHook rightHook = odm_gear.getHook(EnumHandSide.RIGHT, player.field_70170_p);
                Vec3d endPoint = null;
                Vec3d leftHookPos = null;
                Vec3d rightHookPos = null;
                if (leftHook != null && leftHook.isStuck()) {
                    leftHookPos = leftHook.func_174791_d();
                }
                if (rightHook != null && rightHook.isStuck()) {
                    rightHookPos = rightHook.func_174791_d();
                }
                if (hand == EnumMain.EnumHands.BOTH && leftHookPos != null && rightHookPos != null) {
                    endPoint = leftHookPos.func_178787_e(rightHookPos.func_178788_d(leftHookPos).func_186678_a(0.5));
                } else if ((hand == EnumMain.EnumHands.LEFT || hand == EnumMain.EnumHands.BOTH) && leftHookPos != null) {
                    endPoint = leftHookPos;
                } else if ((hand == EnumMain.EnumHands.RIGHT || hand == EnumMain.EnumHands.BOTH) && rightHookPos != null) {
                    endPoint = rightHookPos;
                }
                if (endPoint != null) {
                    int particleNum = 5;
                    float velFac = 1.5f;
                    Vec3d connectionVec = endPoint.func_178788_d(playerVec);
                    Vec3d boostVec = connectionVec.func_72432_b().func_186678_a(0.2);
                    if (connectionVec.func_72433_c() < boostVec.func_72433_c()) {
                        boostVec = connectionVec.func_178788_d(connectionVec.func_72432_b().func_186678_a((double)(player.field_70130_N / 2.0f)));
                    }
                    if (connectionVec.func_72433_c() > 0.25) {
                        player.field_70159_w += boostVec.field_72450_a;
                        player.field_70181_x += boostVec.field_72448_b + (double)0.072f;
                        player.field_70179_y += boostVec.field_72449_c;
                        if (connectionVec.func_72433_c() >= 1.5) {
                            this.spawnParticlesAndPlaySound(player, playerVec, boostVec, velFac, particleNum);
                        }
                    }
                    return;
                }
            }
        }
        if (this.isPulling) {
            this.setCableLength(odm_gear, player, playerVec);
            this.isPulling = false;
        }
    }

    private void handleServerSide(EntityPlayer player, IODMGear odm_gear, Vec3d playerVec) {
        float dist;
        EntityHook leftHook = odm_gear.getHook(EnumHandSide.LEFT, player.field_70170_p);
        float leftCableLength = odm_gear.getCableLength(EnumHandSide.LEFT, player.field_70170_p);
        EntityHook rightHook = odm_gear.getHook(EnumHandSide.RIGHT, player.field_70170_p);
        float rightCableLength = odm_gear.getCableLength(EnumHandSide.RIGHT, player.field_70170_p);
        if (leftCableLength >= 0.0f && leftHook != null && leftHook.isStuck() && (double)((dist = (float)leftHook.func_174791_d().func_72441_c(0.0, (double)leftHook.field_70131_O / 2.0, 0.0).func_178788_d(playerVec).func_72433_c()) - leftCableLength) > 10.0) {
            leftHook.func_70106_y();
            odm_gear.setHook(null, EnumHandSide.LEFT);
        }
        if (odm_gear.getCableLength(EnumHandSide.RIGHT, player.field_70170_p) >= 0.0f && rightHook != null && rightHook.isStuck() && (double)((dist = (float)rightHook.func_174791_d().func_72441_c(0.0, (double)rightHook.field_70131_O / 2.0, 0.0).func_178788_d(playerVec).func_72433_c()) - rightCableLength) > 10.0) {
            rightHook.func_70106_y();
            odm_gear.setHook(null, EnumHandSide.RIGHT);
        }
    }

    private void spawnParticlesAndPlaySound(EntityPlayer player, Vec3d playerVec, Vec3d boostVec, float velFac, int particleNum) {
        Vec3d offset = Utils.rotateVecY(new Vec3d(0.0, 0.0, (double)-0.2f), (float)Math.toRadians(Utils.modulo(player.field_70761_aq, 360.0)));
        if (this.ticksToPlay == 0) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketPlaySoundReq(SoundInit.ICEBURST_STONE_STEAMING, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundCategory.PLAYERS, 0.25f, 1.25f, false));
            this.ticksToPlay = 5;
        }
        for (int i = 0; i < particleNum; ++i) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSpawnParticleReq(EnumParticles.EnumAOMParticleTypes.BOOST, playerVec.field_72450_a + offset.field_72450_a - player.field_70159_w * (double)i / (double)particleNum, playerVec.field_72448_b + offset.field_72448_b - player.field_70181_x * (double)i / (double)particleNum, playerVec.field_72449_c + offset.field_72449_c - player.field_70179_y * (double)i / (double)particleNum, -boostVec.func_186678_a((double)((double)velFac)).field_72450_a + ((double)-0.03f + (double)0.06f * Math.random()), -boostVec.func_186678_a((double)((double)velFac)).field_72448_b + ((double)-0.03f + (double)0.06f * Math.random()), -boostVec.func_186678_a((double)((double)velFac)).field_72449_c + ((double)-0.03f + (double)0.06f * Math.random()), 0));
        }
    }

    private void resetCableLength(IODMGear odm_gear, EntityPlayer player, Vec3d playerVec) {
        Vec3d leftHookPos = null;
        Vec3d rightHookPos = null;
        EntityHook leftHook = odm_gear.getHook(EnumHandSide.LEFT, player.field_70170_p);
        EntityHook rightHook = odm_gear.getHook(EnumHandSide.RIGHT, player.field_70170_p);
        if (leftHook != null) {
            leftHookPos = leftHook.func_174791_d();
        }
        if (rightHook != null) {
            rightHookPos = rightHook.func_174791_d();
        }
        if (leftHook != null) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSetCableLengthReq(EnumHandSide.LEFT, -1.0f));
        }
        if (rightHook != null) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSetCableLengthReq(EnumHandSide.RIGHT, -1.0f));
        }
    }

    private void setCableLength(IODMGear odm_gear, EntityPlayer player, Vec3d playerVec) {
        Vec3d leftHookPos = null;
        Vec3d rightHookPos = null;
        EntityHook leftHook = odm_gear.getHook(EnumHandSide.LEFT, player.field_70170_p);
        EntityHook rightHook = odm_gear.getHook(EnumHandSide.RIGHT, player.field_70170_p);
        if (leftHook != null) {
            leftHookPos = leftHook.func_174791_d();
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSetCableLengthReq(EnumHandSide.LEFT, (float)Utils.vecDist(playerVec, leftHookPos)));
        }
        if (rightHook != null) {
            rightHookPos = rightHook.func_174791_d();
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSetCableLengthReq(EnumHandSide.RIGHT, (float)Utils.vecDist(playerVec, rightHookPos)));
        }
    }

    private boolean areCablesStretched(IODMGear odm_gear, EntityPlayer player, Vec3d playerVec) {
        boolean isLeftCableStrechted;
        Vec3d leftHookPos = null;
        Vec3d rightHookPos = null;
        EntityHook leftHook = odm_gear.getHook(EnumHandSide.LEFT, player.field_70170_p);
        EntityHook rightHook = odm_gear.getHook(EnumHandSide.RIGHT, player.field_70170_p);
        if (leftHook != null && leftHook.isStuck()) {
            leftHookPos = leftHook.func_174791_d();
        }
        if (rightHook != null && rightHook.isStuck()) {
            rightHookPos = rightHook.func_174791_d();
        }
        boolean bl = leftHookPos != null ? Utils.vecDist(leftHookPos, playerVec) >= (double)(odm_gear.getCableLength(EnumHandSide.LEFT, player.field_70170_p) * 0.95f) : (isLeftCableStrechted = false);
        boolean isRightCableStrechted = rightHookPos != null ? Utils.vecDist(rightHookPos, playerVec) >= (double)(odm_gear.getCableLength(EnumHandSide.RIGHT, player.field_70170_p) * 0.95f) : false;
        return isLeftCableStrechted || isRightCableStrechted;
    }

    public void retractCables(IODMGear odm_gear, EntityPlayer player, Vec3d playerVec, float amount) {
        float length;
        boolean isRightCableStrechted;
        boolean isLeftCableStrechted;
        Vec3d leftHookPos = null;
        Vec3d rightHookPos = null;
        EntityHook leftHook = odm_gear.getHook(EnumHandSide.LEFT, player.field_70170_p);
        float leftCableLength = odm_gear.getCableLength(EnumHandSide.LEFT, player.field_70170_p);
        EntityHook rightHook = odm_gear.getHook(EnumHandSide.RIGHT, player.field_70170_p);
        float rightCableLength = odm_gear.getCableLength(EnumHandSide.RIGHT, player.field_70170_p);
        if (leftHook != null && leftHook.isStuck()) {
            leftHookPos = leftHook.func_174791_d();
        }
        if (rightHook != null && rightHook.isStuck()) {
            rightHookPos = rightHook.func_174791_d();
        }
        boolean bl = leftHookPos != null ? Utils.vecDist(leftHookPos, playerVec) >= (double)leftCableLength : (isLeftCableStrechted = false);
        boolean bl2 = rightHookPos != null ? Utils.vecDist(rightHookPos, playerVec) >= (double)rightCableLength : (isRightCableStrechted = false);
        if (leftHookPos != null && !isLeftCableStrechted) {
            length = (float)Math.max(Utils.vecDist(leftHookPos, playerVec), (double)(leftCableLength - amount));
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSetCableLengthReq(EnumHandSide.LEFT, length));
        }
        if (rightHookPos != null && !isRightCableStrechted) {
            length = (float)Math.max(Utils.vecDist(rightHookPos, playerVec), (double)(rightCableLength - amount));
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSetCableLengthReq(EnumHandSide.RIGHT, length));
        }
    }
}

