/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.odm_gear.render;

import lyon.aom.capabilities.odm_gear.IODMGear;
import lyon.aom.entity.hook.EntityHook;
import lyon.aom.utils.Utils;
import lyon.aom.utils.render.UtilsRender;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CableRenderer {
    @SideOnly(value=Side.CLIENT)
    public static void renderCable(EnumHandSide side, EntityPlayer player, IODMGear odm_gear, EntityHook hook, ResourceLocation cableTexture, float partialTick) {
        Vec3d start = Utils.rotateVector(new Vec3d((side == EnumHandSide.RIGHT ? -1.0 : 1.0) * 4.0 / 16.0, 0.8125 - (player.func_70093_af() ? 0.2133 : 0.0), 0.0), 0.0f, (float)Math.toRadians(Utils.modulo(player.field_70761_aq, 360.0)), 0.0f);
        Vec3d preStart = Utils.rotateVector(new Vec3d((side == EnumHandSide.RIGHT ? -1.0 : 1.0) * 4.0 / 16.0, 0.8125 - (player.func_70093_af() ? 0.2133 : 0.0), 0.0), 0.0f, (float)Math.toRadians(Utils.modulo(player.field_70760_ar, 360.0)), 0.0f);
        Vec3d ipRelStartPos = Utils.interpolateVec(start, preStart, partialTick);
        Vec3d ipPlayerPos = Utils.interpolateVec(new Vec3d(start.field_72450_a + player.field_70165_t, start.field_72448_b + player.field_70163_u, start.field_72449_c + player.field_70161_v), new Vec3d(preStart.field_72450_a + player.field_70169_q, preStart.field_72448_b + player.field_70167_r, preStart.field_72449_c + player.field_70166_s), partialTick);
        Vec3d ipHookPos = Utils.interpolateVec(new Vec3d(hook.field_70165_t, hook.field_70163_u + (double)(hook.field_70131_O / 2.0f), hook.field_70161_v), new Vec3d(hook.field_70169_q, hook.field_70167_r + (double)(hook.field_70131_O / 2.0f), hook.field_70166_s), partialTick);
        CableRenderer.renderCableWithCurvature(ipRelStartPos, ipPlayerPos, ipHookPos, player, odm_gear, side, cableTexture, partialTick);
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderCableWithCurvature(Vec3d relStartPos, Vec3d playerVec, Vec3d hookVec, EntityPlayer player, IODMGear odm_gear, EnumHandSide side, ResourceLocation cableTexture, float partialTick) {
        Vec3d connectionVec = hookVec.func_178788_d(playerVec);
        Vec3d normHorConVec = new Vec3d(connectionVec.field_72450_a, 0.0, connectionVec.field_72449_c).func_72432_b();
        float horizontalDiff = (float)Math.sqrt(connectionVec.field_72450_a * connectionVec.field_72450_a + connectionVec.field_72449_c * connectionVec.field_72449_c);
        float verticalDiff = (float)connectionVec.field_72448_b;
        float l = odm_gear.getCableLength(side, player.field_70170_p);
        int n = 100;
        if (l < 0.0f) {
            l = 0.0f;
        }
        GlStateManager.func_179094_E();
        if (Math.sqrt(verticalDiff * verticalDiff + horizontalDiff * horizontalDiff) >= (double)l || horizontalDiff == 0.0f) {
            CableRenderer.renderCableStraight(relStartPos, playerVec, hookVec, player, cableTexture, partialTick);
        } else {
            float step;
            float a = CableRenderer.newtonMethod1(horizontalDiff, verticalDiff, l);
            float x0 = CableRenderer.newtonMethod2(a, horizontalDiff, verticalDiff, l);
            float y0 = (float)((double)(-a) * Math.cosh(-x0 / a));
            float x = step = horizontalDiff / (float)n;
            float preResult = 0.0f;
            for (int i = 0; i < n; ++i) {
                float result = (float)((double)a * Math.cosh((x - x0) / a) + (double)y0);
                Vec3d start = relStartPos.func_178787_e(normHorConVec.func_186678_a((double)((float)i * step))).func_72441_c(0.0, (double)preResult, 0.0);
                Vec3d conVec = normHorConVec.func_186678_a((double)step).func_72441_c(0.0, (double)(result - preResult), 0.0);
                CableRenderer.renderCableSegment(start, conVec, player, cableTexture);
                x = (float)(i + 2) * step;
                preResult = result;
            }
        }
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderCableStraight(Vec3d relStartPos, Vec3d playerVec, Vec3d hookVec, EntityPlayer player, ResourceLocation cableTexture, float partialTick) {
        GlStateManager.func_179094_E();
        CableRenderer.renderCableSegment(relStartPos, hookVec.func_178788_d(playerVec), player, cableTexture);
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderCableSegment(Vec3d startVec, Vec3d connectionVec, EntityPlayer player, ResourceLocation cableTexture) {
        GlStateManager.func_179129_p();
        Tessellator tessellator = Tessellator.func_178181_a();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(cableTexture);
        Vec3d centerVec = startVec.func_178787_e(connectionVec.func_186678_a(0.5));
        int light = player.field_70170_p.func_175626_b(player.func_180425_c(), 0);
        UtilsRender.renderQuad(tessellator, EnumFacing.UP, centerVec.field_72450_a, centerVec.field_72448_b, centerVec.field_72449_c, 0.046875, connectionVec.func_72433_c(), Utils.pitchVecAbsolute(connectionVec), Utils.yawVecAbsolute(connectionVec), 0.0f, light, 0.0, false, cableTexture);
        UtilsRender.renderQuad(tessellator, EnumFacing.UP, centerVec.field_72450_a, centerVec.field_72448_b, centerVec.field_72449_c, 0.046875, connectionVec.func_72433_c(), Utils.pitchVecAbsolute(connectionVec), Utils.yawVecAbsolute(connectionVec), 1.5707964f, light, 0.0, false, cableTexture);
        GlStateManager.func_179089_o();
    }

    public static float newtonMethod1(float xB, float yB, float length) {
        float a = 2.0f;
        float result = CableRenderer.function1(a, xB, yB, length);
        for (int iter = 0; (double)Math.abs(result) > Math.pow(10.0, -4.0) && iter < 100; ++iter) {
            float gradient;
            float preA = a;
            float oldResult = result;
            if (oldResult == (result = CableRenderer.function1(a -= result / (gradient = CableRenderer.derivation1(a, xB, yB, length)), xB, yB, length))) break;
            if (result != Float.POSITIVE_INFINITY && result != Float.NEGATIVE_INFINITY && !(a < 0.0f)) continue;
            return CableRenderer.bisection1(0.0f, preA, xB, yB, length);
        }
        return Math.abs(a);
    }

    public static float bisection1(float left, float right, float xB, float yB, float length) {
        float middle = left + (right - left) / 2.0f;
        for (int iter = 0; (double)Math.abs(CableRenderer.function1(middle, xB, yB, length)) > Math.pow(10.0, -4.0) && iter < 100; ++iter) {
            float signLeft = Math.signum(CableRenderer.function1(left, xB, yB, length));
            if (left == 0.0f) {
                signLeft = 1.0f;
            }
            if (signLeft != Math.signum(CableRenderer.function1(middle, xB, yB, length))) {
                right = middle;
            } else {
                if (Math.signum(CableRenderer.function1(middle, xB, yB, length)) == Math.signum(CableRenderer.function1(right, xB, yB, length))) break;
                left = middle;
            }
            middle = left + (right - left) / 2.0f;
        }
        return Math.abs(middle);
    }

    public static float function1(float a, float xB, float yB, float length) {
        return (float)((double)(2.0f * a) * Math.sinh(xB / (2.0f * a)) - Math.sqrt(length * length - yB * yB));
    }

    public static float derivation1(float a, float xB, float yB, float length) {
        return (float)(2.0 * Math.sinh(xB / (2.0f * a)) - (double)(xB / a) * Math.cosh(xB / (2.0f * a)));
    }

    public static float newtonMethod2(float a, float xB, float yB, float length) {
        float gradient;
        float oldResult;
        float x0 = 0.0f;
        float result = CableRenderer.function2(x0, a, xB, yB, length);
        for (int i = 0; (double)Math.abs(result) > Math.pow(10.0, -4.0) && i < 100 && (oldResult = result) != (result = CableRenderer.function2(x0 -= result / (gradient = CableRenderer.derivation2(x0, a, xB, yB, length)), a, xB, yB, length)); ++i) {
        }
        return x0;
    }

    public static float function2(float x0, float a, float xB, float yB, float length) {
        return (float)((double)yB - (double)a * Math.cosh((xB - x0) / a) + (double)a * Math.cosh(-x0 / a));
    }

    public static float derivation2(float x0, float a, float xB, float yB, float length) {
        return (float)(Math.sinh((xB - x0) / a) - Math.sinh(-x0 / a));
    }
}

