/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.packets.client.spawn_projectile_req;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lyon.aom.utils.enums.EnumEntitys;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketSpawnProjectileReq
implements IMessage {
    private EnumEntitys.Projectiles id;
    private UUID playerUUID;
    private Vec3d pos;
    private double shotVel;
    private List<Integer> params;

    public PacketSpawnProjectileReq() {
    }

    public PacketSpawnProjectileReq(EnumEntitys.Projectiles id, UUID playerUUID, Vec3d pos, double shotVel, List<Integer> params) {
        this.id = id;
        this.playerUUID = playerUUID;
        this.pos = pos;
        this.shotVel = shotVel;
        this.params = params;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public Vec3d getPos() {
        return this.pos;
    }

    public double getShotVel() {
        return this.shotVel;
    }

    public List<Integer> getParams() {
        return this.params;
    }

    public EnumEntitys.Projectiles getID() {
        return this.id;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound nbt = ByteBufUtils.readTag((ByteBuf)buf);
        this.id = EnumEntitys.Projectiles.getByID(nbt.func_74762_e("ID"));
        this.playerUUID = nbt.func_186857_a("PlayerUUID");
        this.pos = new Vec3d(nbt.func_74769_h("xPos"), nbt.func_74769_h("yPos"), nbt.func_74769_h("zPos"));
        this.shotVel = nbt.func_74769_h("ShotVel");
        this.params = new ArrayList<Integer>();
        NBTTagList list = nbt.func_150295_c("Params", (int)new NBTTagInt(0).func_74732_a());
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.params.add(list.func_186858_c(i));
        }
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("ID", this.id.getID());
        nbt.func_186854_a("PlayerUUID", this.playerUUID);
        nbt.func_74780_a("xPos", this.pos.field_72450_a);
        nbt.func_74780_a("yPos", this.pos.field_72448_b);
        nbt.func_74780_a("zPos", this.pos.field_72449_c);
        nbt.func_74780_a("ShotVel", this.shotVel);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.params.size(); ++i) {
            list.func_74742_a((NBTBase)new NBTTagInt(this.params.get(i).intValue()));
        }
        nbt.func_74782_a("Params", (NBTBase)list);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbt);
    }
}

