/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.packets.client.sync_config_fields_req;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import scala.Tuple2;

public class PacketSyncConfigFieldsReq
implements IMessage {
    private Map<String, Tuple2<Class, Object>> fieldsToSync;
    private static BiMap<String, Class> classNameMap = HashBiMap.create();

    public PacketSyncConfigFieldsReq() {
    }

    public PacketSyncConfigFieldsReq(Map<String, Tuple2<Class, Object>> fieldsToSync) {
        this.fieldsToSync = fieldsToSync;
    }

    public Map<String, Tuple2<Class, Object>> getFieldsToSync() {
        return this.fieldsToSync;
    }

    public void fromBytes(ByteBuf buf) {
        this.fieldsToSync = new HashMap<String, Tuple2<Class, Object>>();
        NBTTagCompound nbt = ByteBufUtils.readTag((ByteBuf)buf);
        int i = 0;
        while (nbt.func_74764_b(Integer.toString(i))) {
            NBTTagCompound n = nbt.func_74775_l(Integer.toString(i));
            if (n.func_74764_b("Name") && n.func_74764_b("Class") && n.func_74764_b("Value")) {
                Class c = (Class)classNameMap.get((Object)n.func_74779_i("Class"));
                Object o = null;
                if (c == Integer.class) {
                    o = n.func_74762_e("Value");
                } else if (c == Boolean.class) {
                    o = n.func_74767_n("Value");
                } else if (c == Float.class) {
                    o = Float.valueOf(n.func_74760_g("Value"));
                } else if (c == String.class) {
                    o = n.func_74779_i("Value");
                }
                this.fieldsToSync.put(n.func_74779_i("Name"), (Tuple2<Class, Object>)new Tuple2((Object)c, c.cast(o)));
            }
            ++i;
        }
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound nbt = new NBTTagCompound();
        for (int i = 0; i < this.fieldsToSync.size(); ++i) {
            String name = this.fieldsToSync.keySet().toArray(new String[0])[i];
            nbt.func_74782_a(Integer.toString(i), (NBTBase)PacketSyncConfigFieldsReq.writeMapEntryToNBT(name, (Class)this.fieldsToSync.get((Object)name)._1, this.fieldsToSync.get((Object)name)._2));
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbt);
    }

    public static NBTTagCompound writeMapEntryToNBT(String s, Class c, Object o) {
        if (s != null && c != null && o != null && c.isInstance(o)) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("Name", s);
            if (c == Integer.class) {
                nbt.func_74778_a("Class", (String)classNameMap.inverse().get((Object)c));
                nbt.func_74768_a("Value", ((Integer)o).intValue());
            } else if (c == Boolean.class) {
                nbt.func_74778_a("Class", (String)classNameMap.inverse().get((Object)c));
                nbt.func_74757_a("Value", ((Boolean)o).booleanValue());
            } else if (c == Float.class) {
                nbt.func_74778_a("Class", (String)classNameMap.inverse().get((Object)c));
                nbt.func_74776_a("Value", ((Float)o).floatValue());
            } else if (c == String.class) {
                nbt.func_74778_a("Class", (String)classNameMap.inverse().get((Object)c));
                nbt.func_74778_a("Value", (String)o);
            }
            return nbt;
        }
        return null;
    }

    static {
        classNameMap.put((Object)"int", Integer.class);
        classNameMap.put((Object)"bool", Boolean.class);
        classNameMap.put((Object)"float", Float.class);
        classNameMap.put((Object)"string", String.class);
    }
}

