/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.recipes;

import java.util.HashMap;
import java.util.Map;
import lyon.aom.init.ItemInit;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import scala.Tuple5;

public class BlastFurnaceRecipes {
    public static final BlastFurnaceRecipes INSTANCE = new BlastFurnaceRecipes();
    private Map<Item[], Tuple5<Item, Float, Integer, Integer, Integer>> recipes = new HashMap<Item[], Tuple5<Item, Float, Integer, Integer, Integer>>();

    public static BlastFurnaceRecipes getInstance() {
        return INSTANCE;
    }

    public BlastFurnaceRecipes() {
        this.addBlastRecipe(Item.func_150898_a((Block)Blocks.field_150343_Z), Items.field_151042_j, ItemInit.ULTRAHARD_STEEL_INGOT, 1.0f, 900, 1, 1);
        this.addBlastRecipe(Items.field_151045_i, ItemInit.ULTRAHARD_STEEL_INGOT, ItemInit.REINFORCED_DIAMOND, 1.0f, 600, 1, 1);
        this.addBlastRecipe(Item.func_150898_a((Block)Blocks.field_150366_p), Item.func_150898_a((Block)Blocks.field_150350_a), Items.field_151042_j, 1.0f, 400, 1, 2);
        this.addBlastRecipe(Item.func_150898_a((Block)Blocks.field_150350_a), Item.func_150898_a((Block)Blocks.field_150366_p), Items.field_151042_j, 1.0f, 400, 1, 2);
        this.addBlastRecipe(Item.func_150898_a((Block)Blocks.field_150366_p), Item.func_150898_a((Block)Blocks.field_150366_p), Items.field_151042_j, 2.0f, 400, 2, 4);
        this.addBlastRecipe(Item.func_150898_a((Block)Blocks.field_150352_o), Item.func_150898_a((Block)Blocks.field_150350_a), Items.field_151043_k, 1.0f, 400, 1, 2);
        this.addBlastRecipe(Item.func_150898_a((Block)Blocks.field_150350_a), Item.func_150898_a((Block)Blocks.field_150352_o), Items.field_151043_k, 1.0f, 400, 1, 2);
        this.addBlastRecipe(Item.func_150898_a((Block)Blocks.field_150352_o), Item.func_150898_a((Block)Blocks.field_150352_o), Items.field_151043_k, 2.0f, 400, 2, 4);
    }

    public void addBlastRecipe(Item input1, Item input2, Item result, float experience, int cookTime, int minCount, int maxCount) {
        if (input1 != null && input2 != null && result != null && experience >= 0.0f && cookTime >= 0 && minCount >= 0 && maxCount >= 0 && maxCount >= minCount && !this.isRecipeExisting(new ItemStack(input1), new ItemStack(input2))) {
            this.recipes.put(new Item[]{input1, input2}, (Tuple5<Item, Float, Integer, Integer, Integer>)new Tuple5((Object)result, (Object)Float.valueOf(experience), (Object)cookTime, (Object)minCount, (Object)maxCount));
        }
    }

    public boolean isRecipeExisting(ItemStack input1, ItemStack input2) {
        return this.getKey(new Item[]{input1.func_77973_b(), input2.func_77973_b()}) != null;
    }

    public ItemStack getResult(ItemStack input1, ItemStack input2, int spaceLeft) {
        if (this.isRecipeExisting(input1, input2)) {
            Tuple5<Item, Float, Integer, Integer, Integer> recipe = this.recipes.get(this.getKey(new Item[]{input1.func_77973_b(), input2.func_77973_b()}));
            return new ItemStack((Item)recipe._1(), this.getRandomCount((Integer)recipe._4(), (Integer)recipe._5(), spaceLeft));
        }
        return ItemStack.field_190927_a;
    }

    public int getCookTime(ItemStack input1, ItemStack input2) {
        if (this.isRecipeExisting(input1, input2)) {
            Tuple5<Item, Float, Integer, Integer, Integer> recipe = this.recipes.get(this.getKey(new Item[]{input1.func_77973_b(), input2.func_77973_b()}));
            return (Integer)recipe._3();
        }
        return -1;
    }

    public Float getExperience(ItemStack input1, ItemStack input2) {
        if (this.isRecipeExisting(input1, input2)) {
            return (Float)this.recipes.get(this.getKey(new Item[]{input1.func_77973_b(), input2.func_77973_b()}))._2();
        }
        return Float.valueOf(0.0f);
    }

    private int getRandomCount(int min, int max, int left) {
        if (max > left) {
            max = left;
        }
        if (min > max) {
            return 0;
        }
        int diff = max - min;
        int num = (int)Math.round((double)min + Math.random() * (double)diff);
        return num;
    }

    private Item[] getKey(Item[] key) {
        if (key != null && key.length == 2) {
            for (int i = 0; i < this.recipes.keySet().size(); ++i) {
                Item[] array = ((Item[][])this.recipes.keySet().toArray((T[])new Item[0][]))[i];
                if (array.length != 2 || array[0] != key[0] || array[1] != key[1]) continue;
                return array;
            }
        }
        return null;
    }
}

