/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.utils;

import lyon.aom.Main;
import lyon.aom.generator.OreGenerator;
import lyon.aom.gui.GuiHandler;
import lyon.aom.init.BlockInit;
import lyon.aom.init.EntityInit;
import lyon.aom.init.FluidInit;
import lyon.aom.init.ItemInit;
import lyon.aom.init.SoundInit;
import lyon.aom.init.TileEntityInit;
import lyon.aom.packets.PacketHandler;
import lyon.aom.utils.interfaces.IHasModel;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class RegistryHandler {
    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ItemInit.ITEMS.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])BlockInit.BLOCKS.toArray(new Block[0]));
        TileEntityInit.registerTileEntities();
    }

    @SubscribeEvent
    public static void onEntityRegister(RegistryEvent.Register<EntityEntry> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])EntityInit.ENTITY_ENTRYS.toArray(new EntityEntry[0]));
    }

    @SubscribeEvent
    public static void onSoundEventRegister(RegistryEvent.Register<SoundEvent> event) {
        for (SoundEvent e : SoundInit.SOUNDS) {
            event.getRegistry().register((IForgeRegistryEntry)e);
        }
    }

    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        for (Item item : ItemInit.ITEMS) {
            if (!(item instanceof IHasModel)) continue;
            ((IHasModel)item).registerModels();
        }
        for (Block block : BlockInit.BLOCKS) {
            if (!(block instanceof IHasModel)) continue;
            ((IHasModel)block).registerModels();
        }
    }

    public static void preInitRegistries() {
        FluidInit.registerFluids();
        Main.proxy.preInit();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGenerator(), (int)0);
        PacketHandler.init();
        Main.proxy.registerCapabilities();
        Main.proxy.registerHandlers();
    }

    public static void InitRegistries() {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)Main.instance, (IGuiHandler)new GuiHandler());
        Main.proxy.registerKeyBindings();
    }

    public static void postInitRegistries() {
        Main.proxy.postInit();
        Main.proxy.setTEISRs();
    }
}

