/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.utils;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemStackHandler;
import scala.Tuple2;

public class WrapperItemStackHandler
extends ItemStackHandler {
    protected ItemStackHandler handler;
    private Map<Integer, Tuple2<List<Item>, Boolean>> slots = Maps.newHashMap();

    public WrapperItemStackHandler(ItemStackHandler handler) {
        super(WrapperItemStackHandler.getStackList(handler));
        this.handler = handler;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.canTakeStack(slot)) {
            return ItemStack.field_190927_a;
        }
        return this.handler.extractItem(slot, amount, simulate);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.canPutStack(slot, stack)) {
            return stack;
        }
        return this.handler.insertItem(slot, stack, simulate);
    }

    public void addSlot(int index, Item[] acceptedItems, boolean canTakeOut) {
        if (this.handler != null && index >= 0 && index <= this.handler.getSlots() - 1) {
            ArrayList list = acceptedItems != null ? Arrays.asList(acceptedItems) : new ArrayList();
            this.slots.put(index, (Tuple2<List<Item>, Boolean>)new Tuple2(list, (Object)canTakeOut));
        }
    }

    public boolean canPutStack(int index, ItemStack stack) {
        Tuple2<List<Item>, Boolean> t = this.slots.get(index);
        if (t != null && t._1 != null && !((List)t._1).isEmpty()) {
            return ((List)t._1).contains(stack.func_77973_b());
        }
        return false;
    }

    public boolean canTakeStack(int index) {
        Tuple2<List<Item>, Boolean> t = this.slots.get(index);
        if (t != null) {
            return (Boolean)t._2;
        }
        return false;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.canPutStack(slot, stack);
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.handler.deserializeNBT(nbt);
    }

    public boolean equals(Object obj) {
        return this.handler.equals(obj);
    }

    public int getSlotLimit(int slot) {
        return this.handler.getSlotLimit(slot);
    }

    public int getSlots() {
        return this.handler.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.handler.getStackInSlot(slot);
    }

    public int hashCode() {
        return this.handler.hashCode();
    }

    public NBTTagCompound serializeNBT() {
        return this.handler.serializeNBT();
    }

    public void setSize(int size) {
        this.handler.setSize(size);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.handler.setStackInSlot(slot, stack);
    }

    public String toString() {
        return this.handler.toString();
    }

    private static NonNullList<ItemStack> getStackList(ItemStackHandler handler) {
        NonNullList list = NonNullList.func_191196_a();
        for (int i = 0; i < handler.getSlots(); ++i) {
            list.add((Object)handler.getStackInSlot(i));
        }
        return list;
    }
}

