/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.utils.handlers;

import java.util.Stack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import scala.Tuple2;

public class QueuedTaskHandler {
    private Stack<Tuple2<Side, Runnable>> stack1 = new Stack();
    private Stack<Tuple2<Side, Runnable>> stack2 = new Stack();
    private boolean isExecuting1 = false;
    private boolean isExecuting2 = false;

    public void addTaskToQueue(Side s, Runnable r) {
        if (r != null) {
            if (!this.isExecuting1) {
                this.stack1.add((Tuple2<Side, Runnable>)new Tuple2((Object)s, (Object)r));
            } else if (!this.isExecuting2) {
                this.stack2.add((Tuple2<Side, Runnable>)new Tuple2((Object)s, (Object)r));
            }
        }
    }

    @SubscribeEvent
    public void executeQueuedRunnables(TickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Side side = null;
            if (event.type == TickEvent.Type.CLIENT) {
                side = Side.CLIENT;
            } else if (event.type == TickEvent.Type.SERVER) {
                side = Side.SERVER;
            }
            if (side != null) {
                int i;
                if (!this.isExecuting1) {
                    this.isExecuting1 = true;
                    for (i = 0; i < this.stack1.size(); ++i) {
                        if (((Tuple2)this.stack1.get((int)i))._1 != side) continue;
                        ((Runnable)((Tuple2)this.stack1.get((int)i))._2).run();
                    }
                    this.removeAllForSide(this.stack1, side);
                    this.isExecuting1 = false;
                }
                if (!this.isExecuting2) {
                    this.isExecuting2 = true;
                    for (i = 0; i < this.stack2.size(); ++i) {
                        if (((Tuple2)this.stack2.get((int)i))._1 != side) continue;
                        ((Runnable)((Tuple2)this.stack2.get((int)i))._2).run();
                    }
                    this.removeAllForSide(this.stack2, side);
                    this.isExecuting2 = false;
                }
            }
        }
    }

    private void removeAllForSide(Stack<Tuple2<Side, Runnable>> stack, Side side) {
        for (int i = 0; i < stack.size(); ++i) {
            if (((Tuple2)stack.get((int)i))._1 != side) continue;
            stack.remove(i);
            --i;
        }
    }
}

