/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.utils.render;

import lyon.aom.blocks.gas_tank.BlockGasTank;
import lyon.aom.init.BlockInit;
import lyon.aom.init.ItemInit;
import lyon.aom.utils.AOMConfig;
import lyon.aom.utils.render.CustomItemRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderHandHandler {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderHand(RenderSpecificHandEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (AOMConfig.useSpecialRender) {
            boolean flag = event.getHand() == EnumHand.MAIN_HAND;
            EnumHandSide enumHandside = flag ? Minecraft.func_71410_x().field_71439_g.func_184591_cq() : Minecraft.func_71410_x().field_71439_g.func_184591_cq().func_188468_a();
            GlStateManager.func_179094_E();
            if (event.getItemStack().func_77973_b() == ItemInit.GAS_CARTRIDGE) {
                this.renderGasCartridge(event, enumHandside);
            }
            GlStateManager.func_179121_F();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderGasCartridge(RenderSpecificHandEvent event, EnumHandSide enumHandSide) {
        if (event.getHand() == EnumHand.MAIN_HAND && Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d() && Minecraft.func_71410_x().field_71476_x != null && Minecraft.func_71410_x().field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK && (Minecraft.func_71410_x().field_71439_g.field_70170_p.func_180495_p(Minecraft.func_71410_x().field_71476_x.func_178782_a()).func_177230_c() == BlockInit.GAS_TANK || ((BlockGasTank)BlockInit.GAS_TANK).belongsBlockToMultiBlockStructure((IBlockAccess)Minecraft.func_71410_x().field_71439_g.field_70170_p, Minecraft.func_71410_x().field_71439_g.field_70170_p.func_180495_p(Minecraft.func_71410_x().field_71476_x.func_178782_a()), Minecraft.func_71410_x().field_71476_x.func_178782_a())) && Minecraft.func_71410_x().func_175597_ag() instanceof CustomItemRenderer) {
            boolean flag1 = enumHandSide == EnumHandSide.RIGHT;
            event.setCanceled(true);
            RenderHandHandler.transformDefault(event, enumHandSide);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.2f);
            GlStateManager.func_179114_b((float)-30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            Minecraft.func_71410_x().func_175597_ag().func_187462_a((EntityLivingBase)Minecraft.func_71410_x().field_71439_g, event.getItemStack(), flag1 ? ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, !flag1);
        }
    }

    public static void transformDefault(RenderSpecificHandEvent event, EnumHandSide enumHandSide) {
        boolean flag1 = enumHandSide == EnumHandSide.RIGHT;
        float interpolatedEquippingProgress = ((CustomItemRenderer)Minecraft.func_71410_x().func_175597_ag()).getInterpolatedEquippingProgress(event.getHand(), event.getPartialTicks());
        float swingProgress = Minecraft.func_71410_x().field_71439_g.field_184622_au == event.getHand() ? Minecraft.func_71410_x().field_71439_g.func_70678_g(event.getPartialTicks()) : 0.0f;
        float f = -0.4f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI));
        float f1 = 0.2f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * ((float)Math.PI * 2)));
        float f2 = -0.2f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        int i = flag1 ? 1 : -1;
        GlStateManager.func_179109_b((float)((float)i * f), (float)f1, (float)f2);
        RenderHandHandler.transformSideFirstPerson(enumHandSide, interpolatedEquippingProgress);
        RenderHandHandler.transformFirstPerson(enumHandSide, swingProgress);
    }

    public static void transformSideFirstPerson(EnumHandSide hand, float interpolatedEquippingProgress) {
        int i = hand == EnumHandSide.RIGHT ? 1 : -1;
        GlStateManager.func_179109_b((float)((float)i * 0.56f), (float)(-0.52f + interpolatedEquippingProgress * -0.6f), (float)-0.72f);
    }

    public static void transformFirstPerson(EnumHandSide hand, float swingProgress) {
        int i = hand == EnumHandSide.RIGHT ? 1 : -1;
        float f = MathHelper.func_76126_a((float)(swingProgress * swingProgress * (float)Math.PI));
        GlStateManager.func_179114_b((float)((float)i * (45.0f + f * -20.0f)), (float)0.0f, (float)1.0f, (float)0.0f);
        float f1 = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI));
        GlStateManager.func_179114_b((float)((float)i * f1 * -20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)(f1 * -80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)i * -45.0f), (float)0.0f, (float)1.0f, (float)0.0f);
    }
}

