/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.utils.render;

import lyon.aom.accessory.RenderAccessoryHandler;
import lyon.aom.utils.AOMConfig;
import lyon.aom.utils.Utils;
import lyon.aom.utils.render.RenderArmorHandler;
import lyon.aom.utils.render.RenderItemHandler;
import lyon.aom.utils.render.RenderReflectionHandler;
import lyon.aom.utils.render.RenderRidingHandler;
import lyon.aom.utils.render.RenderSpecialEquipmentHandler;
import lyon.aom.utils.render.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RenderPlayerHandler {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPrePlayerRender(RenderPlayerEvent.Pre event) {
        if (AOMConfig.useSpecialRender) {
            if (event != null && event.getEntity() != null && event.getEntity() instanceof EntityPlayer) {
                RenderReflectionHandler.replaceLayers((EntityPlayer)event.getEntity());
            }
            RenderItemHandler.cancelRender(event);
            RenderRidingHandler.cancelRender(event);
            this.cancelRenderSecondLayer(event);
            RenderArmorHandler.cancelRender(event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPostPlayerRender(RenderPlayerEvent.Post event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            GlStateManager.func_179094_E();
            RenderUtils.preRender((EntityLivingBase)player, (RenderLivingBase)event.getRenderer(), event.getPartialRenderTick(), 0.0625f);
            if (AOMConfig.useSpecialRender) {
                RenderRidingHandler.applyValues(event);
                RenderItemHandler.applyValues(event);
                RenderArmorHandler.applyValues(event);
                this.applyValuesSecondLayer(event);
            }
            this.render(event);
            RenderUtils.postRender((EntityLivingBase)player, (RenderLivingBase)event.getRenderer(), event.getPartialRenderTick(), 0.0625f);
            GlStateManager.func_179121_F();
            if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71439_g != null) {
                GlStateManager.func_179094_E();
                if (!Minecraft.func_71410_x().field_71439_g.equals((Object)player)) {
                    RenderUtils.translateToEntity((Entity)Minecraft.func_71410_x().field_71439_g, (Entity)player, event.getPartialRenderTick());
                }
                GlStateManager.func_179121_F();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onLastWorldRender(RenderWorldLastEvent event) {
        if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71439_g != null) {
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                GlStateManager.func_179094_E();
                RenderSpecialEquipmentHandler.renderExtra((EntityPlayer)Minecraft.func_71410_x().field_71439_g, event.getPartialTicks());
                GlStateManager.func_179121_F();
            }
            if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71441_e.field_73010_i != null) {
                for (int i = 0; i < Minecraft.func_71410_x().field_71441_e.field_73010_i.size(); ++i) {
                    if (Minecraft.func_71410_x().field_71441_e.field_73010_i.get(i) == Minecraft.func_71410_x().field_71439_g && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) continue;
                    GlStateManager.func_179094_E();
                    RenderUtils.translateToEntity((Entity)Minecraft.func_71410_x().field_71439_g, (Entity)Minecraft.func_71410_x().field_71441_e.field_73010_i.get(i), event.getPartialTicks());
                    RenderSpecialEquipmentHandler.renderExtra((EntityPlayer)Minecraft.func_71410_x().field_71441_e.field_73010_i.get(i), event.getPartialTicks());
                    GlStateManager.func_179121_F();
                }
            }
        }
    }

    private void render(RenderPlayerEvent.Post event) {
        EntityPlayer player = (EntityPlayer)event.getEntity();
        if (player.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2133f, (float)0.0f);
        }
        if (AOMConfig.useSpecialRender) {
            boolean flag1;
            boolean flag = !player.func_82150_aj();
            boolean bl = flag1 = !flag && !player.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            if (flag || flag1) {
                if (!RenderUtils.bindEntityTexture((Entity)player, (Render)event.getRenderer(), event.getRenderer().func_110775_a((AbstractClientPlayer)player))) {
                    return;
                }
                if (flag1) {
                    GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
                }
                RenderRidingHandler.render(event);
                this.renderSecondLayer(event);
                RenderItemHandler.render(event);
                if (flag1) {
                    GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
                }
            }
            RenderArmorHandler.render(event);
        }
        RenderSpecialEquipmentHandler.render(event);
        RenderAccessoryHandler.render(event);
    }

    public void cancelRenderSecondLayer(RenderPlayerEvent.Pre event) {
        EntityPlayer player = (EntityPlayer)event.getEntity();
        ModelPlayer model = event.getRenderer().func_177087_b();
        if (model.field_78116_c.field_78807_k) {
            model.field_178720_f.field_78807_k = true;
        }
        if (model.field_78115_e.field_78807_k) {
            model.field_178730_v.field_78807_k = true;
        }
        if (model.field_178724_i.field_78807_k) {
            model.field_178734_a.field_78807_k = true;
        }
        if (model.field_178723_h.field_78807_k) {
            model.field_178732_b.field_78807_k = true;
        }
        if (model.field_178722_k.field_78807_k) {
            model.field_178733_c.field_78807_k = true;
        }
        if (model.field_178721_j.field_78807_k) {
            model.field_178731_d.field_78807_k = true;
        }
    }

    public void applyValuesSecondLayer(RenderPlayerEvent.Post event) {
        EntityPlayer player = (EntityPlayer)event.getEntity();
        ModelPlayer model = event.getRenderer().func_177087_b();
        Utils.copyRotationsToSecondLayer(model);
    }

    public void renderSecondLayer(RenderPlayerEvent.Post event) {
        EntityPlayer player = (EntityPlayer)event.getEntity();
        ModelPlayer model = event.getRenderer().func_177087_b();
        if (model.field_178720_f.field_78807_k) {
            this.renderModelRenderer(model.field_178720_f);
        }
        if (model.field_178730_v.field_78807_k) {
            this.renderModelRenderer(model.field_178730_v);
        }
        if (model.field_178734_a.field_78807_k) {
            this.renderModelRenderer(model.field_178734_a);
        }
        if (model.field_178732_b.field_78807_k) {
            this.renderModelRenderer(model.field_178732_b);
        }
        if (model.field_178733_c.field_78807_k) {
            this.renderModelRenderer(model.field_178733_c);
        }
        if (model.field_178731_d.field_78807_k) {
            this.renderModelRenderer(model.field_178731_d);
        }
    }

    public void renderModelRenderer(ModelRenderer renderer) {
        renderer.field_78807_k = false;
        renderer.func_78785_a(0.0625f);
    }
}

