/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.utils.render;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import lyon.aom.utils.Utils;
import lyon.aom.utils.render.CustomItemRenderer;
import lyon.aom.utils.render.SpecialLayerBipedArmor;
import lyon.aom.utils.render.SpecialLayerHeldItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerArrow;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerCape;
import net.minecraft.client.renderer.entity.layers.LayerCustomHead;
import net.minecraft.client.renderer.entity.layers.LayerDeadmau5Head;
import net.minecraft.client.renderer.entity.layers.LayerElytra;
import net.minecraft.client.renderer.entity.layers.LayerEntityOnShoulder;
import net.minecraft.client.renderer.entity.layers.LayerHeldItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import scala.Tuple2;

@SideOnly(value=Side.CLIENT)
public class RenderReflectionHandler {
    private static Map<Render, Tuple2<SpecialLayerHeldItem, SpecialLayerBipedArmor>> map = new HashMap<Render, Tuple2<SpecialLayerHeldItem, SpecialLayerBipedArmor>>();

    public static void replaceLayers(EntityPlayer player) {
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        if (renderManager.func_78713_a((Entity)player) instanceof RenderLivingBase) {
            RenderReflectionHandler.replaceLayers((RenderLivingBase)renderManager.func_78713_a((Entity)player));
        }
    }

    public static void replaceLayers(RenderLivingBase render) {
        if (!map.containsKey(render)) {
            SpecialLayerHeldItem itemLayer = new SpecialLayerHeldItem(render);
            SpecialLayerBipedArmor armorLayer = new SpecialLayerBipedArmor(render);
            RenderReflectionHandler.addSpecialLayerRender(render, itemLayer, armorLayer);
            map.put((Render)render, (Tuple2<SpecialLayerHeldItem, SpecialLayerBipedArmor>)new Tuple2((Object)itemLayer, (Object)armorLayer));
        }
    }

    public static void resetLayers(RenderLivingBase render) {
        if (map.containsKey(render)) {
            RenderReflectionHandler.removeSpecialLayerRender(render);
            map.remove(render);
        }
    }

    public static SpecialLayerHeldItem getSpecialLayerHeldItem(EntityPlayer player) {
        RenderLivingBase render;
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        if (renderManager.func_78713_a((Entity)player) instanceof RenderLivingBase && map.containsKey(render = (RenderLivingBase)renderManager.func_78713_a((Entity)player))) {
            return (SpecialLayerHeldItem)RenderReflectionHandler.map.get((Object)render)._1;
        }
        return null;
    }

    public static SpecialLayerBipedArmor getSpecialLayerBipedArmor(EntityPlayer player) {
        RenderLivingBase render;
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        if (renderManager.func_78713_a((Entity)player) instanceof RenderLivingBase && map.containsKey(render = (RenderLivingBase)renderManager.func_78713_a((Entity)player))) {
            return (SpecialLayerBipedArmor)((Object)RenderReflectionHandler.map.get((Object)render)._2);
        }
        return null;
    }

    public static void addSpecialLayerRender(RenderLivingBase render, SpecialLayerHeldItem itemLayer, SpecialLayerBipedArmor armorLayer) {
        try {
            Class<RenderPlayer> c = RenderPlayer.class;
            Field f = RenderReflectionHandler.getField(c, new String[]{"layerRenderers", "field_177097_h"});
            Method m = RenderReflectionHandler.getMethod(c, new String[]{"addLayer", "func_177094_a"});
            f.setAccessible(true);
            f.set(render, Lists.newArrayList());
            m.invoke((Object)render, new Object[]{armorLayer});
            m.invoke((Object)render, new LayerArrow(render));
            m.invoke((Object)render, new LayerElytra(render));
            m.invoke((Object)render, new LayerEntityOnShoulder(render.func_177068_d()));
            m.invoke((Object)render, itemLayer);
            if (render instanceof RenderPlayer) {
                m.invoke((Object)render, new LayerDeadmau5Head((RenderPlayer)render));
                m.invoke((Object)render, new LayerCape((RenderPlayer)render));
                m.invoke((Object)render, new LayerCustomHead(((RenderPlayer)render).func_177087_b().field_78116_c));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeSpecialLayerRender(RenderLivingBase render) {
        try {
            Class<RenderPlayer> c = RenderPlayer.class;
            Field f = RenderReflectionHandler.getField(c, new String[]{"layerRenderers", "field_177097_h"});
            Method m = RenderReflectionHandler.getMethod(c, new String[]{"addLayer", "func_177094_a"});
            f.setAccessible(true);
            f.set(render, Lists.newArrayList());
            m.invoke((Object)render, new LayerBipedArmor(render));
            m.invoke((Object)render, new LayerArrow(render));
            m.invoke((Object)render, new LayerElytra(render));
            m.invoke((Object)render, new LayerEntityOnShoulder(render.func_177068_d()));
            m.invoke((Object)render, new LayerHeldItem(render));
            if (render instanceof RenderPlayer) {
                m.invoke((Object)render, new LayerDeadmau5Head((RenderPlayer)render));
                m.invoke((Object)render, new LayerCape((RenderPlayer)render));
                m.invoke((Object)render, new LayerCustomHead(((RenderPlayer)render).func_177087_b().field_78116_c));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void overrideItemRendererInit() {
        try {
            CustomItemRenderer custom = new CustomItemRenderer(Minecraft.func_71410_x());
            Field field1 = RenderReflectionHandler.getField(Minecraft.class, new String[]{"itemRenderer", "field_175620_Y"});
            field1.setAccessible(true);
            field1.set(Minecraft.func_71410_x(), (Object)custom);
            Field field2 = RenderReflectionHandler.getField(EntityRenderer.class, new String[]{"itemRenderer", "field_78516_c"});
            field2.setAccessible(true);
            field2.set(Minecraft.func_71410_x().field_71460_t, (Object)custom);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Field getField(Class clazz, String[] fieldNames) throws Exception {
        try {
            return ReflectionHelper.findField((Class)clazz, (String[])fieldNames);
        }
        catch (Exception e) {
            Class superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return RenderReflectionHandler.getField(superClass, fieldNames);
        }
    }

    public static Method getMethod(Class clazz, String[] methodNames) throws Exception {
        try {
            Method[] m = clazz.getDeclaredMethods();
            for (int i = 0; i < m.length; ++i) {
                if (!Utils.contains(methodNames, m[i].getName())) continue;
                return m[i];
            }
            throw new NoSuchFieldException();
        }
        catch (Exception e) {
            Class superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return RenderReflectionHandler.getMethod(superClass, methodNames);
        }
    }
}

