/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.utils.render;

import lyon.aom.entity.cannon.EntityCannon;
import lyon.aom.entity.mobile_cannon.EntityMobileCannon;
import lyon.aom.utils.Utils;
import lyon.aom.utils.render.RenderReflectionHandler;
import lyon.aom.utils.render.SpecialLayerBipedArmor;
import lyon.aom.utils.render.SpecialLayerHeldItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RenderRidingHandler {
    private static final Class[] specialEntitys = new Class[]{EntityCannon.class, EntityMobileCannon.class};

    @SideOnly(value=Side.CLIENT)
    public static void cancelRender(RenderPlayerEvent.Pre event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            SpecialLayerHeldItem itemLayer = RenderReflectionHandler.getSpecialLayerHeldItem(player);
            SpecialLayerBipedArmor armorLayer = RenderReflectionHandler.getSpecialLayerBipedArmor(player);
            if (itemLayer != null && player.func_184218_aH() && Utils.contains(specialEntitys, player.func_184187_bx().getClass())) {
                armorLayer.shouldRender(false);
                if (player.func_184187_bx() instanceof EntityCannon) {
                    RenderRidingHandler.cancelEntityCannonRidingRender(event.getRenderer().func_177087_b(), player);
                } else if (player.func_184187_bx() instanceof EntityMobileCannon) {
                    RenderRidingHandler.cancelEntityCannonRidingRender(event.getRenderer().func_177087_b(), player);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void applyValues(RenderPlayerEvent.Post event) {
        if (event.getEntity() instanceof EntityPlayer) {
            // empty if block
        }
        EntityPlayer playerR = (EntityPlayer)event.getEntity();
        EntityPlayerSP playerC = Minecraft.func_71410_x().field_71439_g;
        SpecialLayerHeldItem itemLayer = RenderReflectionHandler.getSpecialLayerHeldItem(playerR);
        if (itemLayer != null && playerR.func_184218_aH() && Utils.contains(specialEntitys, playerR.func_184187_bx().getClass())) {
            if (playerR.func_184187_bx() instanceof EntityCannon) {
                RenderRidingHandler.applyValuesEntityCannonRiding(event.getRenderer().func_177087_b(), event.getRenderer(), playerR, (EntityCannon)playerR.func_184187_bx(), event.getPartialRenderTick());
            } else if (playerR.func_184187_bx() instanceof EntityMobileCannon) {
                RenderRidingHandler.applyValuesEntityMobileCannonRiding(event.getRenderer().func_177087_b(), event.getRenderer(), playerR, (EntityMobileCannon)playerR.func_184187_bx(), event.getPartialRenderTick());
            }
        }
    }

    public static void render(RenderPlayerEvent.Post event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer playerR = (EntityPlayer)event.getEntity();
            EntityPlayerSP playerC = Minecraft.func_71410_x().field_71439_g;
            SpecialLayerHeldItem itemLayer = RenderReflectionHandler.getSpecialLayerHeldItem(playerR);
            if (itemLayer != null && playerR.func_184218_aH() && Utils.contains(specialEntitys, playerR.func_184187_bx().getClass())) {
                if (playerR.func_184187_bx() instanceof EntityCannon) {
                    RenderRidingHandler.renderEntityCannonRiding(event.getRenderer().func_177087_b(), event.getRenderer(), playerR, event.getPartialRenderTick());
                } else if (playerR.func_184187_bx() instanceof EntityMobileCannon) {
                    RenderRidingHandler.renderEntityCannonRiding(event.getRenderer().func_177087_b(), event.getRenderer(), playerR, event.getPartialRenderTick());
                }
            }
        }
    }

    public static void cancelEntityCannonRidingRender(ModelPlayer model, EntityPlayer player) {
        SpecialLayerHeldItem itemLayer = RenderReflectionHandler.getSpecialLayerHeldItem(player);
        model.field_78115_e.field_78807_k = true;
        model.field_178721_j.field_78807_k = true;
        model.field_178722_k.field_78807_k = true;
        model.field_178723_h.field_78807_k = true;
        model.field_178724_i.field_78807_k = true;
        itemLayer.shouldRenderRightItem(false);
        itemLayer.shouldRenderLeftItem(false);
    }

    public static void applyValuesEntityCannonRiding(ModelPlayer model, RenderPlayer renderPlayer, EntityPlayer player, EntityCannon cannon, float partialTicks) {
        SpecialLayerHeldItem itemLayer = RenderReflectionHandler.getSpecialLayerHeldItem(player);
        float interpolatedVelFactor = Utils.interpolate(cannon.velFactor, cannon.prevVelFactor, partialTicks);
        player.field_70760_ar -= (float)(-Utils.modulo(cannon.field_70126_B - player.field_70760_ar, 360.0));
        player.field_70761_aq -= (float)(-Utils.modulo(cannon.field_70177_z - player.field_70761_aq, 360.0));
        model.field_178723_h.field_78795_f = (float)Math.toRadians(-45.0);
        model.field_178723_h.field_78795_f += MathHelper.func_76126_a((float)(((float)player.field_70173_aa + partialTicks) * 0.067f)) * 0.05f;
        model.field_178723_h.field_78808_h += MathHelper.func_76134_b((float)(((float)player.field_70173_aa + partialTicks) * 0.09f)) * 0.05f + 0.05f;
        model.field_178724_i.field_78795_f = (float)Math.toRadians(-45.0);
        model.field_178724_i.field_78795_f -= MathHelper.func_76126_a((float)(((float)player.field_70173_aa + partialTicks) * 0.067f)) * 0.05f;
        model.field_178724_i.field_78808_h -= MathHelper.func_76134_b((float)(((float)player.field_70173_aa + partialTicks) * 0.09f)) * 0.05f + 0.05f;
        model.field_178721_j.field_78795_f = (float)Math.toRadians(0.0);
        model.field_178721_j.field_78796_g = (float)Math.toRadians(0.0);
        model.field_178721_j.field_78808_h = (float)Math.toRadians((Math.sin(((float)player.field_70173_aa + partialTicks) * 0.4f) + 1.0) * 15.0) * interpolatedVelFactor;
        model.field_178722_k.field_78795_f = (float)Math.toRadians(0.0);
        model.field_178722_k.field_78796_g = (float)Math.toRadians(0.0);
        model.field_178722_k.field_78808_h = (float)(-Math.toRadians((Math.sin(((float)player.field_70173_aa + partialTicks) * 0.4f) + 1.0) * 15.0)) * interpolatedVelFactor;
    }

    public static void applyValuesEntityMobileCannonRiding(ModelPlayer model, RenderPlayer renderPlayer, EntityPlayer player, EntityMobileCannon cannon, float partialTicks) {
        SpecialLayerHeldItem itemLayer = RenderReflectionHandler.getSpecialLayerHeldItem(player);
        float interpolatedVelFactor = Utils.interpolate(cannon.velFactor, cannon.prevVelFactor, partialTicks);
        player.field_70760_ar -= (float)(-Utils.modulo(cannon.field_70126_B - player.field_70760_ar, 360.0));
        player.field_70761_aq -= (float)(-Utils.modulo(cannon.field_70177_z - player.field_70761_aq, 360.0));
        model.field_178723_h.field_78795_f = (float)Math.toRadians(-45.0);
        model.field_178723_h.field_78795_f += MathHelper.func_76126_a((float)(((float)player.field_70173_aa + partialTicks) * 0.067f)) * 0.05f;
        model.field_178723_h.field_78808_h += MathHelper.func_76134_b((float)(((float)player.field_70173_aa + partialTicks) * 0.09f)) * 0.05f + 0.05f;
        model.field_178724_i.field_78795_f = (float)Math.toRadians(-45.0);
        model.field_178724_i.field_78795_f -= MathHelper.func_76126_a((float)(((float)player.field_70173_aa + partialTicks) * 0.067f)) * 0.05f;
        model.field_178724_i.field_78808_h -= MathHelper.func_76134_b((float)(((float)player.field_70173_aa + partialTicks) * 0.09f)) * 0.05f + 0.05f;
        if (cannon.isMoving) {
            model.field_178721_j.field_78795_f = (float)Math.toRadians(Math.sin(((float)player.field_70173_aa + partialTicks) * 0.25f) * 12.0) * interpolatedVelFactor;
            model.field_178721_j.field_78796_g = (float)(-Math.toRadians(0.0));
            model.field_178721_j.field_78808_h = (float)Math.toRadians(0.0);
        } else {
            model.field_178721_j.field_78795_f = (float)Math.toRadians(0.0);
            model.field_178721_j.field_78796_g = (float)(-Math.toRadians(0.0));
            model.field_178721_j.field_78808_h = (float)Math.toRadians((Math.sin(((float)player.field_70173_aa + partialTicks) * 0.4f) + 1.0) * 15.0) * interpolatedVelFactor;
        }
        if (cannon.isMoving) {
            model.field_178722_k.field_78795_f = (float)(-Math.toRadians(Math.sin(((float)player.field_70173_aa + partialTicks) * 0.25f) * 12.0)) * interpolatedVelFactor;
            model.field_178722_k.field_78796_g = (float)(-Math.toRadians(0.0));
            model.field_178722_k.field_78808_h = (float)Math.toRadians(0.0);
        } else {
            model.field_178722_k.field_78795_f = (float)Math.toRadians(0.0);
            model.field_178722_k.field_78796_g = (float)(-Math.toRadians(0.0));
            model.field_178722_k.field_78808_h = (float)(-Math.toRadians((Math.sin(((float)player.field_70173_aa + partialTicks) * 0.4f) + 1.0) * 15.0)) * interpolatedVelFactor;
        }
    }

    public static void renderEntityCannonRiding(ModelPlayer model, RenderPlayer renderPlayer, EntityPlayer player, float partialTicks) {
        model.field_78115_e.field_78807_k = false;
        model.field_178721_j.field_78807_k = false;
        model.field_178722_k.field_78807_k = false;
        renderPlayer.func_110776_a(renderPlayer.func_110775_a((AbstractClientPlayer)player));
        model.field_78115_e.func_78785_a(0.0625f);
        model.field_178721_j.func_78785_a(0.0625f);
        model.field_178722_k.func_78785_a(0.0625f);
    }

    public static boolean isSpecialRindingEntity(Entity entity) {
        return Utils.contains(specialEntitys, entity);
    }
}

