/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.blocks.base_blocks;

import java.util.ArrayList;
import java.util.List;
import lyon.aom.Main;
import lyon.aom.blocks.base_blocks.BlockFakeBlock;
import lyon.aom.init.BlockInit;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import scala.Tuple2;

public class BlockMultiBlockStructure
extends Block {
    private final List<BlockFakeBlock> fakeBlocks = new ArrayList<BlockFakeBlock>();
    private final List<Tuple2<IBlockState, BlockPos>> fakeBlocksPositions = new ArrayList<Tuple2<IBlockState, BlockPos>>();

    public BlockMultiBlockStructure(String name, Material material) {
        super(material);
        this.func_149663_c(name);
        this.setRegistryName("aom", name);
        this.func_149647_a(Main.AOMTAB);
    }

    protected void addFakeBlockToBeRegistered(BlockFakeBlock block) {
        if (block != null) {
            BlockInit.BLOCKS.add(block);
            this.fakeBlocks.add(block);
        }
    }

    protected void addBlockToMultiBlockStructure(IBlockState state, BlockPos pos) {
        if (state != null && pos != null) {
            this.fakeBlocksPositions.add((Tuple2<IBlockState, BlockPos>)new Tuple2((Object)state, (Object)pos));
        }
    }

    protected void addBlockToMultiBlockStructure(Block block, BlockPos pos) {
        if (block != null && pos != null) {
            this.fakeBlocksPositions.add((Tuple2<IBlockState, BlockPos>)new Tuple2((Object)block.func_176223_P(), (Object)pos));
        }
    }

    protected BlockFakeBlock getFakeBlockFromClass(Class<? extends BlockFakeBlock> clazz) {
        if (this.fakeBlocks != null && !this.fakeBlocks.isEmpty()) {
            for (BlockFakeBlock b : this.fakeBlocks) {
                if (((Object)((Object)b)).getClass() != clazz) continue;
                return b;
            }
        }
        return null;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        if (this.fakeBlocks != null && !this.fakeBlocks.isEmpty()) {
            if (worldIn.func_180495_p(pos).func_177230_c() != Blocks.field_150350_a || worldIn.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j || worldIn.func_180495_p(pos).func_177230_c() == Blocks.field_150358_i || worldIn.func_180495_p(pos).func_177230_c() == Blocks.field_150353_l || worldIn.func_180495_p(pos).func_177230_c() == Blocks.field_150356_k) {
                return false;
            }
            for (Tuple2<IBlockState, BlockPos> tuple : this.fakeBlocksPositions) {
                if (worldIn.func_180495_p(pos.func_177982_a(((BlockPos)tuple._2).func_177958_n(), ((BlockPos)tuple._2).func_177956_o(), ((BlockPos)tuple._2).func_177952_p())).func_177230_c() == Blocks.field_150350_a && worldIn.func_180495_p(pos.func_177982_a(((BlockPos)tuple._2).func_177958_n(), ((BlockPos)tuple._2).func_177956_o(), ((BlockPos)tuple._2).func_177952_p())).func_177230_c() != Blocks.field_150355_j && worldIn.func_180495_p(pos.func_177982_a(((BlockPos)tuple._2).func_177958_n(), ((BlockPos)tuple._2).func_177956_o(), ((BlockPos)tuple._2).func_177952_p())).func_177230_c() != Blocks.field_150358_i && worldIn.func_180495_p(pos.func_177982_a(((BlockPos)tuple._2).func_177958_n(), ((BlockPos)tuple._2).func_177956_o(), ((BlockPos)tuple._2).func_177952_p())).func_177230_c() != Blocks.field_150353_l && worldIn.func_180495_p(pos.func_177982_a(((BlockPos)tuple._2).func_177958_n(), ((BlockPos)tuple._2).func_177956_o(), ((BlockPos)tuple._2).func_177952_p())).func_177230_c() != Blocks.field_150356_k) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (this.fakeBlocksPositions != null && !this.fakeBlocksPositions.isEmpty()) {
            for (Tuple2<IBlockState, BlockPos> tuple : this.fakeBlocksPositions) {
                worldIn.func_175656_a(pos.func_177982_a(((BlockPos)tuple._2).func_177958_n(), ((BlockPos)tuple._2).func_177956_o(), ((BlockPos)tuple._2).func_177952_p()), (IBlockState)tuple._1);
            }
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (this.fakeBlocksPositions != null && !this.fakeBlocksPositions.isEmpty()) {
            for (Tuple2<IBlockState, BlockPos> tuple : this.fakeBlocksPositions) {
                worldIn.func_175656_a(pos.func_177982_a(((BlockPos)tuple._2).func_177958_n(), ((BlockPos)tuple._2).func_177956_o(), ((BlockPos)tuple._2).func_177952_p()), (IBlockState)tuple._1);
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K && this.belongsBlockToMultiBlockStructure((IBlockAccess)worldIn, state, pos)) {
            BlockPos offset = this.getOffsetFromMultiStructureBlock((IBlockAccess)worldIn, state, pos);
            return this.onMultiBlockStructureActivated(worldIn, pos.func_177982_a(-offset.func_177958_n(), -offset.func_177956_o(), -offset.func_177952_p()), worldIn.func_180495_p(pos.func_177982_a(-offset.func_177958_n(), -offset.func_177956_o(), -offset.func_177952_p())), playerIn, hand, facing, hitX, hitY, hitZ);
        }
        return false;
    }

    public boolean onMultiBlockStructureActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (worldIn.func_180495_p(pos).func_177230_c() != this && this.belongsBlockToMultiBlockStructure((IBlockAccess)worldIn, state, pos)) {
            BlockPos offset = this.getOffsetFromMultiStructureBlock((IBlockAccess)worldIn, state, pos);
            pos = pos.func_177982_a(-offset.func_177958_n(), -offset.func_177956_o(), -offset.func_177952_p());
            state = worldIn.func_180495_p(pos);
        }
        this.onMultiBlockStructureHarvested(worldIn, pos, state, player);
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        if (this.belongsBlockToMultiBlockStructure((IBlockAccess)worldIn, state, pos)) {
            BlockPos offset = this.getOffsetFromMultiStructureBlock((IBlockAccess)worldIn, state, pos);
            this.destroyMultiBlockStructure(worldIn, pos.func_177982_a(-offset.func_177958_n(), -offset.func_177956_o(), -offset.func_177952_p()), pos);
        }
    }

    public void onMultiBlockStructureHarvested(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (this.belongsBlockToMultiBlockStructure((IBlockAccess)worldIn, state, pos)) {
            BlockPos offset = this.getOffsetFromMultiStructureBlock((IBlockAccess)worldIn, state, pos);
            this.onMultiBlockStructureDestroyedByExplosion(worldIn, pos.func_177982_a(-offset.func_177958_n(), -offset.func_177956_o(), -offset.func_177952_p()), explosionIn);
            this.destroyMultiBlockStructure(worldIn, pos.func_177982_a(-offset.func_177958_n(), -offset.func_177956_o(), -offset.func_177952_p()), pos);
        }
    }

    public void onMultiBlockStructureDestroyedByExplosion(World worldIn, BlockPos pos, Explosion explosionIn) {
    }

    public boolean belongsBlockToMultiBlockStructure(IBlockAccess source, IBlockState state, BlockPos pos) {
        if (state.func_177230_c() == this) {
            return true;
        }
        if (this.fakeBlocksPositions != null && !this.fakeBlocksPositions.isEmpty()) {
            for (Tuple2<IBlockState, BlockPos> tuple : this.fakeBlocksPositions) {
                if (((IBlockState)tuple._1).func_177230_c() != state.func_177230_c() || source.func_180495_p(new BlockPos(pos.func_177958_n() - ((BlockPos)tuple._2).func_177958_n(), pos.func_177956_o() - ((BlockPos)tuple._2).func_177956_o(), pos.func_177952_p() - ((BlockPos)tuple._2).func_177952_p())).func_177230_c().getClass() != ((Object)((Object)this)).getClass()) continue;
                return true;
            }
        }
        return false;
    }

    public BlockPos getOffsetFromMultiStructureBlock(IBlockAccess source, IBlockState state, BlockPos pos) {
        if (this.fakeBlocksPositions != null && !this.fakeBlocksPositions.isEmpty()) {
            if (state.func_177230_c() == this) {
                return new BlockPos(0, 0, 0);
            }
            for (Tuple2<IBlockState, BlockPos> tuple : this.fakeBlocksPositions) {
                if (((IBlockState)tuple._1).func_177230_c() != state.func_177230_c() || source.func_180495_p(new BlockPos(pos.func_177958_n() - ((BlockPos)tuple._2).func_177958_n(), pos.func_177956_o() - ((BlockPos)tuple._2).func_177956_o(), pos.func_177952_p() - ((BlockPos)tuple._2).func_177952_p())).func_177230_c().getClass() != ((Object)((Object)this)).getClass()) continue;
                return (BlockPos)tuple._2;
            }
        }
        return null;
    }

    public void destroyMultiBlockStructure(World worldIn, BlockPos posMain, BlockPos pos) {
        if (!posMain.equals((Object)pos)) {
            worldIn.func_180501_a(posMain, Blocks.field_150350_a.func_176223_P(), worldIn.field_72995_K ? 11 : 3);
            worldIn.func_175664_x(posMain);
        }
        if (this.fakeBlocksPositions != null && !this.fakeBlocksPositions.isEmpty()) {
            for (Tuple2<IBlockState, BlockPos> tuple : this.fakeBlocksPositions) {
                worldIn.func_180501_a(posMain.func_177982_a(((BlockPos)tuple._2).func_177958_n(), ((BlockPos)tuple._2).func_177956_o(), ((BlockPos)tuple._2).func_177952_p()), Blocks.field_150350_a.func_176223_P(), worldIn.field_72995_K ? 11 : 3);
                worldIn.func_175664_x(posMain.func_177982_a(((BlockPos)tuple._2).func_177958_n(), ((BlockPos)tuple._2).func_177956_o(), ((BlockPos)tuple._2).func_177952_p()));
            }
        }
    }

    public void setDefaultSlipperiness(float slipperiness) {
        if (this.fakeBlocks != null && !this.fakeBlocks.isEmpty()) {
            for (Block block : this.fakeBlocks) {
                block.setDefaultSlipperiness(slipperiness);
            }
        }
        super.setDefaultSlipperiness(slipperiness);
    }

    public Block func_149711_c(float hardness) {
        if (this.fakeBlocks != null && !this.fakeBlocks.isEmpty()) {
            for (Block block : this.fakeBlocks) {
                block.func_149711_c(hardness);
            }
        }
        return super.func_149711_c(hardness);
    }

    public Block func_149722_s() {
        if (this.fakeBlocks != null && !this.fakeBlocks.isEmpty()) {
            for (Block block : this.fakeBlocks) {
                block.func_149722_s();
            }
        }
        return super.func_149722_s();
    }

    public void setHarvestLevel(String toolClass, int level) {
        if (this.fakeBlocks != null && !this.fakeBlocks.isEmpty()) {
            for (Block block : this.fakeBlocks) {
                block.setHarvestLevel(toolClass, level);
            }
        }
        super.setHarvestLevel(toolClass, level);
    }

    public Block func_149715_a(float value) {
        if (this.fakeBlocks != null && !this.fakeBlocks.isEmpty()) {
            for (Block block : this.fakeBlocks) {
                block.func_149715_a(value);
            }
        }
        return super.func_149715_a(value);
    }

    public Block func_149713_g(int opacity) {
        if (this.fakeBlocks != null && !this.fakeBlocks.isEmpty()) {
            for (Block block : this.fakeBlocks) {
                block.func_149713_g(opacity);
            }
        }
        return super.func_149713_g(opacity);
    }

    public Block func_149752_b(float resistance) {
        if (this.fakeBlocks != null && !this.fakeBlocks.isEmpty()) {
            for (Block block : this.fakeBlocks) {
                block.func_149752_b(resistance);
            }
        }
        return super.func_149752_b(resistance);
    }
}

