/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.blocks.gas_tank;

import java.util.List;
import lyon.aom.Main;
import lyon.aom.blocks.base_blocks.BlockFakeBlock;
import lyon.aom.blocks.base_blocks.BlockMultiBlockStructure;
import lyon.aom.blocks.gas_tank.TileEntityFakeGasTank;
import lyon.aom.blocks.gas_tank.TileEntityGasTank;
import lyon.aom.capabilities.fluid_tank.FluidTank;
import lyon.aom.init.BlockInit;
import lyon.aom.init.ItemInit;
import lyon.aom.init.SoundInit;
import lyon.aom.packets.PacketHandler;
import lyon.aom.packets.both.play_sound_req.PacketPlaySoundReq;
import lyon.aom.packets.both.spawn_particle_req.PacketSpawnParticleReq;
import lyon.aom.utils.enums.EnumParticles;
import lyon.aom.utils.interfaces.IHasModel;
import lyon.aom.utils.interfaces.INotTranslucent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGasTank
extends BlockMultiBlockStructure
implements IHasModel {
    private static final AxisAlignedBB boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0);
    private static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private TileEntityGasTank tileEntity = null;

    public BlockGasTank(String name, Material material) {
        super(name, material);
        this.addFakeBlockToBeRegistered(new BlockFakeGasTank(this, "block_fake_gas_tank", material));
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149711_c(3.5f);
        this.func_149752_b(17.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.addBlockToMultiBlockStructure(this.getFakeBlockFromClass(BlockFakeGasTank.class), new BlockPos(0, 1, 0));
        BlockInit.BLOCKS.add(this);
        ItemInit.ITEMS.add((Item)new ItemBlockGasTank(name, this));
    }

    @Override
    public boolean onMultiBlockStructureActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K && hand == EnumHand.MAIN_HAND) {
            ItemStack stackMainHand = playerIn.func_184586_b(hand);
            FluidTank fluidTank = null;
            if (worldIn.func_175625_s(pos) != null && worldIn.func_175625_s(pos).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP)) {
                IFluidHandler fluidHandler = (IFluidHandler)worldIn.func_175625_s(pos).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP);
                if (fluidHandler instanceof FluidTank) {
                    fluidTank = (FluidTank)fluidHandler;
                }
                if (stackMainHand.func_77973_b() == ItemInit.GAS_CARTRIDGE && stackMainHand.func_77952_i() > 0 && stackMainHand.func_77952_i() <= stackMainHand.func_77958_k() && fluidTank != null && fluidTank.getFluidAmount() > 0) {
                    int maxDrain = 6;
                    FluidStack s = fluidTank.drain(maxDrain, false);
                    int drain = s != null ? s.amount : 0;
                    int amount = Math.max(stackMainHand.func_77952_i() - drain, 0);
                    stackMainHand.func_77964_b(amount);
                    fluidTank.drain(drain, true);
                    if (drain > 0) {
                        Vec3d spawnPos = new Vec3d(playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v).func_72441_c(Math.cos(Math.toRadians(playerIn.field_70759_as)) * (double)-0.2f, (double)1.8f, Math.sin(Math.toRadians(playerIn.field_70759_as)) * (double)-0.2f).func_178787_e(playerIn.func_70040_Z().func_72432_b().func_186678_a((double)0.4f)).func_178786_a(0.0, (double)0.1f, 0.0);
                        for (int i = 0; i < 2; ++i) {
                            PacketHandler.INSTANCE.sendToAll((IMessage)new PacketSpawnParticleReq(EnumParticles.EnumAOMParticleTypes.GAS, spawnPos.field_72450_a - (double)0.1f + Math.random() * (double)0.2f, spawnPos.field_72448_b, spawnPos.field_72449_c - (double)0.1f + Math.random() * (double)0.2f, (double)((float)Math.random() * 0.0625f - 0.03125f), (double)((float)Math.random() * 0.03f + 0.03f), (double)((float)Math.random() * 0.0625f - 0.03125f), 0));
                        }
                        if (Math.random() > 0.5) {
                            PacketHandler.INSTANCE.sendToAll((IMessage)new PacketPlaySoundReq(SoundInit.ICEBURST_STONE_STEAMING, playerIn.field_70165_t, playerIn.field_70163_u + (double)1.8f, playerIn.field_70161_v, SoundCategory.AMBIENT, 0.1f, (float)((double)0.6f + Math.random() * (double)0.2f), false));
                        }
                    }
                }
            }
        }
        return true;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack stack = new ItemStack((Block)this);
        if (this.tileEntity != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("BlockEntityTag", (NBTBase)this.tileEntity.writeToStackNBT());
            stack.func_77982_d(tag);
        }
        drops.add((Object)stack);
    }

    @Override
    public void onMultiBlockStructureHarvested(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!worldIn.field_72995_K) {
            this.tileEntity = null;
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity != null && tileentity instanceof TileEntityGasTank) {
                this.tileEntity = (TileEntityGasTank)tileentity;
            }
        }
    }

    @Override
    public void onMultiBlockStructureDestroyedByExplosion(World worldIn, BlockPos pos, Explosion explosionIn) {
        if (!worldIn.field_72995_K) {
            this.tileEntity = null;
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity != null && tileentity instanceof TileEntityGasTank) {
                this.tileEntity = (TileEntityGasTank)tileentity;
            }
        }
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity != null && tileentity instanceof TileEntityGasTank && stack.func_77942_o() && stack.func_77978_p().func_74764_b("BlockEntityTag")) {
            ((TileEntityGasTank)tileentity).readFromStackNBT(stack.func_77978_p().func_74775_l("BlockEntityTag"));
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityGasTank();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return boundingBox;
    }

    public static EnumFacing getFacing(IBlockState state) {
        if (state.func_177230_c() == BlockInit.GAS_TANK) {
            return (EnumFacing)state.func_177229_b((IProperty)FACING);
        }
        return EnumFacing.NORTH;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.MIDDLE_POLE_THICK;
    }

    public String getHarvestTool(IBlockState state) {
        return "pickaxe";
    }

    public int getHarvestLevel(IBlockState state) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("BlockEntityTag") && stack.func_77978_p().func_74781_a("BlockEntityTag") instanceof NBTTagCompound) {
            NBTTagCompound nbt = (NBTTagCompound)stack.func_77978_p().func_74781_a("BlockEntityTag");
            Style style = new Style().func_150238_a(TextFormatting.RED);
            if (nbt.func_74764_b("Fluid") && nbt.func_74764_b("Amount") && nbt.func_74764_b("Capacity")) {
                tooltip.add(new TextComponentTranslation("tooltip.fluid.name", new Object[]{0}).func_150255_a(style).func_150254_d() + new TextComponentString(": ").func_150255_a(style).func_150254_d() + new TextComponentTranslation("fluid." + FluidRegistry.getFluid((String)nbt.func_74779_i("Fluid")).getName(), new Object[]{0}).func_150255_a(style).func_150254_d());
                tooltip.add(new TextComponentTranslation("tooltip.amount.name", new Object[]{0}).func_150255_a(style).func_150254_d() + new TextComponentString(": ").func_150255_a(style).func_150254_d() + new TextComponentString(Integer.toString(nbt.func_74762_e("Amount")) + "/" + Integer.toString(nbt.func_74762_e("Capacity")) + " mB").func_150255_a(style).func_150254_d());
            } else {
                tooltip.add(new TextComponentTranslation("tooltip.tank_empty.name", new Object[]{0}).func_150255_a(style).func_150254_d());
            }
        }
    }

    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        manager.func_180533_a(pos, Blocks.field_150339_S.func_176223_P());
        return true;
    }

    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return true;
    }

    @Override
    public void registerModels() {
        Main.proxy.registerItemRenderer(Item.func_150898_a((Block)this), 0, "inventory");
    }

    private class ItemBlockGasTank
    extends ItemBlock
    implements INotTranslucent {
        public ItemBlockGasTank(String name, Block block) {
            super(block);
            this.func_77655_b(name);
            this.setRegistryName("aom", name);
            this.func_77625_d(1);
        }

        public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flagIn) {
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("BlockEntityTag") && stack.func_77978_p().func_74781_a("BlockEntityTag") instanceof NBTTagCompound) {
                Style style = new Style().func_150238_a(TextFormatting.RED);
                Minecraft minecraft = Minecraft.func_71410_x();
                if (minecraft.field_71462_r.func_146271_m()) {
                    this.field_150939_a.func_190948_a(stack, world, tooltip, flagIn);
                } else {
                    tooltip.add(new TextComponentTranslation("tooltip.extend_info.name", new Object[]{0}).func_150255_a(style).func_150254_d());
                }
            }
        }

        public boolean func_77662_d() {
            return false;
        }
    }

    private class BlockFakeGasTank
    extends BlockFakeBlock {
        public BlockFakeGasTank(BlockMultiBlockStructure mainBlock, String name, Material material) {
            super(mainBlock, name, material);
        }

        public boolean hasTileEntity(IBlockState state) {
            return true;
        }

        public TileEntity createTileEntity(World world, IBlockState state) {
            return new TileEntityFakeGasTank();
        }
    }
}

