/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.blocks.pipe;

import java.util.ArrayList;
import java.util.List;
import lyon.aom.blocks.pipe.TileEntityPipe;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class PipeNetwork {
    private List<TileEntityPipe> pipes = new ArrayList<TileEntityPipe>();
    private List<TileEntityPipe> pipesConnectedToConsumer = new ArrayList<TileEntityPipe>();
    private List<TileEntityPipe> pipesConnectedToProducer = new ArrayList<TileEntityPipe>();
    private Fluid fluid;

    public void addPipeToNetwork(TileEntityPipe tileentity) {
        if (tileentity != null) {
            this.pipes.add(tileentity);
            if (tileentity.isConnectedToConsumer()) {
                this.pipesConnectedToConsumer.add(tileentity);
            }
            if (tileentity.isConnectedToProducer()) {
                this.pipesConnectedToProducer.add(tileentity);
            }
        }
    }

    public List<TileEntityPipe> getPipes() {
        return this.pipes;
    }

    public void addNetworkToThis(PipeNetwork network) {
        for (int i = 0; i < network.getPipes().size(); ++i) {
            network.getPipes().get(i).addThisToNetwork(this);
        }
    }

    public void resetNetwork() {
        for (int i = 0; i < this.getPipes().size(); ++i) {
            this.getPipes().get(i).resetNetwork();
        }
        this.pipes = new ArrayList<TileEntityPipe>();
        this.pipesConnectedToConsumer = new ArrayList<TileEntityPipe>();
        this.pipesConnectedToProducer = new ArrayList<TileEntityPipe>();
    }

    public void updatePipe(TileEntityPipe tileentity) {
        if (tileentity != null && this.pipes.contains((Object)tileentity)) {
            this.pipes.remove((Object)tileentity);
            this.pipesConnectedToConsumer.remove((Object)tileentity);
            this.pipesConnectedToProducer.remove((Object)tileentity);
            this.addPipeToNetwork(tileentity);
        }
    }

    public void checkForFluidInNetwork() {
        for (int i = 0; i < this.pipes.size(); ++i) {
            if (((IFluidHandler)this.pipes.get(i).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).getTankProperties()[0].getContents() == null) continue;
            return;
        }
        this.setFluid(null);
    }

    public int getTotalAmountInNetwork() {
        int a = 0;
        for (int i = 0; i < this.pipes.size(); ++i) {
            if (((IFluidHandler)this.pipes.get(i).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).getTankProperties()[0].getContents() == null) continue;
            a += ((IFluidHandler)this.pipes.get((int)i).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).getTankProperties()[0].getContents().amount;
        }
        return a;
    }

    public boolean areProducerAndConsumerTheSame() {
        if (this.pipesConnectedToProducer.size() > 1 || this.pipesConnectedToConsumer.size() > 1) {
            return false;
        }
        return this.pipesConnectedToConsumer.get(0) == this.pipesConnectedToProducer.get(0) && this.pipesConnectedToConsumer.get(0).areProducerAndConsumerTheSame();
    }

    public boolean canTransportFluid() {
        return this.hasProducer() && this.hasConsumer() && !this.areProducerAndConsumerTheSame();
    }

    public boolean hasProducer() {
        return !this.pipesConnectedToProducer.isEmpty();
    }

    public boolean hasConsumer() {
        return !this.pipesConnectedToConsumer.isEmpty();
    }

    public void setFluid(Fluid fluid) {
        this.fluid = fluid;
    }

    public Fluid getFluid() {
        return this.fluid;
    }
}

