/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.blocks.vaporator;

import java.util.Random;
import lyon.aom.Main;
import lyon.aom.blocks.base_blocks.BlockFakeBlock;
import lyon.aom.blocks.base_blocks.BlockMultiBlockStructure;
import lyon.aom.blocks.vaporator.TileEntityFakeVaporator;
import lyon.aom.blocks.vaporator.TileEntityVaporator;
import lyon.aom.init.BlockInit;
import lyon.aom.init.ItemInit;
import lyon.aom.init.SoundInit;
import lyon.aom.utils.enums.EnumParticles;
import lyon.aom.utils.interfaces.IHasModel;
import lyon.aom.utils.interfaces.INotTranslucent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockVaporator
extends BlockMultiBlockStructure
implements IHasModel {
    private static final AxisAlignedBB boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0);
    private static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockVaporator(String name, Material material) {
        super(name, material);
        this.addFakeBlockToBeRegistered(new BlockFakeVaporator(this, "block_fake_vaporator", material));
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149711_c(3.5f);
        this.func_149752_b(17.5f);
        this.func_149715_a(1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.addBlockToMultiBlockStructure(this.getFakeBlockFromClass(BlockFakeVaporator.class), new BlockPos(0, 1, 0));
        BlockInit.BLOCKS.add(this);
        ItemInit.ITEMS.add((Item)new BlockItemVaporator(name, this));
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity tileentity;
        if (worldIn.field_72995_K && (tileentity = worldIn.func_175625_s(pos)) != null && tileentity instanceof TileEntityVaporator && ((TileEntityVaporator)tileentity).shouldSpawnParticles()) {
            if (rand.nextDouble() > 0.75) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundInit.VAPORATOR_BURNING, SoundCategory.BLOCKS, 0.5f, 1.3f, false);
            }
            if (rand.nextDouble() > 0.25) {
                int particleNumber = (int)(1.0 + rand.nextDouble() * 4.0);
                for (int i = 0; i < particleNumber; ++i) {
                    Main.proxy.spawnParticle(EnumParticles.EnumAOMParticleTypes.GAS, worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.1, (double)pos.func_177952_p() + 0.5, (float)((double)-0.015f + rand.nextDouble() * (double)0.03f), (float)((double)0.02f + rand.nextDouble() * 0.005), (float)((double)-0.015f + rand.nextDouble() * (double)0.03f), 0);
                }
            }
        }
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K && this.belongsBlockToMultiBlockStructure((IBlockAccess)worldIn, state, pos)) {
            BlockPos offset = this.getOffsetFromMultiStructureBlock((IBlockAccess)worldIn, state, pos);
            return this.onMultiBlockStructureActivated(worldIn, pos.func_177982_a(-offset.func_177958_n(), -offset.func_177956_o(), -offset.func_177952_p()), worldIn.func_180495_p(pos.func_177982_a(-offset.func_177958_n(), -offset.func_177956_o(), -offset.func_177952_p())), playerIn, hand, facing, hitX, hitY, hitZ);
        }
        return true;
    }

    @Override
    public boolean onMultiBlockStructureActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            playerIn.openGui((Object)Main.instance, 4, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    @Override
    public void onMultiBlockStructureHarvested(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!worldIn.field_72995_K && worldIn.func_175625_s(pos) != null && worldIn.func_175625_s(pos) instanceof TileEntityVaporator) {
            ((TileEntityVaporator)worldIn.func_175625_s(pos)).dropAll();
        }
    }

    @Override
    public void onMultiBlockStructureDestroyedByExplosion(World worldIn, BlockPos pos, Explosion explosionIn) {
        if (!worldIn.field_72995_K && worldIn.func_175625_s(pos) != null && worldIn.func_175625_s(pos) instanceof TileEntityVaporator) {
            ((TileEntityVaporator)worldIn.func_175625_s(pos)).dropAll();
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return boundingBox;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityVaporator();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.MIDDLE_POLE_THICK;
    }

    @Override
    public void registerModels() {
        Main.proxy.registerItemRenderer(Item.func_150898_a((Block)this), 0, "inventory");
    }

    private class BlockItemVaporator
    extends ItemBlock
    implements INotTranslucent {
        public BlockItemVaporator(String name, Block block) {
            super(block);
            this.func_77655_b(name);
            this.setRegistryName("aom", name);
        }

        public boolean func_77662_d() {
            return false;
        }
    }

    private class BlockFakeVaporator
    extends BlockFakeBlock {
        public BlockFakeVaporator(BlockMultiBlockStructure mainBlock, String name, Material materialIn) {
            super(mainBlock, name, materialIn);
        }

        public boolean hasTileEntity(IBlockState state) {
            return true;
        }

        public TileEntity createTileEntity(World world, IBlockState state) {
            return new TileEntityFakeVaporator();
        }
    }
}

