/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.blocks.vaporator;

import lyon.aom.blocks.vaporator.TileEntityVaporator;
import lyon.aom.init.BlockInit;
import lyon.aom.utils.Utils;
import lyon.aom.utils.render.UtilsRender;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityRendererVaporator
extends TileEntitySpecialRenderer<TileEntityVaporator> {
    private static final ResourceLocation GAS_TEXTURE = new ResourceLocation("aom", "textures/blocks/gas.png");

    public void render(TileEntityVaporator te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
        if (state.func_177230_c() == BlockInit.VAPORATOR) {
            IFluidHandler fluidTank;
            int light = this.func_178459_a().func_175626_b(te.func_174877_v(), 0);
            float height = 0.0f;
            if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP) && (fluidTank = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP)) instanceof IFluidTank && ((IFluidTank)fluidTank).getFluid() != null) {
                height = Utils.interpolate(te.getField(TileEntityVaporator.VaporatorFields.STORED_GAS.getID()), te.getField(TileEntityVaporator.VaporatorFields.PREV_STORED_GAS.getID()), partialTicks) / (float)((IFluidTank)fluidTank).getCapacity();
            }
            if (height > 0.0f) {
                this.func_147499_a(GAS_TEXTURE);
                Tessellator tessellator = Tessellator.func_178181_a();
                GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.FRONT);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                UtilsRender.renderCuboid(tessellator, x + 0.5, y + 1.0 + 0.875 - (double)(0.40625f * height), z + 0.5, 0.8, 0.8, height * 0.8125f, 0.0f, 0.0f, 0.0f, light, GAS_TEXTURE);
                GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
                GlStateManager.func_179084_k();
            }
        }
    }
}

