/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.blocks.vaporator;

import lyon.aom.capabilities.fluid_tank.FluidTank;
import lyon.aom.capabilities.fluid_tank.FluidTankStorage;
import lyon.aom.capabilities.fluid_tank.FluidTankVaporator;
import lyon.aom.init.FluidInit;
import lyon.aom.init.ItemInit;
import lyon.aom.items.ItemIceBurstCanister;
import lyon.aom.packets.PacketHandler;
import lyon.aom.packets.client.sync_tileentity_int_field_req.PacketSyncTileEntityIntFieldReq;
import lyon.aom.utils.WrapperItemStackHandler;
import lyon.aom.utils.interfaces.ITileEntityIntFields;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityVaporator
extends TileEntity
implements ITickable,
ITileEntityIntFields {
    private ItemStackHandler itemHandler = new ItemStackHandler(2);
    private FluidTank fluidTank = new FluidTankVaporator();
    private String customName;
    private int prevStoredGas = 0;
    private int gasPerShard = 30;
    private int cookTimePerShard = 0;
    private int totalCookTimePerShard = 200;
    private int cookTimeTotal = 0;
    private int totalCookTimeTotal = 10 * this.totalCookTimePerShard;

    public void func_73660_a() {
        this.prevStoredGas = this.fluidTank.getFluidAmount();
        if (!this.field_145850_b.field_72995_K) {
            this.fluidTank.sendChanges(null, this.fluidTank.getNBTForSync(this, EnumFacing.UP));
            this.syncField(VaporatorFields.COOK_TIME_PER_SHARD);
            ItemStack stack = this.itemHandler.getStackInSlot(1);
            if (this.isBurning()) {
                ++this.cookTimePerShard;
                if (this.cookTimePerShard >= this.totalCookTimePerShard) {
                    this.cookTimePerShard = 0;
                    this.fluidTank.fill(new FluidStack(FluidInit.GAS, this.gasPerShard), true);
                    ItemIceBurstCanister.removeFirstShard(stack);
                }
                if (stack.func_77973_b() == ItemInit.ICEBURST_CANISTER) {
                    this.cookTimeTotal = (10 - ItemIceBurstCanister.getShardCount(stack)) * this.totalCookTimePerShard + this.cookTimePerShard;
                }
                if (this.cookTimeTotal >= this.totalCookTimeTotal) {
                    this.cookTimeTotal = 0;
                    if (this.itemHandler.getStackInSlot(0).func_190926_b()) {
                        this.itemHandler.setStackInSlot(0, new ItemStack(ItemInit.ICEBURST_CANISTER, 1));
                    } else {
                        this.itemHandler.getStackInSlot(0).func_190920_e(this.itemHandler.getStackInSlot(0).func_190916_E() + 1);
                    }
                    this.itemHandler.setStackInSlot(1, ItemStack.field_190927_a);
                }
            } else {
                this.cookTimePerShard = 0;
                this.cookTimeTotal = 0;
            }
        }
    }

    public void dropAll() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i) == ItemStack.field_190927_a) continue;
            this.func_145831_w().func_72838_d((Entity)new EntityItem(this.func_145831_w(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), this.itemHandler.getStackInSlot(i)));
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing == EnumFacing.UP;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)new VaporatorItemStackHandlerWrapper());
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing == EnumFacing.UP) {
            return (T)this.fluidTank;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCustomName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public ITextComponent func_145748_c_() {
        return this.hasCustomName() ? new TextComponentString(this.customName) : new TextComponentTranslation("container.vaporator.name", new Object[0]);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.itemHandler.deserializeNBT(compound.func_74775_l("Inventory"));
        this.cookTimePerShard = compound.func_74762_e("CookTimePerShard");
        this.totalCookTimePerShard = compound.func_74762_e("TotalCookTimePerShard");
        this.cookTimeTotal = compound.func_74762_e("CookTimeTotal");
        this.totalCookTimeTotal = compound.func_74762_e("TotalCookTimeTotal");
        if (compound.func_74764_b("FluidTank")) {
            new FluidTankStorage().readNBT((Capability<IFluidHandler>)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.fluidTank, (EnumFacing)null, compound.func_74781_a("FluidTank"));
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.setCustomName(compound.func_74779_i("CustomName"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("CookTimePerShard", this.cookTimePerShard);
        compound.func_74768_a("TotalCookTimePerShard", this.totalCookTimePerShard);
        compound.func_74768_a("CookTimeTotal", this.cookTimeTotal);
        compound.func_74768_a("TotalCookTimeTotal", this.totalCookTimeTotal);
        compound.func_74782_a("FluidTank", new FluidTankStorage().writeNBT((Capability<IFluidHandler>)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.fluidTank, (EnumFacing)null));
        compound.func_74782_a("Inventory", (NBTBase)this.itemHandler.serializeNBT());
        if (this.hasCustomName()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public boolean isBurning() {
        return this.canBurn();
    }

    private boolean canBurn() {
        return ItemIceBurstCanister.getShardCount(this.itemHandler.getStackInSlot(1)) > 0 && this.fluidTank.getFluidAmount() + this.gasPerShard <= this.fluidTank.getCapacity();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSpawnParticles() {
        return this.cookTimePerShard > 0;
    }

    public void syncField(VaporatorFields field) {
        PacketHandler.INSTANCE.sendToAll((IMessage)new PacketSyncTileEntityIntFieldReq(this, field.id));
    }

    @Override
    public int getField(int index) {
        switch (index) {
            case 0: {
                return this.cookTimePerShard;
            }
            case 1: {
                return this.totalCookTimePerShard;
            }
            case 2: {
                return this.cookTimeTotal;
            }
            case 3: {
                return this.totalCookTimeTotal;
            }
            case 4: {
                return this.fluidTank.getFluidAmount();
            }
            case 5: {
                return this.gasPerShard;
            }
            case 6: {
                return this.prevStoredGas;
            }
        }
        return 0;
    }

    @Override
    public void setField(int index, int value) {
        switch (index) {
            case 0: {
                this.cookTimePerShard = value;
                break;
            }
            case 1: {
                this.totalCookTimePerShard = value;
                break;
            }
            case 2: {
                this.cookTimeTotal = value;
                break;
            }
            case 3: {
                this.totalCookTimeTotal = value;
                break;
            }
            case 4: {
                this.setFluidAmount(value);
                break;
            }
            case 5: {
                this.gasPerShard = value;
                break;
            }
            case 6: {
                this.prevStoredGas = value;
            }
        }
    }

    public void setFluidAmount(int amount) {
        int diff;
        int n = diff = this.fluidTank.getFluid() != null ? amount - this.fluidTank.getFluidAmount() : amount;
        if (diff > 0) {
            this.fluidTank.fill(new FluidStack(this.fluidTank.getFluid() != null ? this.fluidTank.getFluid().getFluid() : FluidInit.GAS, diff), true);
        } else if (diff < 0) {
            this.fluidTank.drain(Math.abs(diff), true);
        }
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    private class VaporatorItemStackHandlerWrapper
    extends WrapperItemStackHandler {
        public VaporatorItemStackHandlerWrapper() {
            super(TileEntityVaporator.this.itemHandler);
            this.addSlot(0, null, true);
            this.addSlot(1, new Item[]{ItemInit.ICEBURST_CANISTER}, false);
        }

        @Override
        public boolean canPutStack(int index, ItemStack stack) {
            if (!super.canPutStack(index, stack)) {
                return false;
            }
            if (index == 1) {
                return ItemIceBurstCanister.getShardCount(stack) > 0 && stack.func_190916_E() == 1 && this.handler.getStackInSlot(0).func_190916_E() <= this.handler.getStackInSlot(0).func_77976_d() - 1;
            }
            return true;
        }
    }

    public static enum VaporatorFields {
        COOK_TIME_PER_SHARD(0),
        TOTAL_COOK_TIME_PER_SHARD(1),
        COOK_TIME_TOTAL(2),
        TOTAL_COOK_TIME_TOTAL(3),
        STORED_GAS(4),
        GAS_PER_SHARD(5),
        PREV_STORED_GAS(6);

        private int id;

        private VaporatorFields(int id) {
            this.id = id;
        }

        public int getID() {
            return this.id;
        }
    }
}

