/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.capabilities.accessory;

import lyon.aom.capabilities.accessory.IAccessory;
import lyon.aom.utils.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class AccessoryHandler {
    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        IAccessory accessory;
        if (event.phase == TickEvent.Phase.END && (accessory = Utils.getAccessory(event.player)) != null && accessory.isDirty()) {
            if (!event.player.field_70170_p.field_72995_K) {
                accessory.sendChanges(null, accessory.getNBTForSync(event.player));
            } else {
                accessory.sendChanges(event.player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPlayer) {
            IAccessory accessory;
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (!player.field_70170_p.func_82736_K().func_82766_b("keepInventory") && (accessory = Utils.getAccessory(player)) != null) {
                for (int i = 0; i < accessory.getStackHandler().getSlots(); ++i) {
                    if (accessory.getStackHandler().getStackInSlot(i).func_190926_b()) continue;
                    player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, accessory.getStackHandler().getStackInSlot(i)));
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerCloneEvent(PlayerEvent.Clone event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = event.getOriginal();
            EntityPlayer clone = (EntityPlayer)event.getEntity();
            if (player.field_70170_p.func_82736_K().func_82766_b("keepInventory") && event.isWasDeath() || !event.isWasDeath()) {
                IAccessory accessoryPlayer = Utils.getAccessory(player);
                IAccessory accessoryClone = Utils.getAccessory(clone);
                if (accessoryPlayer != null && accessoryClone != null) {
                    accessoryClone.copyValues(accessoryPlayer);
                    accessoryClone.setIsDirty(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerCloneEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        IAccessory accessory;
        if (!event.player.field_70170_p.field_72995_K && (accessory = Utils.getAccessory(event.player)) != null) {
            accessory.setIsDirty(true);
        }
    }

    @SubscribeEvent
    public void onPlayerStatredTracking(PlayerEvent.StartTracking event) {
        IAccessory accessory;
        if (!event.getEntity().field_70170_p.field_72995_K && event.getTarget() instanceof EntityPlayer && (accessory = Utils.getAccessory((EntityPlayer)event.getTarget())) != null) {
            accessory.sendChanges((EntityPlayer)event.getEntity(), accessory.getNBTForSync((EntityPlayer)event.getTarget()));
        }
    }
}

