/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.capabilities.odm_gear;

import lyon.aom.capabilities.odm_gear.IODMGear;
import lyon.aom.capabilities.special_equipment.ISpecialEquipment;
import lyon.aom.init.ItemInit;
import lyon.aom.init.SoundInit;
import lyon.aom.packets.PacketHandler;
import lyon.aom.packets.both.equip_handles_req.PacketEquipHandlesReq;
import lyon.aom.packets.both.play_sound_req.PacketPlaySoundReq;
import lyon.aom.packets.both.reload_blade_req.PacketReloadBladeReq;
import lyon.aom.packets.both.toggle_thunderspears_req.PacketToggleThunderspearsReq;
import lyon.aom.utils.AOMConfig;
import lyon.aom.utils.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ODMGearHandler {
    public static void toggleThunderspears(EntityPlayer player) {
        IODMGear odm_gear = Utils.getODMGear(player);
        if (odm_gear != null) {
            if (player.field_70170_p.field_72995_K) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketToggleThunderspearsReq());
            } else if (odm_gear.getStackInSlot(10).func_190926_b() && odm_gear.getStackInSlot(11).func_190926_b() && ODMGearHandler.isHoldingHandle(player, EnumHand.MAIN_HAND) && ODMGearHandler.isHoldingHandle(player, EnumHand.OFF_HAND)) {
                odm_gear.setThunderspearsActive(!odm_gear.areThunderspearsActive());
                int indexPutMainHand = odm_gear.areThunderspearsActive() ? odm_gear.getActualCurrentBladeSlot(EnumHand.MAIN_HAND) : 12;
                int indexPutOffHand = odm_gear.areThunderspearsActive() ? odm_gear.getActualCurrentBladeSlot(EnumHand.OFF_HAND) : 13;
                int indexTakeMainHand = !odm_gear.areThunderspearsActive() ? odm_gear.getActualCurrentBladeSlot(EnumHand.MAIN_HAND) : 12;
                int indexTakeOffHand = !odm_gear.areThunderspearsActive() ? odm_gear.getActualCurrentBladeSlot(EnumHand.OFF_HAND) : 13;
                Item itemPut = odm_gear.areThunderspearsActive() ? ItemInit.BLADE : ItemInit.THUNDERSPEAR;
                ODMGearHandler.loadItem(player, indexPutMainHand, indexTakeMainHand, itemPut, EnumHand.MAIN_HAND);
                ODMGearHandler.loadItem(player, indexPutOffHand, indexTakeOffHand, itemPut, EnumHand.OFF_HAND);
            }
        }
    }

    public static void equipNextBlade(EntityPlayer player, EnumHand hand) {
        IODMGear odm_gear = Utils.getODMGear(player);
        if (odm_gear != null && !odm_gear.areThunderspearsActive()) {
            if (player.field_70170_p.field_72995_K) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketReloadBladeReq(hand));
                if (odm_gear.getStackInSlot(hand == EnumHand.MAIN_HAND ? 10 : 11).func_190926_b()) {
                    Minecraft.func_71410_x().func_175597_ag().func_187460_a(hand);
                }
            } else if (odm_gear.getStackInSlot(hand == EnumHand.MAIN_HAND ? 10 : 11).func_190926_b()) {
                int indexPut = odm_gear.getActualCurrentBladeSlot(hand);
                odm_gear.incrementCurrentBladeSlot(hand);
                int indexTake = odm_gear.getActualCurrentBladeSlot(hand);
                ODMGearHandler.loadItem(player, indexPut, indexTake, ItemInit.BLADE, hand);
            }
        }
    }

    public static void equipHandles(EntityPlayer player) {
        IODMGear odm_gear = Utils.getODMGear(player);
        if (odm_gear != null) {
            if (player.field_70170_p.field_72995_K) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketEquipHandlesReq());
            } else {
                boolean b1 = ODMGearHandler.equipHandle(player, odm_gear, EnumHand.MAIN_HAND);
                boolean b2 = ODMGearHandler.equipHandle(player, odm_gear, EnumHand.OFF_HAND);
                if (b1 || b2) {
                    PacketHandler.INSTANCE.sendToAll((IMessage)new PacketPlaySoundReq(SoundEvents.field_187725_r, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundCategory.PLAYERS, 1.0f, 1.0f, false));
                }
            }
        }
    }

    public static boolean equipHandle(EntityPlayer player, IODMGear odm_gear, EnumHand hand) {
        Item itemPut;
        boolean b = false;
        int index = hand == EnumHand.MAIN_HAND ? 10 : 11;
        int indexHand = odm_gear.areThunderspearsActive() ? index + 2 : odm_gear.getActualCurrentBladeSlot(hand);
        ItemStack handleStack = odm_gear.getStackInSlot(index);
        ItemStack handStack = player.func_184586_b(hand);
        Item item = itemPut = odm_gear.areThunderspearsActive() ? ItemInit.THUNDERSPEAR : ItemInit.BLADE;
        if (handleStack.func_190926_b()) {
            ODMGearHandler.loadItem(player, indexHand, -1, itemPut, hand);
        }
        if (!handleStack.func_190926_b() && handleStack.func_77973_b() == ItemInit.HANDLE && handleStack.func_77952_i() == handleStack.func_77958_k() && handStack.func_190926_b()) {
            player.func_184611_a(hand, handleStack);
            odm_gear.setStackInSlot(index, ItemStack.field_190927_a);
            handleStack = odm_gear.getStackInSlot(index);
            b = true;
        } else if (handleStack.func_190926_b() && !handStack.func_190926_b() && handStack.func_77973_b() == ItemInit.HANDLE && handStack.func_77952_i() == handStack.func_77958_k()) {
            odm_gear.setStackInSlot(index, handStack);
            player.func_184611_a(hand, ItemStack.field_190927_a);
            b = true;
        }
        if (handleStack.func_190926_b() && b) {
            ODMGearHandler.loadItem(player, -1, indexHand, Items.field_190931_a, hand);
        }
        return b;
    }

    public static void loadItem(EntityPlayer player, int indexPut, int indexTake, Item itemPut, EnumHand hand) {
        IODMGear odm_gear = Utils.getODMGear(player);
        if (odm_gear != null && ODMGearHandler.isHoldingHandle(player, hand)) {
            ItemStack handle = player.func_184586_b(hand);
            ItemStack take = indexTake >= 0 ? odm_gear.getStackInSlot(indexTake) : ItemStack.field_190927_a;
            ItemStack put = ItemStack.field_190927_a;
            if (indexPut >= 0) {
                if (handle.func_77952_i() == 0) {
                    put = new ItemStack(ItemInit.THUNDERSPEAR, 1);
                } else if (handle.func_77952_i() < handle.func_77958_k()) {
                    put = new ItemStack(ItemInit.BLADE, 1, Math.max(handle.func_77952_i() - 1, 0));
                }
            }
            if (!put.func_190926_b()) {
                if (put.func_77973_b() != itemPut || !odm_gear.getStackInSlot(indexPut).func_190926_b()) {
                    return;
                }
                odm_gear.setStackInSlot(indexPut, put);
            }
            if (!take.func_190926_b()) {
                if (take.func_77973_b() == ItemInit.THUNDERSPEAR) {
                    handle.func_77964_b(0);
                } else if (take.func_77973_b() == ItemInit.BLADE) {
                    handle.func_77964_b(Math.min(take.func_77952_i() + 1, handle.func_77958_k()));
                }
                odm_gear.setStackInSlot(indexTake, ItemStack.field_190927_a);
            } else {
                handle.func_77964_b(handle.func_77958_k());
            }
            if (!put.func_190926_b() && put.func_77973_b() == ItemInit.BLADE || !take.func_190926_b() && take.func_77973_b() == ItemInit.BLADE) {
                PacketHandler.INSTANCE.sendToAll((IMessage)new PacketPlaySoundReq(SoundInit.BLADE_EQUIP, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundCategory.PLAYERS, 0.75f, 1.0f, false));
            }
        }
    }

    public static boolean isHoldingHandle(EntityPlayer player, EnumHand hand) {
        return player.func_184586_b(hand).func_77973_b() == ItemInit.HANDLE;
    }

    @SubscribeEvent
    public void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        ODMGearHandler.onPlayerLeaveWorld(event.player);
    }

    @SubscribeEvent
    public void onPlayerDisconnect(PlayerEvent.PlayerChangedDimensionEvent event) {
        ODMGearHandler.onPlayerLeaveWorld(event.player);
    }

    @SubscribeEvent
    public void onPlayerDisconnect(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K && Minecraft.func_71410_x().func_71356_B() && event.getWorld().field_73010_i != null && !event.getWorld().field_73010_i.isEmpty()) {
            ODMGearHandler.onPlayerLeaveWorld((EntityPlayer)event.getWorld().field_73010_i.get(0));
        }
    }

    public static void onPlayerLeaveWorld(EntityPlayer player) {
        IODMGear odm_gear;
        if (player != null && !player.field_70170_p.field_72995_K && (odm_gear = Utils.getODMGear(player)) != null) {
            odm_gear.deleteAllHooks();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            IODMGear odm_gear = Utils.getODMGear(event.player);
            ISpecialEquipment equipment = Utils.getSpecialEquipment(event.player);
            if (odm_gear != null && equipment != null && !event.player.field_70170_p.field_72995_K) {
                if (event.player.func_184218_aH() || !AOMConfig.canUseODMGearWithElytra && event.player.func_184613_cA()) {
                    odm_gear.deleteAllHooks();
                }
                if (odm_gear.getLeftBoostTicks() <= 0) {
                    boolean b2;
                    boolean b1 = odm_gear.getStackInSlot(8) != null && odm_gear.getStackInSlot(8).func_77973_b() == ItemInit.GAS_CARTRIDGE && odm_gear.getStackInSlot(8).func_77952_i() < odm_gear.getStackInSlot(8).func_77958_k();
                    boolean bl = b2 = odm_gear.getStackInSlot(9) != null && odm_gear.getStackInSlot(9).func_77973_b() == ItemInit.GAS_CARTRIDGE && odm_gear.getStackInSlot(9).func_77952_i() < odm_gear.getStackInSlot(9).func_77958_k();
                    if (b1) {
                        odm_gear.getStackInSlot(8).func_77964_b(odm_gear.getStackInSlot(8).func_77952_i() + 1);
                        odm_gear.addLeftBoostTicks(19);
                        odm_gear.setIsDirty(true);
                    }
                    if (b2) {
                        odm_gear.getStackInSlot(9).func_77964_b(odm_gear.getStackInSlot(9).func_77952_i() + 1);
                        odm_gear.addLeftBoostTicks(19);
                        odm_gear.setIsDirty(true);
                    }
                }
            }
            if (odm_gear != null && odm_gear.isDirty()) {
                if (!event.player.field_70170_p.field_72995_K) {
                    odm_gear.sendChanges(null, odm_gear.getNBTForSync(event.player));
                } else {
                    odm_gear.sendChanges(event.player);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPlayer) {
            IODMGear odm_gear;
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (!player.field_70170_p.func_82736_K().func_82766_b("keepInventory") && (odm_gear = Utils.getODMGear(player)) != null) {
                odm_gear.deleteAllHooks();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerCloneEvent(PlayerEvent.Clone event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = event.getOriginal();
            EntityPlayer clone = (EntityPlayer)event.getEntity();
            IODMGear equipPlayer = Utils.getODMGear(player);
            IODMGear equipClone = Utils.getODMGear(clone);
            if (equipPlayer != null && equipClone != null) {
                equipPlayer.deleteAllHooks();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerStatredTracking(PlayerEvent.StartTracking event) {
        IODMGear odm_gear;
        if (!event.getEntity().field_70170_p.field_72995_K && event.getTarget() instanceof EntityPlayer && (odm_gear = Utils.getODMGear((EntityPlayer)event.getTarget())) != null) {
            odm_gear.sendChanges((EntityPlayer)event.getEntity(), odm_gear.getNBTForSync((EntityPlayer)event.getTarget()));
        }
    }

    @SubscribeEvent
    public void onCommand(CommandEvent event) {
        IODMGear odm_gear;
        EntityPlayer player;
        if (!event.getSender().func_130014_f_().field_72995_K && event.getCommand().func_71517_b().equals("tp") && (player = event.getSender().func_130014_f_().func_72924_a(event.getSender().func_70005_c_())) != null && (odm_gear = Utils.getODMGear(player)) != null) {
            odm_gear.deleteAllHooks();
        }
    }
}

