/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.entity;

import io.netty.buffer.ByteBuf;
import lyon.aom.utils.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class CustomEntityProjectile
extends EntityArrow
implements IEntityAdditionalSpawnData {
    protected int lifeTime = -1;
    protected Entity shooter;
    protected String shooterName = "";

    public CustomEntityProjectile(World worldIn) {
        super(worldIn);
    }

    public CustomEntityProjectile(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y, z);
    }

    public CustomEntityProjectile(World worldIn, double x, double y, double z, double xVel, double yVel, double zVel) {
        this(worldIn, x, y, z);
        if (!this.field_70170_p.field_72995_K) {
            this.func_70024_g(xVel, yVel, zVel);
        }
    }

    public CustomEntityProjectile(World worldIn, double x, double y, double z, double velocity, float yaw, float pitch) {
        this(worldIn, x, y, z, (double)(-MathHelper.func_76126_a((float)((float)Math.toRadians(Utils.modulo(yaw, 360.0)))) * MathHelper.func_76134_b((float)((float)Math.toRadians(Utils.modulo(pitch, 360.0))))) * velocity, (double)(-MathHelper.func_76126_a((float)((float)Math.toRadians(Utils.modulo(pitch, 360.0))))) * velocity, (double)(MathHelper.func_76134_b((float)((float)Math.toRadians(Utils.modulo(yaw, 360.0)))) * MathHelper.func_76134_b((float)((float)Math.toRadians(Utils.modulo(pitch, 360.0))))) * velocity);
        this.func_70101_b((float)Utils.modulo(yaw, 360.0), (float)Utils.modulo(pitch, 360.0));
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public CustomEntityProjectile(World worldIn, double x, double y, double z, double velocity, float yaw, float pitch, int lifeTime, Entity entity) {
        this(worldIn, x, y, z, velocity, yaw, pitch);
        this.lifeTime = lifeTime;
        this.shooter = entity;
        this.shooterName = entity.func_70005_c_();
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa == this.lifeTime && !this.field_70128_L) {
                this.func_70106_y();
                return;
            }
            this.checkForEntityCollision();
            this.checkForBlockCollision();
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.func_70101_b((float)Math.toDegrees(Utils.getATanWithOffset(this.field_70179_y, -this.field_70159_w)), (float)Math.toDegrees(Math.asin(-this.field_70181_x / Utils.calcVel(this.field_70159_w, this.field_70181_x, this.field_70179_y))));
    }

    public void checkForEntityCollision() {
    }

    public void checkForBlockCollision() {
    }

    public void func_174812_G() {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.func_70106_y();
        }
    }

    public boolean func_70112_a(double distance) {
        return distance <= 200.0;
    }

    public boolean func_145770_h(double x, double y, double z) {
        double x1 = this.field_70165_t - x;
        double y1 = this.field_70163_u - y;
        double z1 = this.field_70161_v - z;
        return this.func_70112_a(Math.sqrt(x1 * x1 + y1 * y1 + z1 * z1));
    }

    protected void func_70088_a() {
    }

    public void func_70037_a(NBTTagCompound compound) {
        if (compound.func_74764_b("OwnerName")) {
            this.shooterName = compound.func_74779_i("OwnerName");
            this.shooter = Utils.getShooter(this.shooterName, (Entity)this);
        }
        if (compound.func_74764_b("LifeTime")) {
            this.lifeTime = compound.func_74762_e("LifeTime");
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        if (this.shooter != null) {
            this.shooterName = this.shooter.func_70005_c_();
        }
        compound.func_74782_a("OwnerName", (NBTBase)new NBTTagString(this.shooterName));
        compound.func_74782_a("LifeTime", (NBTBase)new NBTTagInt(this.lifeTime - this.field_70173_aa));
    }

    public void writeSpawnData(ByteBuf buffer) {
        if (this.shooter != null) {
            this.shooterName = this.shooter.func_70005_c_();
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("OwnerName", this.shooterName);
        nbt.func_74768_a("LifeTime", this.lifeTime);
        nbt.func_74776_a("Yaw", this.field_70177_z);
        nbt.func_74776_a("Pitch", this.field_70125_A);
        this.writeSpawnData(nbt);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)nbt);
    }

    protected void writeSpawnData(NBTTagCompound nbt) {
    }

    public void readSpawnData(ByteBuf additionalData) {
        NBTTagCompound nbt = ByteBufUtils.readTag((ByteBuf)additionalData);
        if (nbt != null) {
            if (nbt.func_74764_b("OwnerName")) {
                this.shooterName = nbt.func_74779_i("OwnerName");
                this.shooter = Utils.getShooter(this.shooterName, (Entity)this);
            }
            if (nbt.func_74764_b("LifeTime")) {
                this.lifeTime = nbt.func_74762_e("LifeTime");
            }
            if (nbt.func_74764_b("Yaw")) {
                this.field_70126_B = this.field_70177_z = nbt.func_74760_g("Yaw");
            }
            if (nbt.func_74764_b("Pitch")) {
                this.field_70127_C = this.field_70125_A = nbt.func_74760_g("Pitch");
            }
            this.readSpawnData(nbt);
        }
    }

    protected void readSpawnData(NBTTagCompound nbt) {
    }

    protected ItemStack func_184550_j() {
        return null;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }
}

