/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.entity.cannon;

import java.util.List;
import lyon.aom.entity.grapeshot.EntityGrapeshot;
import lyon.aom.entity.high_explosive_shell.EntityHighExplosiveShell;
import lyon.aom.init.ItemInit;
import lyon.aom.packets.PacketHandler;
import lyon.aom.packets.both.play_sound_req.PacketPlaySoundReq;
import lyon.aom.utils.Timer;
import lyon.aom.utils.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityCannon
extends EntityLiving {
    private static final AxisAlignedBB FLARE_AXIS_ALINGNED_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 2.0, 1.25, 2.0);
    private static DataParameter<Boolean> READY = EntityDataManager.func_187226_a(EntityCannon.class, (DataSerializer)DataSerializers.field_187198_h);
    private static DataParameter<ItemStack> LOADED_STACK = EntityDataManager.func_187226_a(EntityCannon.class, (DataSerializer)DataSerializers.field_187196_f);
    private Timer timer;
    public float velFactor = 0.0f;
    public float prevVelFactor = 0.0f;

    public EntityCannon(World worldIn) {
        super(worldIn);
        this.func_70105_a((float)(EntityCannon.FLARE_AXIS_ALINGNED_BB.field_72336_d - EntityCannon.FLARE_AXIS_ALINGNED_BB.field_72340_a), (float)(EntityCannon.FLARE_AXIS_ALINGNED_BB.field_72337_e - EntityCannon.FLARE_AXIS_ALINGNED_BB.field_72338_b));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_184174_b(true);
    }

    public EntityCannon(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.func_70107_b(x, y, z);
    }

    public EntityCannon(World worldIn, double x, double y, double z, float rotationYaw, float rotationPitch) {
        this(worldIn, x, y, z);
        this.field_70126_B = (float)Utils.modulo(rotationYaw, 360.0);
        this.field_70127_C = (float)Utils.modulo(rotationPitch, 360.0);
        this.field_70177_z = (float)Utils.modulo(rotationYaw, 360.0);
        this.field_70125_A = (float)Utils.modulo(rotationPitch, 360.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LOADED_STACK, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(READY, (Object)false);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack stack;
            if (this.func_184188_bt().size() == 0 && !player.func_70093_af()) {
                player.func_184220_m((Entity)this);
            } else if (this.func_184188_bt().size() == 0 && player.func_70093_af() && this.getLoadedStack() != null && this.isReady()) {
                if (this.getLoadedStack().func_77973_b().equals(ItemInit.HIGH_EXPLOSIVE_SHELL)) {
                    this.field_70170_p.func_72838_d((Entity)new EntityHighExplosiveShell(this.field_70170_p, this.field_70165_t - Math.sin(Math.toRadians(this.field_70177_z)) * (double)1.19f * Math.cos(Math.toRadians(this.field_70125_A)), this.field_70163_u + (double)0.85f - Math.sin(Math.toRadians(this.field_70125_A)) * (double)1.19f, this.field_70161_v + Math.cos(Math.toRadians(this.field_70177_z)) * (double)1.19f * Math.cos(Math.toRadians(this.field_70125_A)), 1.3f, this.field_70177_z, this.field_70125_A, player));
                } else if (this.getLoadedStack().func_77973_b().equals(ItemInit.GRAPESHOT)) {
                    for (int i = 0; i < 12; ++i) {
                        this.field_70170_p.func_72838_d((Entity)new EntityGrapeshot(this.field_70170_p, this.field_70165_t - Math.sin(Math.toRadians(this.field_70177_z)) * (double)1.19f * Math.cos(Math.toRadians(this.field_70125_A)), this.field_70163_u + (double)0.85f - Math.sin(Math.toRadians(this.field_70125_A)) * (double)1.19f, this.field_70161_v + Math.cos(Math.toRadians(this.field_70177_z)) * (double)1.19f * Math.cos(Math.toRadians(this.field_70125_A)), 1.3f, (this.field_70177_z - 5.0f + (float)Math.random() * 10.0f) % 360.0f, (this.field_70125_A - 5.0f + (float)Math.random() * 10.0f) % 360.0f, player));
                    }
                }
                this.setLoadedStack(ItemStack.field_190927_a);
                this.setReady(false);
            } else if (this.func_184188_bt().size() == 0 && player.func_70093_af() && this.getLoadedStack().equals(ItemStack.field_190927_a) && !this.isReady() && ((stack = player.func_184586_b(hand)).func_77973_b().equals(ItemInit.GRAPESHOT) || stack.func_77973_b().equals(ItemInit.HIGH_EXPLOSIVE_SHELL))) {
                ItemStack s = new ItemStack(stack.func_77973_b(), stack.func_190916_E() - 1, stack.func_77952_i());
                s.func_77982_d(stack.func_77978_p());
                player.func_184611_a(hand, s);
                this.setLoadedStack(new ItemStack(stack.func_77973_b(), 1));
                this.timer = new Timer(Timer.UpdateTypes.CUSTOM, 100, false, new Runnable(){

                    @Override
                    public void run() {
                        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketPlaySoundReq(SoundEvents.field_187909_gi, EntityCannon.this.field_70165_t, EntityCannon.this.field_70163_u, EntityCannon.this.field_70161_v, SoundCategory.MASTER, 2.5f, (float)((double)0.3f + Math.random() * (double)0.1f), false), new NetworkRegistry.TargetPoint(EntityCannon.this.field_71093_bK, EntityCannon.this.field_70165_t, EntityCannon.this.field_70163_u, EntityCannon.this.field_70161_v, 40.0));
                        EntityCannon.this.setReady(true);
                    }
                });
                this.timer.startTimer();
            }
        } else if (this.field_70170_p.field_72995_K) {
            ItemStack stack;
            if (this.func_184188_bt().size() == 0 && player.func_70093_af() && this.isReady()) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.MASTER, 0.8f, (float)((double)0.6f + Math.random() * (double)0.2f), false);
                for (int i = 0; i < 10; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t - Math.sin(Math.toRadians(this.field_70177_z)) * (double)1.19f * Math.cos(Math.toRadians(this.field_70125_A)), this.field_70163_u + (double)0.85f - Math.sin(Math.toRadians(this.field_70125_A)) * (double)1.19f, this.field_70161_v + Math.cos(Math.toRadians(this.field_70177_z)) * (double)1.19f * Math.cos(Math.toRadians(this.field_70125_A)), 0.0, 0.1, 0.0, new int[]{0});
                }
            } else if (this.func_184188_bt().size() == 0 && player.func_70093_af() && !this.isReady() && ((stack = player.func_184586_b(hand)).func_77973_b().equals(ItemInit.GRAPESHOT) || stack.func_77973_b().equals(ItemInit.HIGH_EXPLOSIVE_SHELL))) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187608_cH, SoundCategory.MASTER, 2.5f, (float)((double)0.3f + Math.random() * (double)0.1f), false);
            }
        }
        return true;
    }

    public void func_70636_d() {
        List passengers = this.func_184188_bt();
        if (!this.field_70170_p.field_72995_K && this.timer != null) {
            this.timer.update();
        }
        if (this.isInAir()) {
            this.func_184610_a(false, 0, DamageSource.field_76377_j);
            this.func_70106_y();
        }
        if (!passengers.isEmpty()) {
            this.updateEntityRotation((Entity)passengers.get(0));
        }
        if (!this.field_70170_p.field_72995_K && !passengers.isEmpty()) {
            for (Entity e : passengers) {
                if (!(this.func_70032_d(e) > 4.0f)) continue;
                e.func_184210_p();
            }
        }
    }

    public void updateEntityRotation(Entity passenger) {
        if (passenger instanceof EntityLivingBase) {
            this.field_70126_B = (float)Utils.modulo(this.field_70177_z, 360.0);
            this.field_70127_C = (float)Utils.modulo(this.field_70125_A, 360.0);
            this.field_70177_z = (float)Utils.modulo(passenger.field_70177_z, 360.0);
            this.field_70125_A = (float)Utils.modulo(passenger.field_70125_A, 360.0);
            this.prevVelFactor = this.velFactor;
            float vel = Math.min(Math.abs(this.field_70177_z - this.field_70126_B) * 4.0f, 1.0f);
            this.velFactor += (vel - this.velFactor) * 0.3f;
            this.velFactor = Math.max(this.velFactor, 0.0f);
        }
    }

    public boolean isInAir() {
        List list = this.field_70170_p.func_184144_a((Entity)this, this.func_70046_E().func_72321_a(0.0, -0.5, 0.0).func_191195_a(0.0, 0.5, 0.0));
        List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_70046_E().func_72321_a(0.0, -0.5, 0.0).func_191195_a(0.0, 0.5, 0.0));
        if (!entities.isEmpty()) {
            for (Entity e : entities) {
                if (e.func_70046_E() == null) continue;
                list.add(e.func_70046_E());
            }
        }
        if (!list.isEmpty()) {
            for (AxisAlignedBB box : list) {
                if (!(Math.abs(this.func_174813_aQ().field_72338_b - box.field_72337_e) <= (double)1.0E-4f)) continue;
                return false;
            }
        }
        return true;
    }

    public void func_184232_k(Entity passenger) {
        if (passenger != null && this.func_184196_w(passenger)) {
            passenger.func_70091_d(MoverType.SELF, Math.sin(Math.toRadians(this.field_70177_z)) * 2.0 + this.field_70165_t - passenger.field_70165_t, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W() - passenger.field_70163_u, -Math.cos(Math.toRadians(this.field_70177_z)) * 2.0 + this.field_70161_v - passenger.field_70161_v);
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187770_dm;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187766_dk;
    }

    protected void func_70609_aI() {
        if (!this.field_70128_L) {
            this.func_70106_y();
        }
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            if (this.getLoadedStack() != null) {
                this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getLoadedStack()));
            }
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(ItemInit.ITEM_CANNON, 1)));
        }
    }

    protected float func_70599_aP() {
        return 2.0f;
    }

    public boolean func_70112_a(double distance) {
        return distance <= 100.0;
    }

    public boolean func_145770_h(double x, double y, double z) {
        double x1 = this.field_70165_t - x;
        double y1 = this.field_70163_u - y;
        double z1 = this.field_70161_v - z;
        return this.func_70112_a(Math.sqrt(x1 * x1 + y1 * y1 + z1 * z1));
    }

    public boolean func_70104_M() {
        return false;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_184603_cC() {
        return false;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return true;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public float getWidth() {
        return this.field_70130_N;
    }

    public double func_70042_X() {
        return 0.4;
    }

    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return this.func_174813_aQ();
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public boolean func_70601_bi() {
        List list1 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ());
        List list2 = this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ());
        return list1.isEmpty() && list2.isEmpty() && !this.isInAir();
    }

    public void setReady(boolean r) {
        this.field_70180_af.func_187227_b(READY, (Object)r);
    }

    public boolean isReady() {
        return (Boolean)this.field_70180_af.func_187225_a(READY);
    }

    public void setLoadedStack(ItemStack s) {
        if (s != null) {
            this.field_70180_af.func_187227_b(LOADED_STACK, (Object)s);
        }
    }

    public ItemStack getLoadedStack() {
        return (ItemStack)this.field_70180_af.func_187225_a(LOADED_STACK);
    }

    public void func_70037_a(NBTTagCompound compound) {
        Item i;
        super.func_70037_a(compound);
        this.field_70177_z = (float)Utils.modulo(compound.func_74760_g("rotationYaw"), 360.0);
        this.field_70125_A = (float)Utils.modulo(compound.func_74760_g("rotationPitch"), 360.0);
        if (compound.func_74764_b("loadedStack") && ((i = (Item)Item.field_150901_e.func_148754_a(compound.func_74762_e("loadedStack"))).equals(ItemInit.HIGH_EXPLOSIVE_SHELL) || i.equals(ItemInit.GRAPESHOT))) {
            this.setLoadedStack(new ItemStack(i, 1));
        }
        if (compound.func_74764_b("isReady")) {
            this.setReady(compound.func_74767_n("isReady"));
        }
        if (!this.isReady() && !this.getLoadedStack().equals(ItemStack.field_190927_a) && compound.func_74764_b("timer")) {
            this.timer = new Timer(Timer.UpdateTypes.CUSTOM, compound.func_74762_e("timer"), false, new Runnable(){

                @Override
                public void run() {
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketPlaySoundReq(SoundEvents.field_187909_gi, EntityCannon.this.field_70165_t, EntityCannon.this.field_70163_u, EntityCannon.this.field_70161_v, SoundCategory.MASTER, 2.5f, (float)((double)0.3f + Math.random() * (double)0.1f), false), new NetworkRegistry.TargetPoint(EntityCannon.this.field_71093_bK, EntityCannon.this.field_70165_t, EntityCannon.this.field_70163_u, EntityCannon.this.field_70161_v, 40.0));
                    EntityCannon.this.setReady(true);
                }
            });
            this.timer.startTimer();
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("rotationYaw", (float)Utils.modulo(this.field_70177_z, 360.0));
        compound.func_74776_a("rotationPitch", (float)Utils.modulo(this.field_70125_A, 360.0));
        compound.func_74768_a("loadedStack", Item.field_150901_e.func_148757_b((Object)this.getLoadedStack().func_77973_b()));
        compound.func_74757_a("isReady", this.isReady());
        if (!this.isReady() && !this.getLoadedStack().equals(ItemStack.field_190927_a) && this.timer != null) {
            compound.func_74768_a("timer", this.timer.getDelay() - this.timer.getTime());
        }
    }
}

