/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.entity.flare;

import io.netty.buffer.ByteBuf;
import java.util.List;
import lyon.aom.Main;
import lyon.aom.utils.Utils;
import lyon.aom.utils.enums.EnumParticles;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityFlare
extends Entity
implements IEntityAdditionalSpawnData {
    private static final AxisAlignedBB FLARE_AXIS_ALINGNED_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.25, 0.25, 0.25);
    private int lifeTime = -1;
    private Entity shooter;
    private String shooterName = "";
    private int meta = 0;

    public EntityFlare(World worldIn) {
        super(worldIn);
        this.func_70105_a((float)(EntityFlare.FLARE_AXIS_ALINGNED_BB.field_72336_d - EntityFlare.FLARE_AXIS_ALINGNED_BB.field_72340_a), (float)(EntityFlare.FLARE_AXIS_ALINGNED_BB.field_72337_e - EntityFlare.FLARE_AXIS_ALINGNED_BB.field_72338_b));
    }

    public EntityFlare(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y, z);
    }

    public EntityFlare(World worldIn, double x, double y, double z, double xVel, double yVel, double zVel) {
        this(worldIn, x, y, z);
        if (!this.field_70170_p.field_72995_K) {
            this.func_70024_g(xVel, yVel, zVel);
        }
    }

    public EntityFlare(World worldIn, double x, double y, double z, double velocity, float yaw, float pitch) {
        this(worldIn, x, y, z, (double)(-MathHelper.func_76126_a((float)((float)Math.toRadians(Utils.modulo(yaw, 360.0)))) * MathHelper.func_76134_b((float)((float)Math.toRadians(Utils.modulo(pitch, 360.0))))) * velocity, (double)(-MathHelper.func_76126_a((float)((float)Math.toRadians(Utils.modulo(pitch, 360.0))))) * velocity, (double)(MathHelper.func_76134_b((float)((float)Math.toRadians(Utils.modulo(yaw, 360.0)))) * MathHelper.func_76134_b((float)((float)Math.toRadians(Utils.modulo(pitch, 360.0))))) * velocity);
        this.field_70126_B = (float)Utils.modulo(this.field_70177_z, 360.0);
        this.field_70127_C = (float)Utils.modulo(this.field_70125_A, 360.0);
        this.func_70101_b((float)Utils.modulo(yaw, 360.0), (float)Utils.modulo(pitch, 360.0));
    }

    public EntityFlare(World worldIn, double x, double y, double z, double velocity, float yaw, float pitch, int lifeTime, int meta, EntityLivingBase entity) {
        this(worldIn, x, y, z, velocity, yaw, pitch);
        this.lifeTime = lifeTime;
        this.shooter = entity;
        this.shooterName = this.shooter.func_70005_c_();
        this.meta = meta;
        this.field_70145_X = false;
    }

    public void func_70071_h_() {
        if (this.field_70173_aa == this.lifeTime && !this.field_70128_L) {
            this.func_70106_y();
            return;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.field_70181_x += -0.00981;
            this.field_70133_I = true;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.checkForEntityCollision();
        }
        if (Math.random() >= 0.95) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 2.0, this.field_70161_v, SoundEvents.field_187659_cY, SoundCategory.NEUTRAL, 0.7f, 0.75f, false);
        }
        Main.proxy.spawnParticle(EnumParticles.EnumAOMParticleTypes.FLARE_SMOKE, this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f, 0.0f, this.meta);
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.func_70101_b((float)Math.toDegrees(Utils.getATanWithOffset(this.field_70179_y, -this.field_70159_w)), (float)Math.toDegrees(Math.asin(-this.field_70181_x / Utils.calcVel(this.field_70159_w, this.field_70181_x, this.field_70179_y))));
    }

    public void checkForEntityCollision() {
        List list;
        if (!this.field_70128_L && (list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y))) != null) {
            Entity nearest = null;
            for (Entity e : list) {
                if (e.equals((Object)this.shooter) && this.field_70173_aa <= 3) continue;
                if (nearest == null) {
                    nearest = e;
                    continue;
                }
                if (!(Utils.getEntityDist(this, e) < Utils.getEntityDist(this, nearest))) continue;
                nearest = e;
            }
            if (nearest != null) {
                nearest.func_70097_a(DamageSource.func_188403_a((Entity)this, (EntityLivingBase)((EntityLivingBase)this.shooter)), 1.0f);
                this.func_70106_y();
                return;
            }
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_174812_G() {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.func_70106_y();
        }
    }

    public boolean func_70112_a(double distance) {
        return distance <= 200.0;
    }

    public boolean func_145770_h(double x, double y, double z) {
        double x1 = this.field_70165_t - x;
        double y1 = this.field_70163_u - y;
        double z1 = this.field_70161_v - z;
        return this.func_70112_a(Math.sqrt(x1 * x1 + y1 * y1 + z1 * z1));
    }

    public int getMeta() {
        return this.meta;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_74764_b("Meta")) {
            this.meta = compound.func_74762_e("Meta");
        }
        if (compound.func_74764_b("OwnerName")) {
            this.shooterName = compound.func_74779_i("OwnerName");
            this.shooter = Utils.getShooter(this.shooterName, this);
        }
        if (compound.func_74764_b("LifeTime")) {
            this.lifeTime = compound.func_74762_e("LifeTime");
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.shooter != null) {
            this.shooterName = this.shooter.func_70005_c_();
        }
        compound.func_74782_a("Meta", (NBTBase)new NBTTagInt(this.meta));
        compound.func_74782_a("OwnerName", (NBTBase)new NBTTagString(this.shooterName));
        compound.func_74782_a("LifeTime", (NBTBase)new NBTTagInt(this.lifeTime - this.field_70173_aa));
    }

    public void writeSpawnData(ByteBuf buffer) {
        if (this.shooter != null) {
            this.shooterName = this.shooter.func_70005_c_();
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("Meta", this.meta);
        nbt.func_74778_a("OwnerName", this.shooterName);
        nbt.func_74768_a("LifeTime", this.lifeTime);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)nbt);
    }

    public void readSpawnData(ByteBuf additionalData) {
        NBTTagCompound nbt = ByteBufUtils.readTag((ByteBuf)additionalData);
        if (nbt.func_74764_b("Meta")) {
            this.meta = nbt.func_74762_e("Meta");
        }
        if (nbt.func_74764_b("OwnerName")) {
            this.shooterName = nbt.func_74779_i("OwnerName");
            this.shooter = Utils.getShooter(this.shooterName, this);
        }
        if (nbt.func_74764_b("LifeTime")) {
            this.lifeTime = nbt.func_74762_e("LifeTime");
        }
    }
}

