/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.entity.grapeshot;

import io.netty.buffer.ByteBuf;
import java.util.List;
import lyon.aom.entity.cannon.EntityCannon;
import lyon.aom.entity.mobile_cannon.EntityMobileCannon;
import lyon.aom.utils.EntityDamage;
import lyon.aom.utils.Utils;
import lyon.aom.utils.handlers.GrapeshotDamageHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityGrapeshot
extends Entity
implements IEntityAdditionalSpawnData {
    private static final AxisAlignedBB FLARE_AXIS_ALINGNED_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.25, 0.25, 0.25);
    private String shooterName = "";
    private EntityLivingBase shooter;

    public EntityGrapeshot(World worldIn) {
        super(worldIn);
        this.func_70105_a((float)(EntityGrapeshot.FLARE_AXIS_ALINGNED_BB.field_72336_d - EntityGrapeshot.FLARE_AXIS_ALINGNED_BB.field_72340_a), (float)(EntityGrapeshot.FLARE_AXIS_ALINGNED_BB.field_72337_e - EntityGrapeshot.FLARE_AXIS_ALINGNED_BB.field_72338_b));
    }

    public EntityGrapeshot(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y, z);
    }

    public EntityGrapeshot(World worldIn, double x, double y, double z, double xVel, double yVel, double zVel) {
        this(worldIn, x, y, z);
        if (!this.field_70170_p.field_72995_K) {
            this.func_70024_g(xVel, yVel, zVel);
        }
    }

    public EntityGrapeshot(World worldIn, double x, double y, double z, double velocity, float yaw, float pitch) {
        this(worldIn, x, y, z, (double)(-MathHelper.func_76126_a((float)((float)Math.toRadians(Utils.modulo(yaw, 360.0)))) * MathHelper.func_76134_b((float)((float)Math.toRadians(Utils.modulo(pitch, 360.0))))) * velocity, (double)(-MathHelper.func_76126_a((float)((float)Math.toRadians(Utils.modulo(pitch, 360.0))))) * velocity, (double)(MathHelper.func_76134_b((float)((float)Math.toRadians(Utils.modulo(yaw, 360.0)))) * MathHelper.func_76134_b((float)((float)Math.toRadians(Utils.modulo(pitch, 360.0))))) * velocity);
        this.field_70126_B = (float)Utils.modulo(this.field_70177_z, 360.0);
        this.field_70127_C = (float)Utils.modulo(this.field_70125_A, 360.0);
        this.func_70101_b((float)Utils.modulo(yaw, 360.0), (float)Utils.modulo(pitch, 360.0));
    }

    public EntityGrapeshot(World worldIn, double x, double y, double z, double velocity, float yaw, float pitch, EntityPlayer shooter) {
        this(worldIn, x, y, z, velocity, yaw, pitch);
        this.shooter = shooter;
        this.field_70145_X = true;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.field_70181_x += -0.00981;
            this.field_70133_I = true;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.checkForEntityCollision();
            this.checkForBlockCollision();
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.func_70101_b((float)Math.toDegrees(Utils.getATanWithOffset(this.field_70179_y, -this.field_70159_w)), (float)Math.toDegrees(Math.asin(-this.field_70181_x / Utils.calcVel(this.field_70159_w, this.field_70181_x, this.field_70179_y))));
    }

    public void checkForEntityCollision() {
        List list;
        if (!this.field_70128_L && (list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y))) != null) {
            Entity nearest = null;
            for (Entity e : list) {
                if (this.field_70173_aa <= 3 && (e instanceof EntityCannon || e instanceof EntityMobileCannon) || e instanceof EntityGrapeshot) continue;
                if (nearest == null) {
                    nearest = e;
                    continue;
                }
                if (!(Utils.getEntityDist(this, e) < Utils.getEntityDist(this, nearest))) continue;
                nearest = e;
            }
            if (nearest != null) {
                GrapeshotDamageHandler.addEntityDamage(new EntityDamage(nearest, (Entity)this.shooter, this, 6.0f));
                this.func_70106_y();
                return;
            }
        }
    }

    public void checkForBlockCollision() {
        List list;
        if (!this.field_70128_L && (list = this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y))) != null && !list.isEmpty() && this.field_70173_aa > 1) {
            this.func_70106_y();
            return;
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_174812_G() {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.func_70106_y();
        }
    }

    public boolean func_70112_a(double distance) {
        return distance <= 200.0;
    }

    public boolean func_145770_h(double x, double y, double z) {
        double x1 = this.field_70165_t - x;
        double y1 = this.field_70163_u - y;
        double z1 = this.field_70161_v - z;
        return this.func_70112_a(Math.sqrt(x1 * x1 + y1 * y1 + z1 * z1));
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_74764_b("OwnerName")) {
            this.shooterName = compound.func_74779_i("OwnerName");
            this.shooter = Utils.getShooter(this.shooterName, this);
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.shooter != null) {
            this.shooterName = this.shooter.func_70005_c_();
        }
        compound.func_74782_a("OwnerName", (NBTBase)new NBTTagString(this.shooterName));
    }

    public void writeSpawnData(ByteBuf buffer) {
        if (this.shooter != null) {
            this.shooterName = this.shooter.func_70005_c_();
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("OwnerName", this.shooterName);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)nbt);
    }

    public void readSpawnData(ByteBuf additionalData) {
        NBTTagCompound nbt = ByteBufUtils.readTag((ByteBuf)additionalData);
        if (nbt.func_74764_b("OwnerName")) {
            this.shooterName = nbt.func_74779_i("OwnerName");
            this.shooter = Utils.getShooter(this.shooterName, this);
        }
    }
}

