/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.entity.mobile_cannon;

import java.util.List;
import javax.vecmath.Vector2d;
import lyon.aom.entity.cannon.EntityCannon;
import lyon.aom.entity.grapeshot.EntityGrapeshot;
import lyon.aom.entity.high_explosive_shell.EntityHighExplosiveShell;
import lyon.aom.init.ItemInit;
import lyon.aom.packets.PacketHandler;
import lyon.aom.packets.both.play_sound_req.PacketPlaySoundReq;
import lyon.aom.packets.client.entity_velocity_req.PacketEntityVelocityReq;
import lyon.aom.utils.Timer;
import lyon.aom.utils.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityMobileCannon
extends EntityLiving {
    private static final AxisAlignedBB FLARE_AXIS_ALINGNED_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.7, 1.5625, 1.7);
    private static DataParameter<Boolean> READY = EntityDataManager.func_187226_a(EntityMobileCannon.class, (DataSerializer)DataSerializers.field_187198_h);
    private static DataParameter<ItemStack> LOADED_STACK = EntityDataManager.func_187226_a(EntityMobileCannon.class, (DataSerializer)DataSerializers.field_187196_f);
    public float tire_left_angle;
    public float prev_tire_left_angle;
    public float tire_right_angle;
    public float prev_tire_right_angle;
    private Timer timer;
    public float velFactor = 0.0f;
    public float prevVelFactor = 0.0f;
    public boolean isMoving;

    public EntityMobileCannon(World worldIn) {
        super(worldIn);
        this.func_70105_a((float)(EntityMobileCannon.FLARE_AXIS_ALINGNED_BB.field_72336_d - EntityMobileCannon.FLARE_AXIS_ALINGNED_BB.field_72340_a), (float)(EntityMobileCannon.FLARE_AXIS_ALINGNED_BB.field_72337_e - EntityMobileCannon.FLARE_AXIS_ALINGNED_BB.field_72338_b));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_184174_b(true);
        this.field_70138_W = 0.5f;
        this.prev_tire_left_angle = 0.0f;
        this.prev_tire_right_angle = 0.0f;
        this.tire_left_angle = 0.0f;
        this.tire_right_angle = 0.0f;
    }

    public EntityMobileCannon(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.func_70107_b(x, y, z);
    }

    public EntityMobileCannon(World worldIn, double x, double y, double z, float rotationYaw, float rotationPitch) {
        this(worldIn, x, y, z);
        this.field_70126_B = (float)Utils.modulo(rotationYaw, 360.0);
        this.field_70127_C = (float)Utils.modulo(rotationPitch, 360.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LOADED_STACK, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(READY, (Object)false);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack stack;
            if (this.func_184188_bt().size() == 0 && !player.func_70093_af()) {
                player.func_184220_m((Entity)this);
            } else if (this.func_184188_bt().size() == 0 && player.func_70093_af() && this.getLoadedStack() != null && this.isReady()) {
                if (this.getLoadedStack().func_77973_b().equals(ItemInit.HIGH_EXPLOSIVE_SHELL)) {
                    EntityHighExplosiveShell e = new EntityHighExplosiveShell(this.field_70170_p, this.field_70165_t - Math.sin(Math.toRadians(this.field_70177_z)) * (double)1.19f * Math.cos(Math.toRadians(this.field_70125_A)), this.field_70163_u + (double)0.85f - Math.sin(Math.toRadians(this.field_70125_A)) * (double)1.19f, this.field_70161_v + Math.cos(Math.toRadians(this.field_70177_z)) * (double)1.19f * Math.cos(Math.toRadians(this.field_70125_A)), 1.3f, this.field_70177_z, this.field_70125_A, player);
                    e.func_70024_g(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                    this.field_70170_p.func_72838_d((Entity)e);
                } else if (this.getLoadedStack().func_77973_b().equals(ItemInit.GRAPESHOT)) {
                    for (int i = 0; i < 12; ++i) {
                        EntityGrapeshot e = new EntityGrapeshot(this.field_70170_p, this.field_70165_t - Math.sin(Math.toRadians(this.field_70177_z)) * (double)1.19f * Math.cos(Math.toRadians(this.field_70125_A)), this.field_70163_u + (double)0.85f - Math.sin(Math.toRadians(this.field_70125_A)) * (double)1.19f, this.field_70161_v + Math.cos(Math.toRadians(this.field_70177_z)) * (double)1.19f * Math.cos(Math.toRadians(this.field_70125_A)), 1.3f, (this.field_70177_z - 5.0f + (float)Math.random() * 10.0f) % 360.0f, (this.field_70125_A - 5.0f + (float)Math.random() * 10.0f) % 360.0f, player);
                        e.func_70024_g(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                        this.field_70170_p.func_72838_d((Entity)e);
                    }
                }
                this.setLoadedStack(ItemStack.field_190927_a);
                this.setReady(false);
            } else if (this.func_184188_bt().size() == 0 && player.func_70093_af() && this.getLoadedStack().equals(ItemStack.field_190927_a) && !this.isReady() && ((stack = player.func_184586_b(hand)).func_77973_b().equals(ItemInit.GRAPESHOT) || stack.func_77973_b().equals(ItemInit.HIGH_EXPLOSIVE_SHELL))) {
                ItemStack s = new ItemStack(stack.func_77973_b(), stack.func_190916_E() - 1, stack.func_77952_i());
                s.func_77982_d(stack.func_77978_p());
                player.func_184611_a(hand, s);
                this.setLoadedStack(new ItemStack(stack.func_77973_b(), 1));
                this.timer = new Timer(Timer.UpdateTypes.CUSTOM, 100, false, new Runnable(){

                    @Override
                    public void run() {
                        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketPlaySoundReq(SoundEvents.field_187909_gi, EntityMobileCannon.this.field_70165_t, EntityMobileCannon.this.field_70163_u, EntityMobileCannon.this.field_70161_v, SoundCategory.MASTER, 2.5f, (float)((double)0.3f + Math.random() * (double)0.1f), false), new NetworkRegistry.TargetPoint(EntityMobileCannon.this.field_71093_bK, EntityMobileCannon.this.field_70165_t, EntityMobileCannon.this.field_70163_u, EntityMobileCannon.this.field_70161_v, 40.0));
                        EntityMobileCannon.this.setReady(true);
                    }
                });
                this.timer.startTimer();
            }
        } else if (this.field_70170_p.field_72995_K) {
            ItemStack stack;
            if (this.func_184188_bt().size() == 0 && player.func_70093_af() && this.isReady()) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.MASTER, 0.8f, (float)((double)0.6f + Math.random() * (double)0.2f), false);
                for (int i = 0; i < 10; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t - Math.sin(Math.toRadians(this.field_70177_z)) * (double)1.19f * Math.cos(Math.toRadians(this.field_70125_A)), this.field_70163_u + (double)0.85f - Math.sin(Math.toRadians(this.field_70125_A)) * (double)1.19f, this.field_70161_v + Math.cos(Math.toRadians(this.field_70177_z)) * (double)1.19f * Math.cos(Math.toRadians(this.field_70125_A)), 0.0, 0.1, 0.0, new int[]{0});
                }
            } else if (this.func_184188_bt().size() == 0 && player.func_70093_af() && !this.isReady() && ((stack = player.func_184586_b(hand)).func_77973_b().equals(ItemInit.GRAPESHOT) || stack.func_77973_b().equals(ItemInit.HIGH_EXPLOSIVE_SHELL))) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187608_cH, SoundCategory.MASTER, 2.5f, (float)((double)0.3f + Math.random() * (double)0.1f), false);
            }
        }
        return true;
    }

    public void func_70636_d() {
        List passengers = this.func_184188_bt();
        if (!this.field_70170_p.field_72995_K && this.timer != null) {
            this.timer.update();
        }
        if (!passengers.isEmpty()) {
            this.updateEntityRotation((Entity)passengers.get(0));
        }
        if (!this.field_70170_p.field_72995_K && !passengers.isEmpty() && passengers.get(0) instanceof EntityPlayer) {
            this.updateMovment((EntityPlayer)passengers.get(0));
        } else if (!this.field_70170_p.field_72995_K) {
            this.field_70159_w = Math.signum(this.field_70159_w) * Math.max(Math.abs(this.field_70159_w) - 1.0, 0.0);
            this.field_70179_y = Math.signum(this.field_70179_y) * Math.max(Math.abs(this.field_70179_y) - 1.0, 0.0);
            this.field_70133_I = true;
        }
        if (!this.field_70170_p.field_72995_K && !passengers.isEmpty()) {
            for (Entity e : this.func_184188_bt()) {
                if (!(this.func_70032_d(e) > 4.0f)) continue;
                e.func_184210_p();
            }
        }
        if (this.isInAir()) {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70181_x = Math.max(this.field_70181_x - (double)0.07f, -4.0);
                this.field_70133_I = true;
            }
            this.field_70143_R = (float)((double)Math.abs(this.field_70143_R) + Math.abs(this.field_70181_x));
            this.func_180430_e(this.field_70143_R, 0.0f);
        } else {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70181_x = 0.0;
                this.field_70133_I = true;
            }
            this.func_180430_e(this.field_70143_R, (int)((this.field_70143_R - 3.0f) / 0.5f) * 1);
            this.field_70143_R = 0.0f;
        }
        if (!this.field_70170_p.field_72995_K && this.checkForEntityCollision()) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.field_70133_I = true;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.moveRel(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (this.field_70133_I) {
                PacketHandler.INSTANCE.sendToAllTracking((IMessage)new PacketEntityVelocityReq((Entity)this), (Entity)this);
            }
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.updateWheels();
        if (!passengers.isEmpty() && passengers.get(0) instanceof EntityPlayer) {
            this.updateVelFactor((EntityPlayer)passengers.get(0));
        }
    }

    public Entity func_184179_bs() {
        if (this.func_184188_bt() != null && this.func_184188_bt().size() >= 1) {
            return (Entity)this.func_184188_bt().get(0);
        }
        return null;
    }

    public void updateVelFactor(EntityPlayer passenger) {
        if (this.field_70170_p.field_72995_K) {
            this.prevVelFactor = this.velFactor;
            if (passenger.field_191988_bg != 0.0f) {
                if (!this.isMoving) {
                    this.prevVelFactor = 0.0f;
                    this.velFactor = 0.0f;
                    this.isMoving = true;
                }
                float vel = passenger.field_191988_bg * 4.0f;
                this.velFactor += (vel - this.velFactor) * 0.3f;
            } else {
                if (this.isMoving) {
                    this.prevVelFactor = 0.0f;
                    this.velFactor = 0.0f;
                    this.isMoving = false;
                }
                float vel = Math.min(Math.abs(this.field_70177_z - this.field_70126_B) * 4.0f, 1.0f);
                this.velFactor += (vel - this.velFactor) * 0.3f;
                this.velFactor = Math.max(this.velFactor, 0.0f);
            }
        }
    }

    public void updateWheels() {
        float velocity = (float)((double)(Math.abs(new Vector2d(-Math.sin(Math.toRadians(this.field_70177_z)), Math.cos(Math.toRadians(this.field_70177_z))).angle(new Vector2d(this.field_70159_w, this.field_70179_y))) > 1.5707963267948966 ? -1.0f : 1.0f) * Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        float circumference = 4.712389f;
        this.prev_tire_left_angle = this.tire_left_angle;
        this.prev_tire_right_angle = this.tire_right_angle;
        this.tire_left_angle = (float)Utils.modulo(this.tire_left_angle + velocity / circumference * 360.0f, 360.0);
        this.tire_right_angle = (float)Utils.modulo(this.tire_right_angle + velocity / circumference * 360.0f, 360.0);
    }

    public boolean checkForEntityCollision() {
        List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72317_d(this.field_70159_w, this.field_70181_x, this.field_70179_y));
        for (Entity e : entities) {
            if (!e.func_174813_aQ().func_72326_a(this.func_174813_aQ()) || !(e instanceof EntityCannon) && !(e instanceof EntityMobileCannon)) continue;
            return true;
        }
        return false;
    }

    public boolean isInAir() {
        List list = this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, -Math.abs(this.field_70181_x) - 1.0, this.field_70179_y));
        List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x + Math.signum(this.field_70181_x) * 1.0, this.field_70179_y));
        for (Entity e : entities) {
            if (e.func_174813_aQ() == null) continue;
            list.add(e.func_174813_aQ());
        }
        if (!list.isEmpty()) {
            for (AxisAlignedBB box : list) {
                if (!(Math.abs(this.func_70046_E().field_72338_b - box.field_72337_e) <= (double)1.0E-4f)) continue;
                return false;
            }
        }
        return true;
    }

    public void updateMovment(EntityPlayer player) {
        float yaw = this.field_70177_z;
        this.field_70159_w = -Math.sin(Math.toRadians(yaw)) * (double)0.08f * (double)player.field_191988_bg;
        this.field_70179_y = Math.cos(Math.toRadians(yaw)) * (double)0.08f * (double)player.field_191988_bg;
        this.field_70133_I = true;
    }

    public void updateEntityRotation(Entity passenger) {
        if (passenger instanceof EntityLivingBase) {
            this.field_70126_B = (float)Utils.modulo(this.field_70177_z, 360.0);
            this.field_70127_C = (float)Utils.modulo(this.field_70125_A, 360.0);
            this.field_70177_z = (float)Utils.modulo(passenger.field_70177_z, 360.0);
            this.field_70125_A = (float)Utils.modulo(passenger.field_70125_A, 360.0);
        }
    }

    public void func_184232_k(Entity passenger) {
        if (passenger != null && this.func_184196_w(passenger)) {
            passenger.func_70091_d(MoverType.SELF, Math.sin(Math.toRadians(this.field_70177_z)) * 2.0 + this.field_70165_t + this.field_70159_w - passenger.field_70165_t, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W() - passenger.field_70163_u, -Math.cos(Math.toRadians(this.field_70177_z)) * 2.0 + this.field_70161_v + this.field_70179_y - passenger.field_70161_v);
        }
    }

    public void moveRel(double x, double y, double z) {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        List list1 = this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ());
        if (!list1.isEmpty()) {
            this.func_145771_j(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            x = this.field_70159_w;
            y = this.field_70181_x;
            z = this.field_70179_y;
        } else {
            double xOff1 = x;
            double yOff1 = y;
            double zOff1 = z;
            double xOff2 = x;
            double yOff2 = y;
            double zOff2 = z;
            AxisAlignedBB entityBox = this.func_174813_aQ();
            List list2 = this.field_70170_p.func_184144_a((Entity)this, entityBox.func_72321_a(xOff1, yOff1, zOff1));
            List list3 = this.field_70170_p.func_184144_a((Entity)this, entityBox.func_191195_a(0.0, (double)(-this.field_70138_W), 0.0).func_72321_a(xOff2, yOff2 + (double)this.field_70138_W, zOff2));
            if (!list2.isEmpty()) {
                for (AxisAlignedBB box : list2) {
                    xOff1 = box.func_72316_a(entityBox, xOff1);
                    yOff1 = box.func_72323_b(entityBox, yOff1);
                    zOff1 = box.func_72322_c(entityBox, zOff1);
                }
                List list4 = this.field_70170_p.func_184144_a((Entity)this, entityBox.func_72321_a(x, y + (double)this.field_70138_W, z));
                double d = Utils.getHighestPointOffset(list4, this.field_70163_u);
                for (AxisAlignedBB box : list3) {
                    xOff2 = box.func_72316_a(entityBox, xOff2);
                    yOff2 = box.func_72323_b(entityBox, yOff2);
                    zOff2 = box.func_72322_c(entityBox, zOff2);
                }
                if ((Math.abs(xOff2) > Math.abs(xOff1) || Math.abs(zOff2) > Math.abs(zOff1)) && d <= (double)this.field_70138_W && this.field_70170_p.func_184144_a((Entity)this, entityBox.func_72317_d(xOff2, yOff2 + d, zOff2)).isEmpty()) {
                    x = xOff2;
                    y = yOff2 + d;
                    z = zOff2;
                } else {
                    x = xOff1;
                    y = yOff1;
                    z = zOff1;
                }
            }
        }
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        this.field_70133_I = true;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if ((double)damageMultiplier > 0.0) {
            this.func_70097_a(DamageSource.field_76379_h, damageMultiplier);
        }
        if (!this.field_70170_p.field_72995_K && !this.func_184188_bt().isEmpty() && Math.abs(distance) >= 2.5f) {
            for (Entity e : this.func_184188_bt()) {
                e.func_184210_p();
            }
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187770_dm;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187766_dk;
    }

    protected void func_70609_aI() {
        if (!this.field_70128_L) {
            this.func_70106_y();
        }
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.getLoadedStack() != null) {
                this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getLoadedStack()));
            }
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(ItemInit.ITEM_MOBILE_CANNON, 1)));
        }
    }

    protected float func_70599_aP() {
        return 2.0f;
    }

    public boolean func_70112_a(double distance) {
        return distance <= 100.0;
    }

    public boolean func_145770_h(double x, double y, double z) {
        double x1 = this.field_70165_t - x;
        double y1 = this.field_70163_u - y;
        double z1 = this.field_70161_v - z;
        return this.func_70112_a(Math.sqrt(x1 * x1 + y1 * y1 + z1 * z1));
    }

    public boolean func_70104_M() {
        return true;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_184603_cC() {
        return false;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return true;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public float getWidth() {
        return this.field_70130_N;
    }

    public double func_70042_X() {
        return 0.4;
    }

    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return this.func_174813_aQ();
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public boolean func_70601_bi() {
        List list1 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ());
        List list2 = this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ());
        return list1.isEmpty() && list2.isEmpty();
    }

    public void setReady(boolean r) {
        this.field_70180_af.func_187227_b(READY, (Object)r);
    }

    public boolean isReady() {
        return (Boolean)this.field_70180_af.func_187225_a(READY);
    }

    public void setLoadedStack(ItemStack s) {
        if (s != null) {
            this.field_70180_af.func_187227_b(LOADED_STACK, (Object)s);
        }
    }

    public ItemStack getLoadedStack() {
        return (ItemStack)this.field_70180_af.func_187225_a(LOADED_STACK);
    }

    public void func_70037_a(NBTTagCompound compound) {
        Item i;
        super.func_70037_a(compound);
        this.field_70177_z = (float)Utils.modulo(compound.func_74760_g("rotationYaw"), 360.0);
        this.field_70125_A = (float)Utils.modulo(compound.func_74760_g("rotationPitch"), 360.0);
        if (compound.func_74764_b("loadedStack") && ((i = (Item)Item.field_150901_e.func_148754_a(compound.func_74762_e("loadedStack"))).equals(ItemInit.HIGH_EXPLOSIVE_SHELL) || i.equals(ItemInit.GRAPESHOT))) {
            this.setLoadedStack(new ItemStack(i, 1));
        }
        if (compound.func_74764_b("isReady")) {
            this.setReady(compound.func_74767_n("isReady"));
        }
        if (!this.isReady() && !this.getLoadedStack().equals(ItemStack.field_190927_a) && compound.func_74764_b("timer")) {
            this.timer = new Timer(Timer.UpdateTypes.CUSTOM, compound.func_74762_e("timer"), false, new Runnable(){

                @Override
                public void run() {
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketPlaySoundReq(SoundEvents.field_187909_gi, EntityMobileCannon.this.field_70165_t, EntityMobileCannon.this.field_70163_u, EntityMobileCannon.this.field_70161_v, SoundCategory.MASTER, 2.5f, (float)((double)0.3f + Math.random() * (double)0.1f), false), new NetworkRegistry.TargetPoint(EntityMobileCannon.this.field_71093_bK, EntityMobileCannon.this.field_70165_t, EntityMobileCannon.this.field_70163_u, EntityMobileCannon.this.field_70161_v, 40.0));
                    EntityMobileCannon.this.setReady(true);
                }
            });
            this.timer.startTimer();
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("rotationYaw", (float)Utils.modulo(this.field_70177_z, 360.0));
        compound.func_74776_a("rotationPitch", (float)Utils.modulo(this.field_70125_A, 360.0));
        compound.func_74768_a("loadedStack", Item.field_150901_e.func_148757_b((Object)this.getLoadedStack().func_77973_b()));
        compound.func_74757_a("isReady", this.isReady());
        if (!this.isReady() && !this.getLoadedStack().equals(ItemStack.field_190927_a) && this.timer != null) {
            compound.func_74768_a("timer", this.timer.getDelay() - this.timer.getTime());
        }
    }
}

