/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.gui.tabbed_survival.tabs.default_tab;

import javax.annotation.Nullable;
import lyon.aom.capabilities.special_equipment.ISpecialEquipment;
import lyon.aom.gui.tabbed_survival.ContainerTabbedSurvival;
import lyon.aom.gui.tabbed_survival.tabs.SurvivalTab;
import lyon.aom.gui.tabbed_survival.tabs.slots.SlotBelt;
import lyon.aom.gui.tabbed_survival.tabs.slots.SlotCraftingTabbed;
import lyon.aom.gui.tabbed_survival.tabs.slots.SlotODMGear;
import lyon.aom.gui.tabbed_survival.tabs.slots.SlotTabbed;
import lyon.aom.init.ItemInit;
import lyon.aom.utils.Utils;
import lyon.aom.utils.enums.EnumEntitys;
import lyon.aom.utils.interfaces.ITabCrafting;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public class SurvivalTabDefault
extends SurvivalTab
implements ITabCrafting {
    private static final EntityEquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
    public InventoryCrafting craftMatrix;
    public InventoryCraftResult craftResult;
    private EntityPlayer player;
    private ContainerTabbedSurvival container;

    public SurvivalTabDefault(final EntityPlayer player, ContainerTabbedSurvival container) {
        super("default", Item.func_150898_a((Block)Blocks.field_150349_c));
        this.player = player;
        this.container = container;
        this.craftMatrix = new InventoryCrafting((Container)this.container, 2, 2);
        this.craftResult = new InventoryCraftResult();
        this.addSlot((Slot)new SlotCraftingTabbed(this.player, this.craftMatrix, (IInventory)this.craftResult, 0, 154, 28));
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.addSlot(new SlotTabbed((IInventory)this.craftMatrix, j + i * 2, 98 + j * 18, 18 + i * 18));
            }
        }
        for (int k = 0; k < 4; ++k) {
            final EntityEquipmentSlot entityequipmentslot = VALID_EQUIPMENT_SLOTS[k];
            this.addSlot(new SlotTabbed((IInventory)this.player.field_71071_by, 36 + (3 - k), 8, 8 + k * 18){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(ItemStack stack) {
                    return stack.func_77973_b().isValidArmor(stack, entityequipmentslot, (Entity)player);
                }

                public boolean func_82869_a(EntityPlayer playerIn) {
                    ItemStack itemstack = this.func_75211_c();
                    return !itemstack.func_190926_b() && !playerIn.func_184812_l_() && EnchantmentHelper.func_190938_b((ItemStack)itemstack) ? false : super.func_82869_a(playerIn);
                }

                @Nullable
                @SideOnly(value=Side.CLIENT)
                public String func_178171_c() {
                    return ItemArmor.field_94603_a[entityequipmentslot.func_188454_b()];
                }
            });
        }
        this.addSlot(new SlotTabbed((IInventory)this.player.field_71071_by, 40, 77, 62){

            @Nullable
            @SideOnly(value=Side.CLIENT)
            public String func_178171_c() {
                return "minecraft:items/empty_armor_slot_shield";
            }
        });
        ISpecialEquipment equipment = Utils.getSpecialEquipment(player);
        if (equipment != null) {
            this.addSlot((Slot)new SlotBelt((IItemHandler)equipment.getStackHandler(), EnumEntitys.SpecialEquipmentSlot.BELT.getSlot(), 77, 26, this.container));
            this.addSlot((Slot)new SlotODMGear((IItemHandler)equipment.getStackHandler(), EnumEntitys.SpecialEquipmentSlot.ODM_GEAR.getSlot(), 77, 8, this.container));
        }
    }

    @Override
    public void onCraftMatrixChanged(IInventory inventoryIn) {
        this.slotChangedCraftingGrid(this.player.field_70170_p, this.player, this.craftMatrix, this.craftResult);
    }

    @Override
    public void slotChangedCraftingGrid(World world, EntityPlayer player, InventoryCrafting invCrafting, InventoryCraftResult invCraftResult) {
        if (!world.field_72995_K) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)player;
            ItemStack itemstack = ItemStack.field_190927_a;
            IRecipe irecipe = CraftingManager.func_192413_b((InventoryCrafting)invCrafting, (World)world);
            if (irecipe != null && (irecipe.func_192399_d() || !world.func_82736_K().func_82766_b("doLimitedCrafting") || entityplayermp.func_192037_E().func_193830_f(irecipe))) {
                invCraftResult.func_193056_a(irecipe);
                itemstack = irecipe.func_77572_b(invCrafting);
            }
            invCraftResult.func_70299_a(0, itemstack);
            entityplayermp.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(this.container.field_75152_c, 0, itemstack));
        }
    }

    @Override
    public InventoryCrafting getInventoryCrafting() {
        return this.craftMatrix;
    }

    @Override
    public InventoryCraftResult getInventoryCraftReslut() {
        return this.craftResult;
    }

    @Override
    public void onContainerClosed() {
        this.craftResult.func_174888_l();
        if (!this.player.field_70170_p.field_72995_K) {
            this.container.clearInventory(this.player, this.player.field_70170_p, (IInventory)this.craftMatrix);
        }
    }

    @Override
    public boolean transferStackInSlot(EntityPlayer player, int index) {
        Slot slot = (Slot)this.container.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            EntityEquipmentSlot entityequipmentslot = EntityLiving.func_184640_d((ItemStack)stack);
            if (entityequipmentslot.func_188453_a() == EntityEquipmentSlot.Type.ARMOR) {
                int i = 8 - entityequipmentslot.func_188454_b();
                if (Utils.mergeItemStack(this.getSlots(), stack, i, i + 1, false)) {
                    return true;
                }
            } else if (entityequipmentslot == EntityEquipmentSlot.OFFHAND ? Utils.mergeItemStack(this.getSlots(), stack, 9, 10, false) : (stack.func_77973_b().equals(ItemInit.BELT) ? Utils.mergeItemStack(this.getSlots(), stack, 10, 11, false) : stack.func_77973_b().equals(ItemInit.ODM_GEAR) && Utils.mergeItemStack(this.getSlots(), stack, 11, 12, false))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canMergeSlot(ItemStack stack, Slot slotIn) {
        return slotIn.field_75224_c != this.craftResult && super.canMergeSlot(stack, slotIn);
    }
}

