/*
 * Decompiled with CFR 0.152.
 */
package lyon.aom.gui.tabbed_survival.tabs.odm_gear_tab;

import javax.annotation.Nullable;
import lyon.aom.capabilities.odm_gear.IODMGear;
import lyon.aom.capabilities.special_equipment.ISpecialEquipment;
import lyon.aom.gui.ExchangeableItemStackHandler;
import lyon.aom.gui.tabbed_survival.ContainerTabbedSurvival;
import lyon.aom.gui.tabbed_survival.tabs.SurvivalTab;
import lyon.aom.gui.tabbed_survival.tabs.slots.SlotBlade;
import lyon.aom.gui.tabbed_survival.tabs.slots.SlotGasCartridge;
import lyon.aom.gui.tabbed_survival.tabs.slots.SlotHandle;
import lyon.aom.gui.tabbed_survival.tabs.slots.SlotTabbed;
import lyon.aom.gui.tabbed_survival.tabs.slots.SlotThunderspear;
import lyon.aom.init.ItemInit;
import lyon.aom.utils.Utils;
import lyon.aom.utils.enums.EnumEntitys;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class SurvivalTabODMGear
extends SurvivalTab {
    private static final EntityEquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
    private EntityPlayer player;
    private ContainerTabbedSurvival container;
    private ExchangeableItemStackHandler odmGearHandler = new ExchangeableItemStackHandler(new ItemStackHandler(14));

    public SurvivalTabODMGear(final EntityPlayer player, ContainerTabbedSurvival container) {
        super("odm_gear", ItemInit.ODM_GEAR);
        this.player = player;
        this.container = container;
        for (int k = 0; k < 4; ++k) {
            final EntityEquipmentSlot entityequipmentslot = VALID_EQUIPMENT_SLOTS[k];
            this.addSlot(new SlotTabbed((IInventory)this.player.field_71071_by, 36 + (3 - k), 8, 8 + k * 18){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(ItemStack stack) {
                    return stack.func_77973_b().isValidArmor(stack, entityequipmentslot, (Entity)player);
                }

                public boolean func_82869_a(EntityPlayer playerIn) {
                    ItemStack itemstack = this.func_75211_c();
                    return !itemstack.func_190926_b() && !playerIn.func_184812_l_() && EnchantmentHelper.func_190938_b((ItemStack)itemstack) ? false : super.func_82869_a(playerIn);
                }

                @Nullable
                @SideOnly(value=Side.CLIENT)
                public String func_178171_c() {
                    return ItemArmor.field_94603_a[entityequipmentslot.func_188454_b()];
                }
            });
        }
        IODMGear odm_gear = Utils.getODMGear(player);
        if (odm_gear != null) {
            this.odmGearHandler.setStackHandler(odm_gear.getStackHandler());
        }
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < 4; ++x) {
                this.addSlot((Slot)new SlotBlade((IItemHandler)this.odmGearHandler, x + y * 4, 80 + x * 18, 26 + y * 18, this.container));
            }
        }
        this.addSlot((Slot)new SlotGasCartridge((IItemHandler)this.odmGearHandler, 8, 152, 26, this.container));
        this.addSlot((Slot)new SlotGasCartridge((IItemHandler)this.odmGearHandler, 9, 152, 44, this.container));
        this.addSlot((Slot)new SlotHandle((IItemHandler)this.odmGearHandler, 10, 80, 8, this.container));
        this.addSlot((Slot)new SlotHandle((IItemHandler)this.odmGearHandler, 11, 80, 62, this.container));
        this.addSlot((Slot)new SlotThunderspear((IItemHandler)this.odmGearHandler, 12, 98, 8, this.container));
        this.addSlot((Slot)new SlotThunderspear((IItemHandler)this.odmGearHandler, 13, 98, 62, this.container));
    }

    @Override
    public boolean isVisible() {
        ISpecialEquipment equipment = Utils.getSpecialEquipment(this.player);
        return equipment != null && equipment.getEquipment(EnumEntitys.SpecialEquipmentSlot.ODM_GEAR).func_77973_b().equals(ItemInit.ODM_GEAR);
    }

    @Override
    public boolean transferStackInSlot(EntityPlayer player, int index) {
        Slot slot = (Slot)this.container.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            EntityEquipmentSlot entityequipmentslot = EntityLiving.func_184640_d((ItemStack)stack);
            if (entityequipmentslot.func_188453_a() == EntityEquipmentSlot.Type.ARMOR) {
                int i = 3 - entityequipmentslot.func_188454_b();
                if (Utils.mergeItemStack(this.getSlots(), stack, i, i + 1, false)) {
                    return true;
                }
            } else if (stack.func_77973_b().equals(ItemInit.BLADE) ? Utils.mergeItemStack(this.getSlots(), stack, 4, 12, false) : (stack.func_77973_b().equals(ItemInit.GAS_CARTRIDGE) ? Utils.mergeItemStack(this.getSlots(), stack, 12, 14, false) : (stack.func_77973_b().equals(ItemInit.HANDLE) ? Utils.mergeItemStack(this.getSlots(), stack, 14, 16, false) : stack.func_77973_b().equals(ItemInit.THUNDERSPEAR) && Utils.mergeItemStack(this.getSlots(), stack, 15, 18, false)))) {
                return true;
            }
        }
        return false;
    }

    public ExchangeableItemStackHandler getODMGearHandler() {
        return this.odmGearHandler;
    }
}

